<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Worker_Rate_Standard_Cost_Rate_DetailsType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Worker Rate Standard Cost rate data
 * @subpackage Structs
 */
class Project_Worker_Rate_Standard_Cost_Rate_DetailsType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Project_Worker_Rate_Standard_Cost_Rate_Detail_ID
     * Meta information extracted from the WSDL
     * - documentation: Worker Rate Standard Cost Rate ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Worker_Rate_Standard_Cost_Rate_Detail_ID;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Hourly_Rate
     * Meta information extracted from the WSDL
     * - documentation: Project rate rule hourly rate
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 18
     * @var float
     */
    public $Hourly_Rate;
    /**
     * Constructor method for Project_Worker_Rate_Standard_Cost_Rate_DetailsType
     * @uses Project_Worker_Rate_Standard_Cost_Rate_DetailsType::setDelete()
     * @uses Project_Worker_Rate_Standard_Cost_Rate_DetailsType::setProject_Worker_Rate_Standard_Cost_Rate_Detail_ID()
     * @uses Project_Worker_Rate_Standard_Cost_Rate_DetailsType::setWorker_Reference()
     * @uses Project_Worker_Rate_Standard_Cost_Rate_DetailsType::setHourly_Rate()
     * @param bool $delete
     * @param string $project_Worker_Rate_Standard_Cost_Rate_Detail_ID
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param float $hourly_Rate
     */
    public function __construct($delete = null, $project_Worker_Rate_Standard_Cost_Rate_Detail_ID = null, \StructType\WorkerObjectType $worker_Reference = null, $hourly_Rate = null)
    {
        $this
            ->setDelete($delete)
            ->setProject_Worker_Rate_Standard_Cost_Rate_Detail_ID($project_Worker_Rate_Standard_Cost_Rate_Detail_ID)
            ->setWorker_Reference($worker_Reference)
            ->setHourly_Rate($hourly_Rate);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Project_Worker_Rate_Standard_Cost_Rate_Detail_ID value
     * @return string|null
     */
    public function getProject_Worker_Rate_Standard_Cost_Rate_Detail_ID()
    {
        return $this->Project_Worker_Rate_Standard_Cost_Rate_Detail_ID;
    }
    /**
     * Set Project_Worker_Rate_Standard_Cost_Rate_Detail_ID value
     * @param string $project_Worker_Rate_Standard_Cost_Rate_Detail_ID
     * @return \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType
     */
    public function setProject_Worker_Rate_Standard_Cost_Rate_Detail_ID($project_Worker_Rate_Standard_Cost_Rate_Detail_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Worker_Rate_Standard_Cost_Rate_Detail_ID) && !is_string($project_Worker_Rate_Standard_Cost_Rate_Detail_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Worker_Rate_Standard_Cost_Rate_Detail_ID, true), gettype($project_Worker_Rate_Standard_Cost_Rate_Detail_ID)), __LINE__);
        }
        $this->Project_Worker_Rate_Standard_Cost_Rate_Detail_ID = $project_Worker_Rate_Standard_Cost_Rate_Detail_ID;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Hourly_Rate value
     * @return float|null
     */
    public function getHourly_Rate()
    {
        return $this->Hourly_Rate;
    }
    /**
     * Set Hourly_Rate value
     * @param float $hourly_Rate
     * @return \StructType\Project_Worker_Rate_Standard_Cost_Rate_DetailsType
     */
    public function setHourly_Rate($hourly_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($hourly_Rate) && !(is_float($hourly_Rate) || is_numeric($hourly_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hourly_Rate, true), gettype($hourly_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($hourly_Rate) && mb_strlen(mb_substr($hourly_Rate, false !== mb_strpos($hourly_Rate, '.') ? mb_strpos($hourly_Rate, '.') + 1 : mb_strlen($hourly_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($hourly_Rate, true), mb_strlen(mb_substr($hourly_Rate, mb_strpos($hourly_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($hourly_Rate) && $hourly_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($hourly_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($hourly_Rate) && mb_strlen(preg_replace('/(\D)/', '', $hourly_Rate)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($hourly_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $hourly_Rate))), __LINE__);
        }
        $this->Hourly_Rate = $hourly_Rate;
        return $this;
    }
}
