<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Delivery_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing criteria used to retrieve Internal Service Deliveries.
 * @subpackage Structs
 */
class Internal_Service_Delivery_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing companies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Internal Service Providers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_ProviderObjectType[]
     */
    public $Internal_Service_Provider_Reference;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Document Statuses.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Document_Status_Reference;
    /**
     * The Document_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Document Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date_On_or_Before;
    /**
     * The Document_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Document Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date_On_or_After;
    /**
     * The Intercompany_Internal_Service_Delivery
     * Meta information extracted from the WSDL
     * - documentation: Is Internal Service Delivery for Intercompany
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Intercompany_Internal_Service_Delivery;
    /**
     * The Created_by_Workers_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Workers that created Internal Service Deliveries
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Created_by_Workers_Reference;
    /**
     * The Approved_by_Workers_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Workers that approved Internal Service Deliveries
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Approved_by_Workers_Reference;
    /**
     * The Internal_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Internal Service Catalogs
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_CatalogObjectType[]
     */
    public $Internal_Catalog_Reference;
    /**
     * Constructor method for Internal_Service_Delivery_Request_CriteriaType
     * @uses Internal_Service_Delivery_Request_CriteriaType::setCompany_Reference()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setInternal_Service_Provider_Reference()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setDocument_Status_Reference()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setDocument_Date_On_or_Before()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setDocument_Date_On_or_After()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setIntercompany_Internal_Service_Delivery()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setCreated_by_Workers_Reference()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setApproved_by_Workers_Reference()
     * @uses Internal_Service_Delivery_Request_CriteriaType::setInternal_Catalog_Reference()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Internal_Service_ProviderObjectType[] $internal_Service_Provider_Reference
     * @param \StructType\Document_StatusObjectType[] $document_Status_Reference
     * @param string $document_Date_On_or_Before
     * @param string $document_Date_On_or_After
     * @param bool $intercompany_Internal_Service_Delivery
     * @param \StructType\WorkerObjectType[] $created_by_Workers_Reference
     * @param \StructType\WorkerObjectType[] $approved_by_Workers_Reference
     * @param \StructType\Internal_Service_CatalogObjectType[] $internal_Catalog_Reference
     */
    public function __construct(array $company_Reference = array(), array $internal_Service_Provider_Reference = array(), array $document_Status_Reference = array(), $document_Date_On_or_Before = null, $document_Date_On_or_After = null, $intercompany_Internal_Service_Delivery = null, array $created_by_Workers_Reference = array(), array $approved_by_Workers_Reference = array(), array $internal_Catalog_Reference = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setDocument_Date_On_or_Before($document_Date_On_or_Before)
            ->setDocument_Date_On_or_After($document_Date_On_or_After)
            ->setIntercompany_Internal_Service_Delivery($intercompany_Internal_Service_Delivery)
            ->setCreated_by_Workers_Reference($created_by_Workers_Reference)
            ->setApproved_by_Workers_Reference($approved_by_Workers_Reference)
            ->setInternal_Catalog_Reference($internal_Catalog_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($internal_Service_Delivery_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Request_CriteriaTypeCompany_ReferenceItem), var_export($internal_Service_Delivery_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType[]|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Provider_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Provider_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Provider_ReferenceForArrayConstraintsFromSetInternal_Service_Provider_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Request_CriteriaTypeInternal_Service_Provider_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Request_CriteriaTypeInternal_Service_Provider_ReferenceItem instanceof \StructType\Internal_Service_ProviderObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Request_CriteriaTypeInternal_Service_Provider_ReferenceItem) ? get_class($internal_Service_Delivery_Request_CriteriaTypeInternal_Service_Provider_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Request_CriteriaTypeInternal_Service_Provider_ReferenceItem), var_export($internal_Service_Delivery_Request_CriteriaTypeInternal_Service_Provider_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Provider_Reference property can only contain items of type \StructType\Internal_Service_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_ProviderObjectType[] $internal_Service_Provider_Reference
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setInternal_Service_Provider_Reference(array $internal_Service_Provider_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Provider_ReferenceArrayErrorMessage = self::validateInternal_Service_Provider_ReferenceForArrayConstraintsFromSetInternal_Service_Provider_Reference($internal_Service_Provider_Reference))) {
            throw new \InvalidArgumentException($internal_Service_Provider_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Add item to Internal_Service_Provider_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_ProviderObjectType $item
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function addToInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Provider_Reference property can only contain items of type \StructType\Internal_Service_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Provider_Reference[] = $item;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocument_Status_ReferenceForArrayConstraintsFromSetDocument_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Request_CriteriaTypeDocument_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Request_CriteriaTypeDocument_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Request_CriteriaTypeDocument_Status_ReferenceItem) ? get_class($internal_Service_Delivery_Request_CriteriaTypeDocument_Status_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Request_CriteriaTypeDocument_Status_ReferenceItem), var_export($internal_Service_Delivery_Request_CriteriaTypeDocument_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $document_Status_Reference
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setDocument_Status_Reference(array $document_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($document_Status_ReferenceArrayErrorMessage = self::validateDocument_Status_ReferenceForArrayConstraintsFromSetDocument_Status_Reference($document_Status_Reference))) {
            throw new \InvalidArgumentException($document_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Add item to Document_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function addToDocument_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Document_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Document_Date_On_or_Before value
     * @return string|null
     */
    public function getDocument_Date_On_or_Before()
    {
        return $this->Document_Date_On_or_Before;
    }
    /**
     * Set Document_Date_On_or_Before value
     * @param string $document_Date_On_or_Before
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setDocument_Date_On_or_Before($document_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date_On_or_Before) && !is_string($document_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date_On_or_Before, true), gettype($document_Date_On_or_Before)), __LINE__);
        }
        $this->Document_Date_On_or_Before = $document_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Document_Date_On_or_After value
     * @return string|null
     */
    public function getDocument_Date_On_or_After()
    {
        return $this->Document_Date_On_or_After;
    }
    /**
     * Set Document_Date_On_or_After value
     * @param string $document_Date_On_or_After
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setDocument_Date_On_or_After($document_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date_On_or_After) && !is_string($document_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date_On_or_After, true), gettype($document_Date_On_or_After)), __LINE__);
        }
        $this->Document_Date_On_or_After = $document_Date_On_or_After;
        return $this;
    }
    /**
     * Get Intercompany_Internal_Service_Delivery value
     * @return bool|null
     */
    public function getIntercompany_Internal_Service_Delivery()
    {
        return $this->Intercompany_Internal_Service_Delivery;
    }
    /**
     * Set Intercompany_Internal_Service_Delivery value
     * @param bool $intercompany_Internal_Service_Delivery
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setIntercompany_Internal_Service_Delivery($intercompany_Internal_Service_Delivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($intercompany_Internal_Service_Delivery) && !is_bool($intercompany_Internal_Service_Delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($intercompany_Internal_Service_Delivery, true), gettype($intercompany_Internal_Service_Delivery)), __LINE__);
        }
        $this->Intercompany_Internal_Service_Delivery = $intercompany_Internal_Service_Delivery;
        return $this;
    }
    /**
     * Get Created_by_Workers_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreated_by_Workers_Reference()
    {
        return $this->Created_by_Workers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreated_by_Workers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreated_by_Workers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreated_by_Workers_ReferenceForArrayConstraintsFromSetCreated_by_Workers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Request_CriteriaTypeCreated_by_Workers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Request_CriteriaTypeCreated_by_Workers_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Request_CriteriaTypeCreated_by_Workers_ReferenceItem) ? get_class($internal_Service_Delivery_Request_CriteriaTypeCreated_by_Workers_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Request_CriteriaTypeCreated_by_Workers_ReferenceItem), var_export($internal_Service_Delivery_Request_CriteriaTypeCreated_by_Workers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Created_by_Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Created_by_Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $created_by_Workers_Reference
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setCreated_by_Workers_Reference(array $created_by_Workers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($created_by_Workers_ReferenceArrayErrorMessage = self::validateCreated_by_Workers_ReferenceForArrayConstraintsFromSetCreated_by_Workers_Reference($created_by_Workers_Reference))) {
            throw new \InvalidArgumentException($created_by_Workers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Created_by_Workers_Reference = $created_by_Workers_Reference;
        return $this;
    }
    /**
     * Add item to Created_by_Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function addToCreated_by_Workers_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Created_by_Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Created_by_Workers_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approved_by_Workers_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getApproved_by_Workers_Reference()
    {
        return $this->Approved_by_Workers_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApproved_by_Workers_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproved_by_Workers_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproved_by_Workers_ReferenceForArrayConstraintsFromSetApproved_by_Workers_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Request_CriteriaTypeApproved_by_Workers_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Request_CriteriaTypeApproved_by_Workers_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Request_CriteriaTypeApproved_by_Workers_ReferenceItem) ? get_class($internal_Service_Delivery_Request_CriteriaTypeApproved_by_Workers_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Request_CriteriaTypeApproved_by_Workers_ReferenceItem), var_export($internal_Service_Delivery_Request_CriteriaTypeApproved_by_Workers_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approved_by_Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approved_by_Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $approved_by_Workers_Reference
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setApproved_by_Workers_Reference(array $approved_by_Workers_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($approved_by_Workers_ReferenceArrayErrorMessage = self::validateApproved_by_Workers_ReferenceForArrayConstraintsFromSetApproved_by_Workers_Reference($approved_by_Workers_Reference))) {
            throw new \InvalidArgumentException($approved_by_Workers_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Approved_by_Workers_Reference = $approved_by_Workers_Reference;
        return $this;
    }
    /**
     * Add item to Approved_by_Workers_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function addToApproved_by_Workers_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Approved_by_Workers_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approved_by_Workers_Reference[] = $item;
        return $this;
    }
    /**
     * Get Internal_Catalog_Reference value
     * @return \StructType\Internal_Service_CatalogObjectType[]|null
     */
    public function getInternal_Catalog_Reference()
    {
        return $this->Internal_Catalog_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Catalog_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Catalog_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Catalog_ReferenceForArrayConstraintsFromSetInternal_Catalog_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Request_CriteriaTypeInternal_Catalog_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Request_CriteriaTypeInternal_Catalog_ReferenceItem instanceof \StructType\Internal_Service_CatalogObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Request_CriteriaTypeInternal_Catalog_ReferenceItem) ? get_class($internal_Service_Delivery_Request_CriteriaTypeInternal_Catalog_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Request_CriteriaTypeInternal_Catalog_ReferenceItem), var_export($internal_Service_Delivery_Request_CriteriaTypeInternal_Catalog_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Catalog_Reference property can only contain items of type \StructType\Internal_Service_CatalogObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_CatalogObjectType[] $internal_Catalog_Reference
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function setInternal_Catalog_Reference(array $internal_Catalog_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Catalog_ReferenceArrayErrorMessage = self::validateInternal_Catalog_ReferenceForArrayConstraintsFromSetInternal_Catalog_Reference($internal_Catalog_Reference))) {
            throw new \InvalidArgumentException($internal_Catalog_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Internal_Catalog_Reference = $internal_Catalog_Reference;
        return $this;
    }
    /**
     * Add item to Internal_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_CatalogObjectType $item
     * @return \StructType\Internal_Service_Delivery_Request_CriteriaType
     */
    public function addToInternal_Catalog_Reference(\StructType\Internal_Service_CatalogObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_CatalogObjectType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Catalog_Reference property can only contain items of type \StructType\Internal_Service_CatalogObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Catalog_Reference[] = $item;
        return $this;
    }
}
