<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Web_Item_Attributes_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains references to existing Web Item Attributes to be retrieved. Please note that this is mutually exclusive with the Request Criteria element.
 * @subpackage Structs
 */
class Web_Item_Attributes_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Web_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Web Item.
     * - maxOccurs: unbounded
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Web_Item_Reference;
    /**
     * Constructor method for Web_Item_Attributes_Request_ReferencesType
     * @uses Web_Item_Attributes_Request_ReferencesType::setWeb_Item_Reference()
     * @param \StructType\Unique_IdentifierObjectType[] $web_Item_Reference
     */
    public function __construct(array $web_Item_Reference = array())
    {
        $this
            ->setWeb_Item_Reference($web_Item_Reference);
    }
    /**
     * Get Web_Item_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getWeb_Item_Reference()
    {
        return $this->Web_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWeb_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeb_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeb_Item_ReferenceForArrayConstraintsFromSetWeb_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $web_Item_Attributes_Request_ReferencesTypeWeb_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$web_Item_Attributes_Request_ReferencesTypeWeb_Item_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($web_Item_Attributes_Request_ReferencesTypeWeb_Item_ReferenceItem) ? get_class($web_Item_Attributes_Request_ReferencesTypeWeb_Item_ReferenceItem) : sprintf('%s(%s)', gettype($web_Item_Attributes_Request_ReferencesTypeWeb_Item_ReferenceItem), var_export($web_Item_Attributes_Request_ReferencesTypeWeb_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Web_Item_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Web_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $web_Item_Reference
     * @return \StructType\Web_Item_Attributes_Request_ReferencesType
     */
    public function setWeb_Item_Reference(array $web_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($web_Item_ReferenceArrayErrorMessage = self::validateWeb_Item_ReferenceForArrayConstraintsFromSetWeb_Item_Reference($web_Item_Reference))) {
            throw new \InvalidArgumentException($web_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Web_Item_Reference = $web_Item_Reference;
        return $this;
    }
    /**
     * Add item to Web_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Web_Item_Attributes_Request_ReferencesType
     */
    public function addToWeb_Item_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Web_Item_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Web_Item_Reference[] = $item;
        return $this;
    }
}
