<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UNSPSC_Code_RangeType StructType
 * Meta information extracted from the WSDL
 * - documentation: UNSPSC Code Range From is greater than UNSPSC Code Range To | If Use on PO is flagged, then the UNSPSC Code Range From and Range To codes must match. | Element that contains the UNSPC Code information.
 * @subpackage Structs
 */
class UNSPSC_Code_RangeType extends AbstractStructBase
{
    /**
     * The UNSPSC_Value_Reference
     * Meta information extracted from the WSDL
     * - documentation: The UNSPC reference element content used for Spend Categories.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $UNSPSC_Value_Reference;
    /**
     * The Range_From
     * Meta information extracted from the WSDL
     * - documentation: The UNSPC Code Range Start. It is a numeric field that is the start of a range.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Range_From;
    /**
     * The Range_To
     * Meta information extracted from the WSDL
     * - documentation: UNSPC Code Range To. The end range of the UNSPC code.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Range_To;
    /**
     * The Use_on_PO
     * Meta information extracted from the WSDL
     * - documentation: The UNSPC Code can be used on POs if the Range From and To codes are the same.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_on_PO;
    /**
     * Constructor method for UNSPSC_Code_RangeType
     * @uses UNSPSC_Code_RangeType::setUNSPSC_Value_Reference()
     * @uses UNSPSC_Code_RangeType::setRange_From()
     * @uses UNSPSC_Code_RangeType::setRange_To()
     * @uses UNSPSC_Code_RangeType::setUse_on_PO()
     * @param \StructType\Unique_IdentifierObjectType $uNSPSC_Value_Reference
     * @param float $range_From
     * @param float $range_To
     * @param bool $use_on_PO
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $uNSPSC_Value_Reference = null, $range_From = null, $range_To = null, $use_on_PO = null)
    {
        $this
            ->setUNSPSC_Value_Reference($uNSPSC_Value_Reference)
            ->setRange_From($range_From)
            ->setRange_To($range_To)
            ->setUse_on_PO($use_on_PO);
    }
    /**
     * Get UNSPSC_Value_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getUNSPSC_Value_Reference()
    {
        return $this->UNSPSC_Value_Reference;
    }
    /**
     * Set UNSPSC_Value_Reference value
     * @param \StructType\Unique_IdentifierObjectType $uNSPSC_Value_Reference
     * @return \StructType\UNSPSC_Code_RangeType
     */
    public function setUNSPSC_Value_Reference(\StructType\Unique_IdentifierObjectType $uNSPSC_Value_Reference = null)
    {
        $this->UNSPSC_Value_Reference = $uNSPSC_Value_Reference;
        return $this;
    }
    /**
     * Get Range_From value
     * @return float|null
     */
    public function getRange_From()
    {
        return $this->Range_From;
    }
    /**
     * Set Range_From value
     * @param float $range_From
     * @return \StructType\UNSPSC_Code_RangeType
     */
    public function setRange_From($range_From = null)
    {
        // validation for constraint: float
        if (!is_null($range_From) && !(is_float($range_From) || is_numeric($range_From))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($range_From, true), gettype($range_From)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($range_From) && mb_strlen(mb_substr($range_From, false !== mb_strpos($range_From, '.') ? mb_strpos($range_From, '.') + 1 : mb_strlen($range_From))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($range_From, true), mb_strlen(mb_substr($range_From, mb_strpos($range_From, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($range_From) && $range_From < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($range_From, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($range_From) && mb_strlen(preg_replace('/(\D)/', '', $range_From)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($range_From, true), mb_strlen(preg_replace('/(\D)/', '', $range_From))), __LINE__);
        }
        $this->Range_From = $range_From;
        return $this;
    }
    /**
     * Get Range_To value
     * @return float|null
     */
    public function getRange_To()
    {
        return $this->Range_To;
    }
    /**
     * Set Range_To value
     * @param float $range_To
     * @return \StructType\UNSPSC_Code_RangeType
     */
    public function setRange_To($range_To = null)
    {
        // validation for constraint: float
        if (!is_null($range_To) && !(is_float($range_To) || is_numeric($range_To))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($range_To, true), gettype($range_To)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($range_To) && mb_strlen(mb_substr($range_To, false !== mb_strpos($range_To, '.') ? mb_strpos($range_To, '.') + 1 : mb_strlen($range_To))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($range_To, true), mb_strlen(mb_substr($range_To, mb_strpos($range_To, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($range_To) && $range_To < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($range_To, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($range_To) && mb_strlen(preg_replace('/(\D)/', '', $range_To)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($range_To, true), mb_strlen(preg_replace('/(\D)/', '', $range_To))), __LINE__);
        }
        $this->Range_To = $range_To;
        return $this;
    }
    /**
     * Get Use_on_PO value
     * @return bool|null
     */
    public function getUse_on_PO()
    {
        return $this->Use_on_PO;
    }
    /**
     * Set Use_on_PO value
     * @param bool $use_on_PO
     * @return \StructType\UNSPSC_Code_RangeType
     */
    public function setUse_on_PO($use_on_PO = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_on_PO) && !is_bool($use_on_PO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_on_PO, true), gettype($use_on_PO)), __LINE__);
        }
        $this->Use_on_PO = $use_on_PO;
        return $this;
    }
}
