<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Group_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Supplier Group
 * @subpackage Structs
 */
class Supplier_Group_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Group
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_GroupObjectType[]
     */
    public $Supplier_Group_Reference;
    /**
     * Constructor method for Supplier_Group_Request_ReferencesType
     * @uses Supplier_Group_Request_ReferencesType::setSupplier_Group_Reference()
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     */
    public function __construct(array $supplier_Group_Reference = array())
    {
        $this
            ->setSupplier_Group_Reference($supplier_Group_Reference);
    }
    /**
     * Get Supplier_Group_Reference value
     * @return \StructType\Supplier_GroupObjectType[]|null
     */
    public function getSupplier_Group_Reference()
    {
        return $this->Supplier_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Group_Request_ReferencesTypeSupplier_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Group_Request_ReferencesTypeSupplier_Group_ReferenceItem instanceof \StructType\Supplier_GroupObjectType) {
                $invalidValues[] = is_object($supplier_Group_Request_ReferencesTypeSupplier_Group_ReferenceItem) ? get_class($supplier_Group_Request_ReferencesTypeSupplier_Group_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Group_Request_ReferencesTypeSupplier_Group_ReferenceItem), var_export($supplier_Group_Request_ReferencesTypeSupplier_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType[] $supplier_Group_Reference
     * @return \StructType\Supplier_Group_Request_ReferencesType
     */
    public function setSupplier_Group_Reference(array $supplier_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Group_ReferenceArrayErrorMessage = self::validateSupplier_Group_ReferenceForArrayConstraintsFromSetSupplier_Group_Reference($supplier_Group_Reference))) {
            throw new \InvalidArgumentException($supplier_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Group_Reference = $supplier_Group_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupObjectType $item
     * @return \StructType\Supplier_Group_Request_ReferencesType
     */
    public function addToSupplier_Group_Reference(\StructType\Supplier_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Group_Reference property can only contain items of type \StructType\Supplier_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Group_Reference[] = $item;
        return $this;
    }
}
