<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Interface_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You may not add duplicate classification fields to a supplier classification. | Supplier Classification Interface WWS Data element to configure one or more Supplier Classifications for a Supplier
 * @subpackage Structs
 */
class Supplier_Classification_Interface_WWS_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification Reference ID is required to uniquely identify a Supplier Classification for updating and deleting
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Classification_Reference_ID;
    /**
     * The Supplier_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier Classification to configure for the Supplier
     * @var \StructType\Custom_Supplier_ClassificationObjectType
     */
    public $Supplier_Classification_Reference;
    /**
     * The Supplier_Classification_Field_Interface_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification Field Interface Data element to configure one or more Supplier Classification Fields for a Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Classification_Field_Interface_DataType[]
     */
    public $Supplier_Classification_Field_Interface_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to True in order to delete Supplier Classification
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Supplier_Classification_Interface_WWS_DataType
     * @uses Supplier_Classification_Interface_WWS_DataType::setSupplier_Classification_Reference_ID()
     * @uses Supplier_Classification_Interface_WWS_DataType::setSupplier_Classification_Reference()
     * @uses Supplier_Classification_Interface_WWS_DataType::setSupplier_Classification_Field_Interface_Data()
     * @uses Supplier_Classification_Interface_WWS_DataType::setDelete()
     * @param string $supplier_Classification_Reference_ID
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @param \StructType\Supplier_Classification_Field_Interface_DataType[] $supplier_Classification_Field_Interface_Data
     * @param bool $delete
     */
    public function __construct($supplier_Classification_Reference_ID = null, \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null, array $supplier_Classification_Field_Interface_Data = array(), $delete = null)
    {
        $this
            ->setSupplier_Classification_Reference_ID($supplier_Classification_Reference_ID)
            ->setSupplier_Classification_Reference($supplier_Classification_Reference)
            ->setSupplier_Classification_Field_Interface_Data($supplier_Classification_Field_Interface_Data)
            ->setDelete($delete);
    }
    /**
     * Get Supplier_Classification_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Classification_Reference_ID()
    {
        return $this->Supplier_Classification_Reference_ID;
    }
    /**
     * Set Supplier_Classification_Reference_ID value
     * @param string $supplier_Classification_Reference_ID
     * @return \StructType\Supplier_Classification_Interface_WWS_DataType
     */
    public function setSupplier_Classification_Reference_ID($supplier_Classification_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Classification_Reference_ID) && !is_string($supplier_Classification_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Classification_Reference_ID, true), gettype($supplier_Classification_Reference_ID)), __LINE__);
        }
        $this->Supplier_Classification_Reference_ID = $supplier_Classification_Reference_ID;
        return $this;
    }
    /**
     * Get Supplier_Classification_Reference value
     * @return \StructType\Custom_Supplier_ClassificationObjectType|null
     */
    public function getSupplier_Classification_Reference()
    {
        return $this->Supplier_Classification_Reference;
    }
    /**
     * Set Supplier_Classification_Reference value
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @return \StructType\Supplier_Classification_Interface_WWS_DataType
     */
    public function setSupplier_Classification_Reference(\StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null)
    {
        $this->Supplier_Classification_Reference = $supplier_Classification_Reference;
        return $this;
    }
    /**
     * Get Supplier_Classification_Field_Interface_Data value
     * @return \StructType\Supplier_Classification_Field_Interface_DataType[]|null
     */
    public function getSupplier_Classification_Field_Interface_Data()
    {
        return $this->Supplier_Classification_Field_Interface_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification_Field_Interface_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification_Field_Interface_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Classification_Field_Interface_DataForArrayConstraintsFromSetSupplier_Classification_Field_Interface_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Classification_Interface_WWS_DataTypeSupplier_Classification_Field_Interface_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Classification_Interface_WWS_DataTypeSupplier_Classification_Field_Interface_DataItem instanceof \StructType\Supplier_Classification_Field_Interface_DataType) {
                $invalidValues[] = is_object($supplier_Classification_Interface_WWS_DataTypeSupplier_Classification_Field_Interface_DataItem) ? get_class($supplier_Classification_Interface_WWS_DataTypeSupplier_Classification_Field_Interface_DataItem) : sprintf('%s(%s)', gettype($supplier_Classification_Interface_WWS_DataTypeSupplier_Classification_Field_Interface_DataItem), var_export($supplier_Classification_Interface_WWS_DataTypeSupplier_Classification_Field_Interface_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification_Field_Interface_Data property can only contain items of type \StructType\Supplier_Classification_Field_Interface_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification_Field_Interface_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Field_Interface_DataType[] $supplier_Classification_Field_Interface_Data
     * @return \StructType\Supplier_Classification_Interface_WWS_DataType
     */
    public function setSupplier_Classification_Field_Interface_Data(array $supplier_Classification_Field_Interface_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Classification_Field_Interface_DataArrayErrorMessage = self::validateSupplier_Classification_Field_Interface_DataForArrayConstraintsFromSetSupplier_Classification_Field_Interface_Data($supplier_Classification_Field_Interface_Data))) {
            throw new \InvalidArgumentException($supplier_Classification_Field_Interface_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification_Field_Interface_Data = $supplier_Classification_Field_Interface_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Classification_Field_Interface_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_Field_Interface_DataType $item
     * @return \StructType\Supplier_Classification_Interface_WWS_DataType
     */
    public function addToSupplier_Classification_Field_Interface_Data(\StructType\Supplier_Classification_Field_Interface_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Classification_Field_Interface_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification_Field_Interface_Data property can only contain items of type \StructType\Supplier_Classification_Field_Interface_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification_Field_Interface_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Supplier_Classification_Interface_WWS_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
