<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier reference is for a supplier that can be used as a basic worktag only. | Updated From Date must be earlier than Updated To Date | Purchase Order Date On or After must be earlier than Purchase Order Date On or Before. | Due
 * Date On or After must be earlier than Due Date On or Before. | Organization Reference must be Companies or Company Hierarchies | Utilize the following element to find purchase orders in the Workday system.
 * @subpackage Structs
 */
class Purchase_Order_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier or Contingent Worker
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Purchase_Order_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Purchase Order Types in the system.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType[]
     */
    public $Purchase_Order_Type_Reference;
    /**
     * The Purchase_Order_Number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Number. Allows for search for a partial sub-string match.
     * - base: xsd:string
     * - maxLength: 513
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Number;
    /**
     * The Purchase_Order_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Date_On_or_After;
    /**
     * The Purchase_Order_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Date_On_or_Before;
    /**
     * The Due_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Due Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date_On_or_After;
    /**
     * The Due_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Due Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date_On_or_Before;
    /**
     * The Updated_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Changed Date on or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_From_Date;
    /**
     * The Updated_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Changed Date on or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Updated_To_Date;
    /**
     * The Purchase_Order_Change_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the following Purchase Order Changes for search: - Change Order (WID:a602097bdd5b4fa180006baefedcd2c9) - Issue (WID:1b796240e3de4915a3ecaff766d0f704) - Cancel (WID:cf071027bbd74c3cad95b8e1fa42618e)Updated to/from dates
     * are required to search by Change Type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transaction_Log_TypeObjectType[]
     */
    public $Purchase_Order_Change_Type_Reference;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order Status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order Invoice Status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Status_Reference;
    /**
     * The Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order Payment Status
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType
     */
    public $Payment_Status_Reference;
    /**
     * The Receiving_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order Receiving Status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Receiving_Status_Reference;
    /**
     * The Shipping_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order Shipping Status
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Shipping_Status_Reference;
    /**
     * The Tracking_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order Tracking Status
     * - minOccurs: 0
     * @var \StructType\PO_Acknowledgement_StatusObjectType
     */
    public $Tracking_Status_Reference;
    /**
     * The Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Issue Option
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType[]
     */
    public $Issue_Option_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Order Contract
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Requisition
     * - minOccurs: 0
     * @var \StructType\RequisitionObjectType
     */
    public $Requisition_Reference;
    /**
     * The Requesting_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requesting Worker for the Purchase Order
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requesting_Worker_Reference;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Creating_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Creating Worker for the Purchase Order
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Creating_Worker_Reference;
    /**
     * The Approving_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Approving Worker for the Purchase Order
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Approving_Worker_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Worktags or Add new Worktags
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Starting WD34 External PO Number is used when Purchase Order Type is 'External Warehouse'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * Constructor method for Purchase_Order_Request_CriteriaType
     * @uses Purchase_Order_Request_CriteriaType::setOrganization_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setSupplier_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setPurchase_Order_Type_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setPurchase_Order_Number()
     * @uses Purchase_Order_Request_CriteriaType::setPurchase_Order_Date_On_or_After()
     * @uses Purchase_Order_Request_CriteriaType::setPurchase_Order_Date_On_or_Before()
     * @uses Purchase_Order_Request_CriteriaType::setDue_Date_On_or_After()
     * @uses Purchase_Order_Request_CriteriaType::setDue_Date_On_or_Before()
     * @uses Purchase_Order_Request_CriteriaType::setUpdated_From_Date()
     * @uses Purchase_Order_Request_CriteriaType::setUpdated_To_Date()
     * @uses Purchase_Order_Request_CriteriaType::setPurchase_Order_Change_Type_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setDocument_Status_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setInvoice_Status_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setPayment_Status_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setReceiving_Status_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setShipping_Status_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setTracking_Status_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setIssue_Option_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setSupplier_Contract_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setRequisition_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setRequesting_Worker_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setSupplier_Invoice_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setCreating_Worker_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setApproving_Worker_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setWorktag_Reference()
     * @uses Purchase_Order_Request_CriteriaType::setExternal_PO_Number()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Order_TypeObjectType[] $purchase_Order_Type_Reference
     * @param string $purchase_Order_Number
     * @param string $purchase_Order_Date_On_or_After
     * @param string $purchase_Order_Date_On_or_Before
     * @param string $due_Date_On_or_After
     * @param string $due_Date_On_or_Before
     * @param string $updated_From_Date
     * @param string $updated_To_Date
     * @param \StructType\Transaction_Log_TypeObjectType[] $purchase_Order_Change_Type_Reference
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @param \StructType\Document_StatusObjectType $shipping_Status_Reference
     * @param \StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType[] $issue_Option_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\RequisitionObjectType $requisition_Reference
     * @param \StructType\WorkerObjectType $requesting_Worker_Reference
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param \StructType\WorkerObjectType[] $creating_Worker_Reference
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param string $external_PO_Number
     */
    public function __construct(array $organization_Reference = array(), array $supplier_Reference = array(), array $purchase_Order_Type_Reference = array(), $purchase_Order_Number = null, $purchase_Order_Date_On_or_After = null, $purchase_Order_Date_On_or_Before = null, $due_Date_On_or_After = null, $due_Date_On_or_Before = null, $updated_From_Date = null, $updated_To_Date = null, array $purchase_Order_Change_Type_Reference = array(), \StructType\Document_StatusObjectType $document_Status_Reference = null, \StructType\Document_StatusObjectType $invoice_Status_Reference = null, \StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null, \StructType\Document_StatusObjectType $receiving_Status_Reference = null, \StructType\Document_StatusObjectType $shipping_Status_Reference = null, \StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference = null, array $issue_Option_Reference = array(), \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\RequisitionObjectType $requisition_Reference = null, \StructType\WorkerObjectType $requesting_Worker_Reference = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, array $creating_Worker_Reference = array(), array $approving_Worker_Reference = array(), array $worktag_Reference = array(), $external_PO_Number = null)
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setPurchase_Order_Type_Reference($purchase_Order_Type_Reference)
            ->setPurchase_Order_Number($purchase_Order_Number)
            ->setPurchase_Order_Date_On_or_After($purchase_Order_Date_On_or_After)
            ->setPurchase_Order_Date_On_or_Before($purchase_Order_Date_On_or_Before)
            ->setDue_Date_On_or_After($due_Date_On_or_After)
            ->setDue_Date_On_or_Before($due_Date_On_or_Before)
            ->setUpdated_From_Date($updated_From_Date)
            ->setUpdated_To_Date($updated_To_Date)
            ->setPurchase_Order_Change_Type_Reference($purchase_Order_Change_Type_Reference)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setInvoice_Status_Reference($invoice_Status_Reference)
            ->setPayment_Status_Reference($payment_Status_Reference)
            ->setReceiving_Status_Reference($receiving_Status_Reference)
            ->setShipping_Status_Reference($shipping_Status_Reference)
            ->setTracking_Status_Reference($tracking_Status_Reference)
            ->setIssue_Option_Reference($issue_Option_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setRequisition_Reference($requisition_Reference)
            ->setRequesting_Worker_Reference($requesting_Worker_Reference)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setCreating_Worker_Reference($creating_Worker_Reference)
            ->setApproving_Worker_Reference($approving_Worker_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setExternal_PO_Number($external_PO_Number);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypeOrganization_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypeSupplier_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Type_Reference value
     * @return \StructType\Order_TypeObjectType[]|null
     */
    public function getPurchase_Order_Type_Reference()
    {
        return $this->Purchase_Order_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Type_ReferenceForArrayConstraintsFromSetPurchase_Order_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypePurchase_Order_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypePurchase_Order_Type_ReferenceItem instanceof \StructType\Order_TypeObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypePurchase_Order_Type_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypePurchase_Order_Type_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypePurchase_Order_Type_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypePurchase_Order_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Type_Reference property can only contain items of type \StructType\Order_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_TypeObjectType[] $purchase_Order_Type_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setPurchase_Order_Type_Reference(array $purchase_Order_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Type_ReferenceArrayErrorMessage = self::validatePurchase_Order_Type_ReferenceForArrayConstraintsFromSetPurchase_Order_Type_Reference($purchase_Order_Type_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Type_Reference = $purchase_Order_Type_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_TypeObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToPurchase_Order_Type_Reference(\StructType\Order_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Type_Reference property can only contain items of type \StructType\Order_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Number value
     * @return string|null
     */
    public function getPurchase_Order_Number()
    {
        return $this->Purchase_Order_Number;
    }
    /**
     * Set Purchase_Order_Number value
     * @param string $purchase_Order_Number
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setPurchase_Order_Number($purchase_Order_Number = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Number) && !is_string($purchase_Order_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Number, true), gettype($purchase_Order_Number)), __LINE__);
        }
        // validation for constraint: maxLength(513)
        if (!is_null($purchase_Order_Number) && mb_strlen($purchase_Order_Number) > 513) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 513', mb_strlen($purchase_Order_Number)), __LINE__);
        }
        $this->Purchase_Order_Number = $purchase_Order_Number;
        return $this;
    }
    /**
     * Get Purchase_Order_Date_On_or_After value
     * @return string|null
     */
    public function getPurchase_Order_Date_On_or_After()
    {
        return $this->Purchase_Order_Date_On_or_After;
    }
    /**
     * Set Purchase_Order_Date_On_or_After value
     * @param string $purchase_Order_Date_On_or_After
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setPurchase_Order_Date_On_or_After($purchase_Order_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Date_On_or_After) && !is_string($purchase_Order_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Date_On_or_After, true), gettype($purchase_Order_Date_On_or_After)), __LINE__);
        }
        $this->Purchase_Order_Date_On_or_After = $purchase_Order_Date_On_or_After;
        return $this;
    }
    /**
     * Get Purchase_Order_Date_On_or_Before value
     * @return string|null
     */
    public function getPurchase_Order_Date_On_or_Before()
    {
        return $this->Purchase_Order_Date_On_or_Before;
    }
    /**
     * Set Purchase_Order_Date_On_or_Before value
     * @param string $purchase_Order_Date_On_or_Before
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setPurchase_Order_Date_On_or_Before($purchase_Order_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Date_On_or_Before) && !is_string($purchase_Order_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Date_On_or_Before, true), gettype($purchase_Order_Date_On_or_Before)), __LINE__);
        }
        $this->Purchase_Order_Date_On_or_Before = $purchase_Order_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Due_Date_On_or_After value
     * @return string|null
     */
    public function getDue_Date_On_or_After()
    {
        return $this->Due_Date_On_or_After;
    }
    /**
     * Set Due_Date_On_or_After value
     * @param string $due_Date_On_or_After
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setDue_Date_On_or_After($due_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date_On_or_After) && !is_string($due_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date_On_or_After, true), gettype($due_Date_On_or_After)), __LINE__);
        }
        $this->Due_Date_On_or_After = $due_Date_On_or_After;
        return $this;
    }
    /**
     * Get Due_Date_On_or_Before value
     * @return string|null
     */
    public function getDue_Date_On_or_Before()
    {
        return $this->Due_Date_On_or_Before;
    }
    /**
     * Set Due_Date_On_or_Before value
     * @param string $due_Date_On_or_Before
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setDue_Date_On_or_Before($due_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date_On_or_Before) && !is_string($due_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date_On_or_Before, true), gettype($due_Date_On_or_Before)), __LINE__);
        }
        $this->Due_Date_On_or_Before = $due_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Updated_From_Date value
     * @return string|null
     */
    public function getUpdated_From_Date()
    {
        return $this->Updated_From_Date;
    }
    /**
     * Set Updated_From_Date value
     * @param string $updated_From_Date
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setUpdated_From_Date($updated_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_From_Date) && !is_string($updated_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_From_Date, true), gettype($updated_From_Date)), __LINE__);
        }
        $this->Updated_From_Date = $updated_From_Date;
        return $this;
    }
    /**
     * Get Updated_To_Date value
     * @return string|null
     */
    public function getUpdated_To_Date()
    {
        return $this->Updated_To_Date;
    }
    /**
     * Set Updated_To_Date value
     * @param string $updated_To_Date
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setUpdated_To_Date($updated_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($updated_To_Date) && !is_string($updated_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updated_To_Date, true), gettype($updated_To_Date)), __LINE__);
        }
        $this->Updated_To_Date = $updated_To_Date;
        return $this;
    }
    /**
     * Get Purchase_Order_Change_Type_Reference value
     * @return \StructType\Transaction_Log_TypeObjectType[]|null
     */
    public function getPurchase_Order_Change_Type_Reference()
    {
        return $this->Purchase_Order_Change_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Change_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Change_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Change_Type_ReferenceForArrayConstraintsFromSetPurchase_Order_Change_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypePurchase_Order_Change_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypePurchase_Order_Change_Type_ReferenceItem instanceof \StructType\Transaction_Log_TypeObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypePurchase_Order_Change_Type_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypePurchase_Order_Change_Type_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypePurchase_Order_Change_Type_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypePurchase_Order_Change_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Change_Type_Reference property can only contain items of type \StructType\Transaction_Log_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Change_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction_Log_TypeObjectType[] $purchase_Order_Change_Type_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setPurchase_Order_Change_Type_Reference(array $purchase_Order_Change_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Change_Type_ReferenceArrayErrorMessage = self::validatePurchase_Order_Change_Type_ReferenceForArrayConstraintsFromSetPurchase_Order_Change_Type_Reference($purchase_Order_Change_Type_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Change_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Change_Type_Reference = $purchase_Order_Change_Type_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Change_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction_Log_TypeObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToPurchase_Order_Change_Type_Reference(\StructType\Transaction_Log_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transaction_Log_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Change_Type_Reference property can only contain items of type \StructType\Transaction_Log_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Change_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * Set Invoice_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setInvoice_Status_Reference(\StructType\Document_StatusObjectType $invoice_Status_Reference = null)
    {
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Get Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType|null
     */
    public function getPayment_Status_Reference()
    {
        return $this->Payment_Status_Reference;
    }
    /**
     * Set Payment_Status_Reference value
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setPayment_Status_Reference(\StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null)
    {
        $this->Payment_Status_Reference = $payment_Status_Reference;
        return $this;
    }
    /**
     * Get Receiving_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getReceiving_Status_Reference()
    {
        return $this->Receiving_Status_Reference;
    }
    /**
     * Set Receiving_Status_Reference value
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setReceiving_Status_Reference(\StructType\Document_StatusObjectType $receiving_Status_Reference = null)
    {
        $this->Receiving_Status_Reference = $receiving_Status_Reference;
        return $this;
    }
    /**
     * Get Shipping_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getShipping_Status_Reference()
    {
        return $this->Shipping_Status_Reference;
    }
    /**
     * Set Shipping_Status_Reference value
     * @param \StructType\Document_StatusObjectType $shipping_Status_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setShipping_Status_Reference(\StructType\Document_StatusObjectType $shipping_Status_Reference = null)
    {
        $this->Shipping_Status_Reference = $shipping_Status_Reference;
        return $this;
    }
    /**
     * Get Tracking_Status_Reference value
     * @return \StructType\PO_Acknowledgement_StatusObjectType|null
     */
    public function getTracking_Status_Reference()
    {
        return $this->Tracking_Status_Reference;
    }
    /**
     * Set Tracking_Status_Reference value
     * @param \StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setTracking_Status_Reference(\StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference = null)
    {
        $this->Tracking_Status_Reference = $tracking_Status_Reference;
        return $this;
    }
    /**
     * Get Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType[]|null
     */
    public function getIssue_Option_Reference()
    {
        return $this->Issue_Option_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setIssue_Option_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIssue_Option_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIssue_Option_ReferenceForArrayConstraintsFromSetIssue_Option_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypeIssue_Option_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypeIssue_Option_ReferenceItem instanceof \StructType\Purchase_Order_Issue_OptionObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypeIssue_Option_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypeIssue_Option_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypeIssue_Option_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypeIssue_Option_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Issue_Option_Reference property can only contain items of type \StructType\Purchase_Order_Issue_OptionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Issue_Option_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Issue_OptionObjectType[] $issue_Option_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setIssue_Option_Reference(array $issue_Option_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($issue_Option_ReferenceArrayErrorMessage = self::validateIssue_Option_ReferenceForArrayConstraintsFromSetIssue_Option_Reference($issue_Option_Reference))) {
            throw new \InvalidArgumentException($issue_Option_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Issue_Option_Reference = $issue_Option_Reference;
        return $this;
    }
    /**
     * Add item to Issue_Option_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToIssue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Issue_OptionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Issue_Option_Reference property can only contain items of type \StructType\Purchase_Order_Issue_OptionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Issue_Option_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Requisition_Reference value
     * @return \StructType\RequisitionObjectType|null
     */
    public function getRequisition_Reference()
    {
        return $this->Requisition_Reference;
    }
    /**
     * Set Requisition_Reference value
     * @param \StructType\RequisitionObjectType $requisition_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setRequisition_Reference(\StructType\RequisitionObjectType $requisition_Reference = null)
    {
        $this->Requisition_Reference = $requisition_Reference;
        return $this;
    }
    /**
     * Get Requesting_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequesting_Worker_Reference()
    {
        return $this->Requesting_Worker_Reference;
    }
    /**
     * Set Requesting_Worker_Reference value
     * @param \StructType\WorkerObjectType $requesting_Worker_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setRequesting_Worker_Reference(\StructType\WorkerObjectType $requesting_Worker_Reference = null)
    {
        $this->Requesting_Worker_Reference = $requesting_Worker_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Creating_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreating_Worker_Reference()
    {
        return $this->Creating_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreating_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreating_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreating_Worker_ReferenceForArrayConstraintsFromSetCreating_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypeCreating_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypeCreating_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypeCreating_Worker_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypeCreating_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypeCreating_Worker_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypeCreating_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Creating_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Creating_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $creating_Worker_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setCreating_Worker_Reference(array $creating_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($creating_Worker_ReferenceArrayErrorMessage = self::validateCreating_Worker_ReferenceForArrayConstraintsFromSetCreating_Worker_Reference($creating_Worker_Reference))) {
            throw new \InvalidArgumentException($creating_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Creating_Worker_Reference = $creating_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Creating_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToCreating_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Creating_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Creating_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approving_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getApproving_Worker_Reference()
    {
        return $this->Approving_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApproving_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproving_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypeApproving_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypeApproving_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypeApproving_Worker_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypeApproving_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypeApproving_Worker_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypeApproving_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setApproving_Worker_Reference(array $approving_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($approving_Worker_ReferenceArrayErrorMessage = self::validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference($approving_Worker_Reference))) {
            throw new \InvalidArgumentException($approving_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Approving_Worker_Reference = $approving_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToApproving_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approving_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Request_CriteriaTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Request_CriteriaTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($purchase_Order_Request_CriteriaTypeWorktag_ReferenceItem) ? get_class($purchase_Order_Request_CriteriaTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Request_CriteriaTypeWorktag_ReferenceItem), var_export($purchase_Order_Request_CriteriaTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Purchase_Order_Request_CriteriaType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
}
