<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Item_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Catalog Item Response Data
 * @subpackage Structs
 */
class Catalog_Item_Response_DataType extends AbstractStructBase
{
    /**
     * The Catalog_Item
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Response Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_ItemType[]
     */
    public $Catalog_Item;
    /**
     * Constructor method for Catalog_Item_Response_DataType
     * @uses Catalog_Item_Response_DataType::setCatalog_Item()
     * @param \StructType\Catalog_ItemType[] $catalog_Item
     */
    public function __construct(array $catalog_Item = array())
    {
        $this
            ->setCatalog_Item($catalog_Item);
    }
    /**
     * Get Catalog_Item value
     * @return \StructType\Catalog_ItemType[]|null
     */
    public function getCatalog_Item()
    {
        return $this->Catalog_Item;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_ItemForArrayConstraintsFromSetCatalog_Item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_Response_DataTypeCatalog_ItemItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_Response_DataTypeCatalog_ItemItem instanceof \StructType\Catalog_ItemType) {
                $invalidValues[] = is_object($catalog_Item_Response_DataTypeCatalog_ItemItem) ? get_class($catalog_Item_Response_DataTypeCatalog_ItemItem) : sprintf('%s(%s)', gettype($catalog_Item_Response_DataTypeCatalog_ItemItem), var_export($catalog_Item_Response_DataTypeCatalog_ItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Item property can only contain items of type \StructType\Catalog_ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_ItemType[] $catalog_Item
     * @return \StructType\Catalog_Item_Response_DataType
     */
    public function setCatalog_Item(array $catalog_Item = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_ItemArrayErrorMessage = self::validateCatalog_ItemForArrayConstraintsFromSetCatalog_Item($catalog_Item))) {
            throw new \InvalidArgumentException($catalog_ItemArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Item = $catalog_Item;
        return $this;
    }
    /**
     * Add item to Catalog_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_ItemType $item
     * @return \StructType\Catalog_Item_Response_DataType
     */
    public function addToCatalog_Item(\StructType\Catalog_ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_ItemType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Item property can only contain items of type \StructType\Catalog_ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Item[] = $item;
        return $this;
    }
}
