<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing criteria for Worktag Split Template Request
 * @subpackage Structs
 */
class Worktag_Split_Template_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Worktag_Split_Template_Name
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Template Name for Request Criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worktag_Split_Template_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive status for Request Criteria
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Template_Criteria_Reference
     * Meta information extracted from the WSDL
     * - documentation: Template Criteria for Request Criteria
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_Template_CriteriaObjectType
     */
    public $Template_Criteria_Reference;
    /**
     * Constructor method for Worktag_Split_Template_Request_CriteriaType
     * @uses Worktag_Split_Template_Request_CriteriaType::setWorktag_Split_Template_Name()
     * @uses Worktag_Split_Template_Request_CriteriaType::setInactive()
     * @uses Worktag_Split_Template_Request_CriteriaType::setTemplate_Criteria_Reference()
     * @param string $worktag_Split_Template_Name
     * @param bool $inactive
     * @param \StructType\Worktag_Split_Template_CriteriaObjectType $template_Criteria_Reference
     */
    public function __construct($worktag_Split_Template_Name = null, $inactive = null, \StructType\Worktag_Split_Template_CriteriaObjectType $template_Criteria_Reference = null)
    {
        $this
            ->setWorktag_Split_Template_Name($worktag_Split_Template_Name)
            ->setInactive($inactive)
            ->setTemplate_Criteria_Reference($template_Criteria_Reference);
    }
    /**
     * Get Worktag_Split_Template_Name value
     * @return string|null
     */
    public function getWorktag_Split_Template_Name()
    {
        return $this->Worktag_Split_Template_Name;
    }
    /**
     * Set Worktag_Split_Template_Name value
     * @param string $worktag_Split_Template_Name
     * @return \StructType\Worktag_Split_Template_Request_CriteriaType
     */
    public function setWorktag_Split_Template_Name($worktag_Split_Template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($worktag_Split_Template_Name) && !is_string($worktag_Split_Template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worktag_Split_Template_Name, true), gettype($worktag_Split_Template_Name)), __LINE__);
        }
        $this->Worktag_Split_Template_Name = $worktag_Split_Template_Name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Worktag_Split_Template_Request_CriteriaType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Template_Criteria_Reference value
     * @return \StructType\Worktag_Split_Template_CriteriaObjectType|null
     */
    public function getTemplate_Criteria_Reference()
    {
        return $this->Template_Criteria_Reference;
    }
    /**
     * Set Template_Criteria_Reference value
     * @param \StructType\Worktag_Split_Template_CriteriaObjectType $template_Criteria_Reference
     * @return \StructType\Worktag_Split_Template_Request_CriteriaType
     */
    public function setTemplate_Criteria_Reference(\StructType\Worktag_Split_Template_CriteriaObjectType $template_Criteria_Reference = null)
    {
        $this->Template_Criteria_Reference = $template_Criteria_Reference;
        return $this;
    }
}
