<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_Rate_Application_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing Tax Rate data.
 * @subpackage Structs
 */
class Tax_Rate_Application_DataType extends AbstractStructBase
{
    /**
     * The Tax_Rate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Rate Reference is required if Tax Code is provided. | Reference to an existing Tax Rate
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType
     */
    public $Tax_Rate_Reference;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Tax_Recoverability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Recoverability
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_Reference;
    /**
     * The Tax_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Existing Tax Type
     * - minOccurs: 0
     * @var \StructType\Tax_TypeObjectType
     */
    public $Tax_Type_Reference;
    /**
     * The Tax_Point_Date_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Point Date Type
     * - minOccurs: 0
     * @var \StructType\Tax_Point_Date_TypeObjectType
     */
    public $Tax_Point_Date_Type_Reference;
    /**
     * The Tax_Point_Date
     * Meta information extracted from the WSDL
     * - documentation: Tax Point Date for Taxable Document
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Tax_Point_Date;
    /**
     * Constructor method for Tax_Rate_Application_DataType
     * @uses Tax_Rate_Application_DataType::setTax_Rate_Reference()
     * @uses Tax_Rate_Application_DataType::setTax_Amount()
     * @uses Tax_Rate_Application_DataType::setTax_Recoverability_Reference()
     * @uses Tax_Rate_Application_DataType::setTax_Type_Reference()
     * @uses Tax_Rate_Application_DataType::setTax_Point_Date_Type_Reference()
     * @uses Tax_Rate_Application_DataType::setTax_Point_Date()
     * @param \StructType\Tax_RateObjectType $tax_Rate_Reference
     * @param float $tax_Amount
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_Reference
     * @param \StructType\Tax_TypeObjectType $tax_Type_Reference
     * @param \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference
     * @param string $tax_Point_Date
     */
    public function __construct(\StructType\Tax_RateObjectType $tax_Rate_Reference = null, $tax_Amount = null, \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_Reference = null, \StructType\Tax_TypeObjectType $tax_Type_Reference = null, \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference = null, $tax_Point_Date = null)
    {
        $this
            ->setTax_Rate_Reference($tax_Rate_Reference)
            ->setTax_Amount($tax_Amount)
            ->setTax_Recoverability_Reference($tax_Recoverability_Reference)
            ->setTax_Type_Reference($tax_Type_Reference)
            ->setTax_Point_Date_Type_Reference($tax_Point_Date_Type_Reference)
            ->setTax_Point_Date($tax_Point_Date);
    }
    /**
     * Get Tax_Rate_Reference value
     * @return \StructType\Tax_RateObjectType|null
     */
    public function getTax_Rate_Reference()
    {
        return $this->Tax_Rate_Reference;
    }
    /**
     * Set Tax_Rate_Reference value
     * @param \StructType\Tax_RateObjectType $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Application_DataType
     */
    public function setTax_Rate_Reference(\StructType\Tax_RateObjectType $tax_Rate_Reference = null)
    {
        $this->Tax_Rate_Reference = $tax_Rate_Reference;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Tax_Rate_Application_DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Tax_Recoverability_Reference value
     * @return \StructType\Tax_RecoverabilityObjectType|null
     */
    public function getTax_Recoverability_Reference()
    {
        return $this->Tax_Recoverability_Reference;
    }
    /**
     * Set Tax_Recoverability_Reference value
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Application_DataType
     */
    public function setTax_Recoverability_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_Reference = null)
    {
        $this->Tax_Recoverability_Reference = $tax_Recoverability_Reference;
        return $this;
    }
    /**
     * Get Tax_Type_Reference value
     * @return \StructType\Tax_TypeObjectType|null
     */
    public function getTax_Type_Reference()
    {
        return $this->Tax_Type_Reference;
    }
    /**
     * Set Tax_Type_Reference value
     * @param \StructType\Tax_TypeObjectType $tax_Type_Reference
     * @return \StructType\Tax_Rate_Application_DataType
     */
    public function setTax_Type_Reference(\StructType\Tax_TypeObjectType $tax_Type_Reference = null)
    {
        $this->Tax_Type_Reference = $tax_Type_Reference;
        return $this;
    }
    /**
     * Get Tax_Point_Date_Type_Reference value
     * @return \StructType\Tax_Point_Date_TypeObjectType|null
     */
    public function getTax_Point_Date_Type_Reference()
    {
        return $this->Tax_Point_Date_Type_Reference;
    }
    /**
     * Set Tax_Point_Date_Type_Reference value
     * @param \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference
     * @return \StructType\Tax_Rate_Application_DataType
     */
    public function setTax_Point_Date_Type_Reference(\StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference = null)
    {
        $this->Tax_Point_Date_Type_Reference = $tax_Point_Date_Type_Reference;
        return $this;
    }
    /**
     * Get Tax_Point_Date value
     * @return string|null
     */
    public function getTax_Point_Date()
    {
        return $this->Tax_Point_Date;
    }
    /**
     * Set Tax_Point_Date value
     * @param string $tax_Point_Date
     * @return \StructType\Tax_Rate_Application_DataType
     */
    public function setTax_Point_Date($tax_Point_Date = null)
    {
        // validation for constraint: string
        if (!is_null($tax_Point_Date) && !is_string($tax_Point_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_Point_Date, true), gettype($tax_Point_Date)), __LINE__);
        }
        $this->Tax_Point_Date = $tax_Point_Date;
        return $this;
    }
}
