<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Order_Contract_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Supplier Order Contracts Request References
 * @subpackage Structs
 */
class Supplier_Order_Contract_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Order_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Contract Reference
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Supplier_Order_Contract_Reference;
    /**
     * Constructor method for Supplier_Order_Contract_Request_ReferencesType
     * @uses Supplier_Order_Contract_Request_ReferencesType::setSupplier_Order_Contract_Reference()
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Order_Contract_Reference
     */
    public function __construct(array $supplier_Order_Contract_Reference = array())
    {
        $this
            ->setSupplier_Order_Contract_Reference($supplier_Order_Contract_Reference);
    }
    /**
     * Get Supplier_Order_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getSupplier_Order_Contract_Reference()
    {
        return $this->Supplier_Order_Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Order_Contract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Order_Contract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Order_Contract_ReferenceForArrayConstraintsFromSetSupplier_Order_Contract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Order_Contract_Request_ReferencesTypeSupplier_Order_Contract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Order_Contract_Request_ReferencesTypeSupplier_Order_Contract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($supplier_Order_Contract_Request_ReferencesTypeSupplier_Order_Contract_ReferenceItem) ? get_class($supplier_Order_Contract_Request_ReferencesTypeSupplier_Order_Contract_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Order_Contract_Request_ReferencesTypeSupplier_Order_Contract_ReferenceItem), var_export($supplier_Order_Contract_Request_ReferencesTypeSupplier_Order_Contract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Order_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Order_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $supplier_Order_Contract_Reference
     * @return \StructType\Supplier_Order_Contract_Request_ReferencesType
     */
    public function setSupplier_Order_Contract_Reference(array $supplier_Order_Contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Order_Contract_ReferenceArrayErrorMessage = self::validateSupplier_Order_Contract_ReferenceForArrayConstraintsFromSetSupplier_Order_Contract_Reference($supplier_Order_Contract_Reference))) {
            throw new \InvalidArgumentException($supplier_Order_Contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Order_Contract_Reference = $supplier_Order_Contract_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Order_Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Supplier_Order_Contract_Request_ReferencesType
     */
    public function addToSupplier_Order_Contract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Order_Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Order_Contract_Reference[] = $item;
        return $this;
    }
}
