<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Card_Transaction_Verification_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Procurement Card Transaction Verification Data.
 * @subpackage Structs
 */
class Procurement_Card_Transaction_Verification_DataType extends AbstractStructBase
{
    /**
     * The Procurement_Card_Transaction_Verification_ID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a Procurement Card Transaction Verification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Procurement_Card_Transaction_Verification_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: When set to "true" or "1", the business process is automatically processed. This means that all approvals will be automatically approved in the system, all reviews and to-do's will be automatically by-passed, and all notifications
     * will be automatically suppressed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker Reference for Procurement Card Transaction Verification.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference for Procurement Card Transaction Verification.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: Document Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on all procurement card lines and splits.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Verification_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Card Transaction Verification Status Reference.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Verification_Status_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Total_Verification_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Verification AmountThis information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Verification_Amount;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Business Document Attachment data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Procurement_Card_Transaction_Verification_Summary_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Procurement Card Transaction Verification Summary Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_Verification_Summary_DataType[]
     */
    public $Procurement_Card_Transaction_Verification_Summary_Data;
    /**
     * Constructor method for Procurement_Card_Transaction_Verification_DataType
     * @uses Procurement_Card_Transaction_Verification_DataType::setProcurement_Card_Transaction_Verification_ID()
     * @uses Procurement_Card_Transaction_Verification_DataType::setSubmit()
     * @uses Procurement_Card_Transaction_Verification_DataType::setWorker_Reference()
     * @uses Procurement_Card_Transaction_Verification_DataType::setCompany_Reference()
     * @uses Procurement_Card_Transaction_Verification_DataType::setDocument_Date()
     * @uses Procurement_Card_Transaction_Verification_DataType::setBudget_Date()
     * @uses Procurement_Card_Transaction_Verification_DataType::setVerification_Status_Reference()
     * @uses Procurement_Card_Transaction_Verification_DataType::setCurrency_Reference()
     * @uses Procurement_Card_Transaction_Verification_DataType::setTotal_Verification_Amount()
     * @uses Procurement_Card_Transaction_Verification_DataType::setAttachment_Data()
     * @uses Procurement_Card_Transaction_Verification_DataType::setProcurement_Card_Transaction_Verification_Summary_Data()
     * @param string $procurement_Card_Transaction_Verification_ID
     * @param bool $submit
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $document_Date
     * @param string $budget_Date
     * @param \StructType\Document_StatusObjectType $verification_Status_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $total_Verification_Amount
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Procurement_Card_Transaction_Verification_Summary_DataType[] $procurement_Card_Transaction_Verification_Summary_Data
     */
    public function __construct($procurement_Card_Transaction_Verification_ID = null, $submit = null, \StructType\WorkerObjectType $worker_Reference = null, \StructType\CompanyObjectType $company_Reference = null, $document_Date = null, $budget_Date = null, \StructType\Document_StatusObjectType $verification_Status_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $total_Verification_Amount = null, array $attachment_Data = array(), array $procurement_Card_Transaction_Verification_Summary_Data = array())
    {
        $this
            ->setProcurement_Card_Transaction_Verification_ID($procurement_Card_Transaction_Verification_ID)
            ->setSubmit($submit)
            ->setWorker_Reference($worker_Reference)
            ->setCompany_Reference($company_Reference)
            ->setDocument_Date($document_Date)
            ->setBudget_Date($budget_Date)
            ->setVerification_Status_Reference($verification_Status_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setTotal_Verification_Amount($total_Verification_Amount)
            ->setAttachment_Data($attachment_Data)
            ->setProcurement_Card_Transaction_Verification_Summary_Data($procurement_Card_Transaction_Verification_Summary_Data);
    }
    /**
     * Get Procurement_Card_Transaction_Verification_ID value
     * @return string|null
     */
    public function getProcurement_Card_Transaction_Verification_ID()
    {
        return $this->Procurement_Card_Transaction_Verification_ID;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_ID value
     * @param string $procurement_Card_Transaction_Verification_ID
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setProcurement_Card_Transaction_Verification_ID($procurement_Card_Transaction_Verification_ID = null)
    {
        // validation for constraint: string
        if (!is_null($procurement_Card_Transaction_Verification_ID) && !is_string($procurement_Card_Transaction_Verification_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procurement_Card_Transaction_Verification_ID, true), gettype($procurement_Card_Transaction_Verification_ID)), __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_ID = $procurement_Card_Transaction_Verification_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Verification_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getVerification_Status_Reference()
    {
        return $this->Verification_Status_Reference;
    }
    /**
     * Set Verification_Status_Reference value
     * @param \StructType\Document_StatusObjectType $verification_Status_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setVerification_Status_Reference(\StructType\Document_StatusObjectType $verification_Status_Reference = null)
    {
        $this->Verification_Status_Reference = $verification_Status_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Total_Verification_Amount value
     * @return float|null
     */
    public function getTotal_Verification_Amount()
    {
        return $this->Total_Verification_Amount;
    }
    /**
     * Set Total_Verification_Amount value
     * @param float $total_Verification_Amount
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setTotal_Verification_Amount($total_Verification_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Verification_Amount) && !(is_float($total_Verification_Amount) || is_numeric($total_Verification_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Verification_Amount, true), gettype($total_Verification_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Verification_Amount) && mb_strlen(mb_substr($total_Verification_Amount, false !== mb_strpos($total_Verification_Amount, '.') ? mb_strpos($total_Verification_Amount, '.') + 1 : mb_strlen($total_Verification_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Verification_Amount, true), mb_strlen(mb_substr($total_Verification_Amount, mb_strpos($total_Verification_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Verification_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Verification_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Verification_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Verification_Amount))), __LINE__);
        }
        $this->Total_Verification_Amount = $total_Verification_Amount;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_DataTypeAttachment_DataItem) ? get_class($procurement_Card_Transaction_Verification_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_DataTypeAttachment_DataItem), var_export($procurement_Card_Transaction_Verification_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Summary_Data value
     * @return \StructType\Procurement_Card_Transaction_Verification_Summary_DataType[]|null
     */
    public function getProcurement_Card_Transaction_Verification_Summary_Data()
    {
        return $this->Procurement_Card_Transaction_Verification_Summary_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Card_Transaction_Verification_Summary_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Card_Transaction_Verification_Summary_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Card_Transaction_Verification_Summary_DataForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Summary_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_Verification_DataTypeProcurement_Card_Transaction_Verification_Summary_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_Verification_DataTypeProcurement_Card_Transaction_Verification_Summary_DataItem instanceof \StructType\Procurement_Card_Transaction_Verification_Summary_DataType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_Verification_DataTypeProcurement_Card_Transaction_Verification_Summary_DataItem) ? get_class($procurement_Card_Transaction_Verification_DataTypeProcurement_Card_Transaction_Verification_Summary_DataItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_Verification_DataTypeProcurement_Card_Transaction_Verification_Summary_DataItem), var_export($procurement_Card_Transaction_Verification_DataTypeProcurement_Card_Transaction_Verification_Summary_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Card_Transaction_Verification_Summary_Data property can only contain items of type \StructType\Procurement_Card_Transaction_Verification_Summary_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Summary_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_Verification_Summary_DataType[] $procurement_Card_Transaction_Verification_Summary_Data
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function setProcurement_Card_Transaction_Verification_Summary_Data(array $procurement_Card_Transaction_Verification_Summary_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Card_Transaction_Verification_Summary_DataArrayErrorMessage = self::validateProcurement_Card_Transaction_Verification_Summary_DataForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Summary_Data($procurement_Card_Transaction_Verification_Summary_Data))) {
            throw new \InvalidArgumentException($procurement_Card_Transaction_Verification_Summary_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Summary_Data = $procurement_Card_Transaction_Verification_Summary_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Card_Transaction_Verification_Summary_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_Verification_Summary_DataType $item
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType
     */
    public function addToProcurement_Card_Transaction_Verification_Summary_Data(\StructType\Procurement_Card_Transaction_Verification_Summary_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Card_Transaction_Verification_Summary_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Card_Transaction_Verification_Summary_Data property can only contain items of type \StructType\Procurement_Card_Transaction_Verification_Summary_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Summary_Data[] = $item;
        return $this;
    }
}
