<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Provider_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost Response Element that represents the Reference to the Internal Service Provider along with its content.
 * @subpackage Structs
 */
class Internal_Service_Provider_Response_DataType extends AbstractStructBase
{
    /**
     * The Internal_Service_Provider
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the Reference to the Internal Service Provider along with its content.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_ProviderType[]
     */
    public $Internal_Service_Provider;
    /**
     * Constructor method for Internal_Service_Provider_Response_DataType
     * @uses Internal_Service_Provider_Response_DataType::setInternal_Service_Provider()
     * @param \StructType\Internal_Service_ProviderType[] $internal_Service_Provider
     */
    public function __construct(array $internal_Service_Provider = array())
    {
        $this
            ->setInternal_Service_Provider($internal_Service_Provider);
    }
    /**
     * Get Internal_Service_Provider value
     * @return \StructType\Internal_Service_ProviderType[]|null
     */
    public function getInternal_Service_Provider()
    {
        return $this->Internal_Service_Provider;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Provider method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Provider method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_ProviderForArrayConstraintsFromSetInternal_Service_Provider(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_Response_DataTypeInternal_Service_ProviderItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_Response_DataTypeInternal_Service_ProviderItem instanceof \StructType\Internal_Service_ProviderType) {
                $invalidValues[] = is_object($internal_Service_Provider_Response_DataTypeInternal_Service_ProviderItem) ? get_class($internal_Service_Provider_Response_DataTypeInternal_Service_ProviderItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_Response_DataTypeInternal_Service_ProviderItem), var_export($internal_Service_Provider_Response_DataTypeInternal_Service_ProviderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Provider property can only contain items of type \StructType\Internal_Service_ProviderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Provider value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_ProviderType[] $internal_Service_Provider
     * @return \StructType\Internal_Service_Provider_Response_DataType
     */
    public function setInternal_Service_Provider(array $internal_Service_Provider = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_ProviderArrayErrorMessage = self::validateInternal_Service_ProviderForArrayConstraintsFromSetInternal_Service_Provider($internal_Service_Provider))) {
            throw new \InvalidArgumentException($internal_Service_ProviderArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Provider = $internal_Service_Provider;
        return $this;
    }
    /**
     * Add item to Internal_Service_Provider value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_ProviderType $item
     * @return \StructType\Internal_Service_Provider_Response_DataType
     */
    public function addToInternal_Service_Provider(\StructType\Internal_Service_ProviderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_ProviderType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Provider property can only contain items of type \StructType\Internal_Service_ProviderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Provider[] = $item;
        return $this;
    }
}
