<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_File_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Expense Credit Card Transaction File response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Credit_Card_Transaction_File_Response_DataType extends AbstractStructBase
{
    /**
     * The Credit_Card_Transaction_File
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes Credit Card Transaction File instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_FileType[]
     */
    public $Credit_Card_Transaction_File;
    /**
     * Constructor method for Credit_Card_Transaction_File_Response_DataType
     * @uses Credit_Card_Transaction_File_Response_DataType::setCredit_Card_Transaction_File()
     * @param \StructType\Credit_Card_Transaction_FileType[] $credit_Card_Transaction_File
     */
    public function __construct(array $credit_Card_Transaction_File = array())
    {
        $this
            ->setCredit_Card_Transaction_File($credit_Card_Transaction_File);
    }
    /**
     * Get Credit_Card_Transaction_File value
     * @return \StructType\Credit_Card_Transaction_FileType[]|null
     */
    public function getCredit_Card_Transaction_File()
    {
        return $this->Credit_Card_Transaction_File;
    }
    /**
     * This method is responsible for validating the values passed to the setCredit_Card_Transaction_File method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit_Card_Transaction_File method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCredit_Card_Transaction_FileForArrayConstraintsFromSetCredit_Card_Transaction_File(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_File_Response_DataTypeCredit_Card_Transaction_FileItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_File_Response_DataTypeCredit_Card_Transaction_FileItem instanceof \StructType\Credit_Card_Transaction_FileType) {
                $invalidValues[] = is_object($credit_Card_Transaction_File_Response_DataTypeCredit_Card_Transaction_FileItem) ? get_class($credit_Card_Transaction_File_Response_DataTypeCredit_Card_Transaction_FileItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_File_Response_DataTypeCredit_Card_Transaction_FileItem), var_export($credit_Card_Transaction_File_Response_DataTypeCredit_Card_Transaction_FileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Credit_Card_Transaction_File property can only contain items of type \StructType\Credit_Card_Transaction_FileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Credit_Card_Transaction_File value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_FileType[] $credit_Card_Transaction_File
     * @return \StructType\Credit_Card_Transaction_File_Response_DataType
     */
    public function setCredit_Card_Transaction_File(array $credit_Card_Transaction_File = array())
    {
        // validation for constraint: array
        if ('' !== ($credit_Card_Transaction_FileArrayErrorMessage = self::validateCredit_Card_Transaction_FileForArrayConstraintsFromSetCredit_Card_Transaction_File($credit_Card_Transaction_File))) {
            throw new \InvalidArgumentException($credit_Card_Transaction_FileArrayErrorMessage, __LINE__);
        }
        $this->Credit_Card_Transaction_File = $credit_Card_Transaction_File;
        return $this;
    }
    /**
     * Add item to Credit_Card_Transaction_File value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_FileType $item
     * @return \StructType\Credit_Card_Transaction_File_Response_DataType
     */
    public function addToCredit_Card_Transaction_File(\StructType\Credit_Card_Transaction_FileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_Transaction_FileType) {
            throw new \InvalidArgumentException(sprintf('The Credit_Card_Transaction_File property can only contain items of type \StructType\Credit_Card_Transaction_FileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Credit_Card_Transaction_File[] = $item;
        return $this;
    }
}
