<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_Asset_Book_Restriction_Replacement_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Primary Book Override must be the Primary Book if specified within Restricted to Books. | The specified Asset Book is not configured for the Company. | The Company Asset Book Restriction cannot be updated, it does not match the
 * Company of the request. | Company Asset Book Restriction Order, Restrict to Books Reference, and Primary Asset Book Reference are required to create or update a Company Asset Book Restriction. | Primary Book Override must be included within
 * Restricted to Books. | Add Only Flag is set and ID already exists for Company Asset Book Restriction. Use a unique ID to create a Company Asset Book Restriction. | Valid ID must be provided when Delete flag is set. | Element containing Company Asset
 * Book Restriction replacement data.
 * @subpackage Structs
 */
class Company_Asset_Book_Restriction_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating the referenced Company Asset Book Restriction should be deleted from the Company.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique reference identifier to the set of Company Asset Book Restrictions.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Company_Asset_Book_Restriction_Order
     * Meta information extracted from the WSDL
     * - documentation: Used to define the order of the rules (ascending).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Company_Asset_Book_Restriction_Order;
    /**
     * The Spend_Category_or_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Spend Categories or Hierarchies for a Company Asset Book Restriction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_or_Hierarchy_Reference;
    /**
     * The Supplier_Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Supplier Contract Types for a Company Asset Book Restriction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_TypeObjectType[]
     */
    public $Supplier_Contract_Type_Reference;
    /**
     * The Lease_Accounting_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Lease Accounting Methods for a Company Asset Book Restriction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Lease_Accounting_MethodObjectType[]
     */
    public $Lease_Accounting_Method_Reference;
    /**
     * The Restrict_to_Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the restricted books for a company asset book restriction
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restrict_to_Asset_Book_Reference;
    /**
     * The Primary_Asset_Book_Override_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the primary override for a company asset book restriction
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType
     */
    public $Primary_Asset_Book_Override_Reference;
    /**
     * Constructor method for Company_Asset_Book_Restriction_Replacement_DataType
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setDelete()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setID()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setCompany_Asset_Book_Restriction_Order()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setSpend_Category_or_Hierarchy_Reference()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setSupplier_Contract_Type_Reference()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setLease_Accounting_Method_Reference()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setRestrict_to_Asset_Book_Reference()
     * @uses Company_Asset_Book_Restriction_Replacement_DataType::setPrimary_Asset_Book_Override_Reference()
     * @param bool $delete
     * @param string $iD
     * @param string $company_Asset_Book_Restriction_Order
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @param \StructType\Supplier_Contract_TypeObjectType[] $supplier_Contract_Type_Reference
     * @param \StructType\Lease_Accounting_MethodObjectType[] $lease_Accounting_Method_Reference
     * @param \StructType\Asset_BookObjectType[] $restrict_to_Asset_Book_Reference
     * @param \StructType\Asset_BookObjectType $primary_Asset_Book_Override_Reference
     */
    public function __construct($delete = null, $iD = null, $company_Asset_Book_Restriction_Order = null, array $spend_Category_or_Hierarchy_Reference = array(), array $supplier_Contract_Type_Reference = array(), array $lease_Accounting_Method_Reference = array(), array $restrict_to_Asset_Book_Reference = array(), \StructType\Asset_BookObjectType $primary_Asset_Book_Override_Reference = null)
    {
        $this
            ->setDelete($delete)
            ->setID($iD)
            ->setCompany_Asset_Book_Restriction_Order($company_Asset_Book_Restriction_Order)
            ->setSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference)
            ->setSupplier_Contract_Type_Reference($supplier_Contract_Type_Reference)
            ->setLease_Accounting_Method_Reference($lease_Accounting_Method_Reference)
            ->setRestrict_to_Asset_Book_Reference($restrict_to_Asset_Book_Reference)
            ->setPrimary_Asset_Book_Override_Reference($primary_Asset_Book_Override_Reference);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Company_Asset_Book_Restriction_Order value
     * @return string|null
     */
    public function getCompany_Asset_Book_Restriction_Order()
    {
        return $this->Company_Asset_Book_Restriction_Order;
    }
    /**
     * Set Company_Asset_Book_Restriction_Order value
     * @param string $company_Asset_Book_Restriction_Order
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setCompany_Asset_Book_Restriction_Order($company_Asset_Book_Restriction_Order = null)
    {
        // validation for constraint: string
        if (!is_null($company_Asset_Book_Restriction_Order) && !is_string($company_Asset_Book_Restriction_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company_Asset_Book_Restriction_Order, true), gettype($company_Asset_Book_Restriction_Order)), __LINE__);
        }
        $this->Company_Asset_Book_Restriction_Order = $company_Asset_Book_Restriction_Order;
        return $this;
    }
    /**
     * Get Spend_Category_or_Hierarchy_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_or_Hierarchy_Reference()
    {
        return $this->Spend_Category_or_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_or_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_or_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) ? get_class($company_Asset_Book_Restriction_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem), var_export($company_Asset_Book_Restriction_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setSpend_Category_or_Hierarchy_Reference(array $spend_Category_or_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage = self::validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference = $spend_Category_or_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function addToSpend_Category_or_Hierarchy_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Contract_Type_Reference value
     * @return \StructType\Supplier_Contract_TypeObjectType[]|null
     */
    public function getSupplier_Contract_Type_Reference()
    {
        return $this->Supplier_Contract_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contract_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contract_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contract_Type_ReferenceForArrayConstraintsFromSetSupplier_Contract_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Replacement_DataTypeSupplier_Contract_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Replacement_DataTypeSupplier_Contract_Type_ReferenceItem instanceof \StructType\Supplier_Contract_TypeObjectType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Replacement_DataTypeSupplier_Contract_Type_ReferenceItem) ? get_class($company_Asset_Book_Restriction_Replacement_DataTypeSupplier_Contract_Type_ReferenceItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Replacement_DataTypeSupplier_Contract_Type_ReferenceItem), var_export($company_Asset_Book_Restriction_Replacement_DataTypeSupplier_Contract_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contract_Type_Reference property can only contain items of type \StructType\Supplier_Contract_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contract_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_TypeObjectType[] $supplier_Contract_Type_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setSupplier_Contract_Type_Reference(array $supplier_Contract_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contract_Type_ReferenceArrayErrorMessage = self::validateSupplier_Contract_Type_ReferenceForArrayConstraintsFromSetSupplier_Contract_Type_Reference($supplier_Contract_Type_Reference))) {
            throw new \InvalidArgumentException($supplier_Contract_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contract_Type_Reference = $supplier_Contract_Type_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Contract_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_TypeObjectType $item
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function addToSupplier_Contract_Type_Reference(\StructType\Supplier_Contract_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contract_Type_Reference property can only contain items of type \StructType\Supplier_Contract_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contract_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Lease_Accounting_Method_Reference value
     * @return \StructType\Lease_Accounting_MethodObjectType[]|null
     */
    public function getLease_Accounting_Method_Reference()
    {
        return $this->Lease_Accounting_Method_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLease_Accounting_Method_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLease_Accounting_Method_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLease_Accounting_Method_ReferenceForArrayConstraintsFromSetLease_Accounting_Method_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Replacement_DataTypeLease_Accounting_Method_ReferenceItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Replacement_DataTypeLease_Accounting_Method_ReferenceItem instanceof \StructType\Lease_Accounting_MethodObjectType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Replacement_DataTypeLease_Accounting_Method_ReferenceItem) ? get_class($company_Asset_Book_Restriction_Replacement_DataTypeLease_Accounting_Method_ReferenceItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Replacement_DataTypeLease_Accounting_Method_ReferenceItem), var_export($company_Asset_Book_Restriction_Replacement_DataTypeLease_Accounting_Method_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lease_Accounting_Method_Reference property can only contain items of type \StructType\Lease_Accounting_MethodObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lease_Accounting_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Lease_Accounting_MethodObjectType[] $lease_Accounting_Method_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setLease_Accounting_Method_Reference(array $lease_Accounting_Method_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($lease_Accounting_Method_ReferenceArrayErrorMessage = self::validateLease_Accounting_Method_ReferenceForArrayConstraintsFromSetLease_Accounting_Method_Reference($lease_Accounting_Method_Reference))) {
            throw new \InvalidArgumentException($lease_Accounting_Method_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Lease_Accounting_Method_Reference = $lease_Accounting_Method_Reference;
        return $this;
    }
    /**
     * Add item to Lease_Accounting_Method_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Lease_Accounting_MethodObjectType $item
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function addToLease_Accounting_Method_Reference(\StructType\Lease_Accounting_MethodObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Lease_Accounting_MethodObjectType) {
            throw new \InvalidArgumentException(sprintf('The Lease_Accounting_Method_Reference property can only contain items of type \StructType\Lease_Accounting_MethodObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lease_Accounting_Method_Reference[] = $item;
        return $this;
    }
    /**
     * Get Restrict_to_Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestrict_to_Asset_Book_Reference()
    {
        return $this->Restrict_to_Asset_Book_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestrict_to_Asset_Book_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestrict_to_Asset_Book_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrict_to_Asset_Book_ReferenceForArrayConstraintsFromSetRestrict_to_Asset_Book_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $company_Asset_Book_Restriction_Replacement_DataTypeRestrict_to_Asset_Book_ReferenceItem) {
            // validation for constraint: itemType
            if (!$company_Asset_Book_Restriction_Replacement_DataTypeRestrict_to_Asset_Book_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($company_Asset_Book_Restriction_Replacement_DataTypeRestrict_to_Asset_Book_ReferenceItem) ? get_class($company_Asset_Book_Restriction_Replacement_DataTypeRestrict_to_Asset_Book_ReferenceItem) : sprintf('%s(%s)', gettype($company_Asset_Book_Restriction_Replacement_DataTypeRestrict_to_Asset_Book_ReferenceItem), var_export($company_Asset_Book_Restriction_Replacement_DataTypeRestrict_to_Asset_Book_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restrict_to_Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restrict_to_Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restrict_to_Asset_Book_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setRestrict_to_Asset_Book_Reference(array $restrict_to_Asset_Book_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restrict_to_Asset_Book_ReferenceArrayErrorMessage = self::validateRestrict_to_Asset_Book_ReferenceForArrayConstraintsFromSetRestrict_to_Asset_Book_Reference($restrict_to_Asset_Book_Reference))) {
            throw new \InvalidArgumentException($restrict_to_Asset_Book_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restrict_to_Asset_Book_Reference = $restrict_to_Asset_Book_Reference;
        return $this;
    }
    /**
     * Add item to Restrict_to_Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function addToRestrict_to_Asset_Book_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restrict_to_Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restrict_to_Asset_Book_Reference[] = $item;
        return $this;
    }
    /**
     * Get Primary_Asset_Book_Override_Reference value
     * @return \StructType\Asset_BookObjectType|null
     */
    public function getPrimary_Asset_Book_Override_Reference()
    {
        return $this->Primary_Asset_Book_Override_Reference;
    }
    /**
     * Set Primary_Asset_Book_Override_Reference value
     * @param \StructType\Asset_BookObjectType $primary_Asset_Book_Override_Reference
     * @return \StructType\Company_Asset_Book_Restriction_Replacement_DataType
     */
    public function setPrimary_Asset_Book_Override_Reference(\StructType\Asset_BookObjectType $primary_Asset_Book_Override_Reference = null)
    {
        $this->Primary_Asset_Book_Override_Reference = $primary_Asset_Book_Override_Reference;
        return $this;
    }
}
