<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Load_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Catalog Load Item Data
 * @subpackage Structs
 */
class Catalog_Load_Item_DataType extends AbstractStructBase
{
    /**
     * The Catalog_Load_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Item Instance. This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_ItemObjectType
     */
    public $Catalog_Load_Item_Reference;
    /**
     * The Catalog_Item_ID
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Unique Identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Catalog_Item_ID;
    /**
     * The Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Identifier
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Identifier;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Used to inactivate an existing Catalog Item via the Catalog Load WWS request. Please note that if this field is set, any updates to the Catalog Item included in the WWS request will not be carried over when the Catalog Load request
     * is approved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Item_Name
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Name
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Name;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Description
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Description;
    /**
     * The Item_URL
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_URL;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Instances associated with the Purchase or Catalog Item. Commodity code is a standard code that identifies the type of goods or service. Example of standard commodity code types are UNSPSC, NIGP etc. The commodity code
     * needs to be active and not a parent code to associate to the item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType[]
     */
    public $Commodity_Code_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Spend Category
     * - choice: Spend_Category_Reference | UNSPSC_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The UNSPSC_Code
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code | Catalog Item UNSPSC code for Spend Category | UNSPSC code as provided by the Supplier or if missing, the start UNSPSC code on the Spend Category UNSPSC range.cXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/Classification@domain[UNSPSC]
     * - base: xsd:decimal
     * - choice: Spend_Category_Reference | UNSPSC_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $UNSPSC_Code;
    /**
     * The Alternate_Item_Identifiers
     * Meta information extracted from the WSDL
     * - documentation: Alternate Item Identifiers for Catalog Load items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_Alternate_Item_IdentifierType[]
     */
    public $Alternate_Item_Identifiers;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Internal Purchase Item for the Catalog Load Item.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Tags for Catalog Item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType[]
     */
    public $Item_Tag_Reference;
    /**
     * The Primary_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Primary Image for Item
     * - minOccurs: 0
     * @var \StructType\Primary_Image_DataType
     */
    public $Primary_Image_Data;
    /**
     * The Additional_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Additional Image for Item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Additional_Image_DataType[]
     */
    public $Additional_Image_Data;
    /**
     * The Base_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Base Unit of Measure Reference for Catalog Load Item.
     * - choice: Base_Unit_of_Measure_Reference | UN_CEFACT_Base_UOM_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Base_Unit_of_Measure_Reference;
    /**
     * The UN_CEFACT_Base_UOM_Code
     * Meta information extracted from the WSDL
     * - documentation: UN CEFACT Common Code to denote Base UOM of Catalog Load Item.
     * - choice: Base_Unit_of_Measure_Reference | UN_CEFACT_Base_UOM_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UN_CEFACT_Base_UOM_Code;
    /**
     * The Catalog_Load_Item_Unit_of_Measure_Data
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Item Unit of Measure
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_Item_Unit_of_Measure_DataType[]
     */
    public $Catalog_Load_Item_Unit_of_Measure_Data;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Item Packaging String.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * Constructor method for Catalog_Load_Item_DataType
     * @uses Catalog_Load_Item_DataType::setCatalog_Load_Item_Reference()
     * @uses Catalog_Load_Item_DataType::setCatalog_Item_ID()
     * @uses Catalog_Load_Item_DataType::setItem_Identifier()
     * @uses Catalog_Load_Item_DataType::setInactive()
     * @uses Catalog_Load_Item_DataType::setItem_Name()
     * @uses Catalog_Load_Item_DataType::setItem_Description()
     * @uses Catalog_Load_Item_DataType::setItem_URL()
     * @uses Catalog_Load_Item_DataType::setLead_Time()
     * @uses Catalog_Load_Item_DataType::setCommodity_Code_Reference()
     * @uses Catalog_Load_Item_DataType::setSpend_Category_Reference()
     * @uses Catalog_Load_Item_DataType::setUNSPSC_Code()
     * @uses Catalog_Load_Item_DataType::setAlternate_Item_Identifiers()
     * @uses Catalog_Load_Item_DataType::setPurchase_Item_Reference()
     * @uses Catalog_Load_Item_DataType::setItem_Tag_Reference()
     * @uses Catalog_Load_Item_DataType::setPrimary_Image_Data()
     * @uses Catalog_Load_Item_DataType::setAdditional_Image_Data()
     * @uses Catalog_Load_Item_DataType::setBase_Unit_of_Measure_Reference()
     * @uses Catalog_Load_Item_DataType::setUN_CEFACT_Base_UOM_Code()
     * @uses Catalog_Load_Item_DataType::setCatalog_Load_Item_Unit_of_Measure_Data()
     * @uses Catalog_Load_Item_DataType::setPackaging_String()
     * @param \StructType\Catalog_Load_ItemObjectType $catalog_Load_Item_Reference
     * @param string $catalog_Item_ID
     * @param string $item_Identifier
     * @param bool $inactive
     * @param string $item_Name
     * @param string $item_Description
     * @param string $item_URL
     * @param float $lead_Time
     * @param \StructType\Commodity_CodeObjectType[] $commodity_Code_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param float $uNSPSC_Code
     * @param \StructType\Catalog_Load_Alternate_Item_IdentifierType[] $alternate_Item_Identifiers
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @param string $uN_CEFACT_Base_UOM_Code
     * @param \StructType\Catalog_Load_Item_Unit_of_Measure_DataType[] $catalog_Load_Item_Unit_of_Measure_Data
     * @param string $packaging_String
     */
    public function __construct(\StructType\Catalog_Load_ItemObjectType $catalog_Load_Item_Reference = null, $catalog_Item_ID = null, $item_Identifier = null, $inactive = null, $item_Name = null, $item_Description = null, $item_URL = null, $lead_Time = null, array $commodity_Code_Reference = array(), \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $uNSPSC_Code = null, array $alternate_Item_Identifiers = array(), \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, array $item_Tag_Reference = array(), \StructType\Primary_Image_DataType $primary_Image_Data = null, array $additional_Image_Data = array(), \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null, $uN_CEFACT_Base_UOM_Code = null, array $catalog_Load_Item_Unit_of_Measure_Data = array(), $packaging_String = null)
    {
        $this
            ->setCatalog_Load_Item_Reference($catalog_Load_Item_Reference)
            ->setCatalog_Item_ID($catalog_Item_ID)
            ->setItem_Identifier($item_Identifier)
            ->setInactive($inactive)
            ->setItem_Name($item_Name)
            ->setItem_Description($item_Description)
            ->setItem_URL($item_URL)
            ->setLead_Time($lead_Time)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setUNSPSC_Code($uNSPSC_Code)
            ->setAlternate_Item_Identifiers($alternate_Item_Identifiers)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setPrimary_Image_Data($primary_Image_Data)
            ->setAdditional_Image_Data($additional_Image_Data)
            ->setBase_Unit_of_Measure_Reference($base_Unit_of_Measure_Reference)
            ->setUN_CEFACT_Base_UOM_Code($uN_CEFACT_Base_UOM_Code)
            ->setCatalog_Load_Item_Unit_of_Measure_Data($catalog_Load_Item_Unit_of_Measure_Data)
            ->setPackaging_String($packaging_String);
    }
    /**
     * Get Catalog_Load_Item_Reference value
     * @return \StructType\Catalog_Load_ItemObjectType|null
     */
    public function getCatalog_Load_Item_Reference()
    {
        return $this->Catalog_Load_Item_Reference;
    }
    /**
     * Set Catalog_Load_Item_Reference value
     * @param \StructType\Catalog_Load_ItemObjectType $catalog_Load_Item_Reference
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setCatalog_Load_Item_Reference(\StructType\Catalog_Load_ItemObjectType $catalog_Load_Item_Reference = null)
    {
        $this->Catalog_Load_Item_Reference = $catalog_Load_Item_Reference;
        return $this;
    }
    /**
     * Get Catalog_Item_ID value
     * @return string|null
     */
    public function getCatalog_Item_ID()
    {
        return $this->Catalog_Item_ID;
    }
    /**
     * Set Catalog_Item_ID value
     * @param string $catalog_Item_ID
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setCatalog_Item_ID($catalog_Item_ID = null)
    {
        // validation for constraint: string
        if (!is_null($catalog_Item_ID) && !is_string($catalog_Item_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog_Item_ID, true), gettype($catalog_Item_ID)), __LINE__);
        }
        $this->Catalog_Item_ID = $catalog_Item_ID;
        return $this;
    }
    /**
     * Get Item_Identifier value
     * @return string|null
     */
    public function getItem_Identifier()
    {
        return $this->Item_Identifier;
    }
    /**
     * Set Item_Identifier value
     * @param string $item_Identifier
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setItem_Identifier($item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier) && !is_string($item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier, true), gettype($item_Identifier)), __LINE__);
        }
        $this->Item_Identifier = $item_Identifier;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Item_Name value
     * @return string|null
     */
    public function getItem_Name()
    {
        return $this->Item_Name;
    }
    /**
     * Set Item_Name value
     * @param string $item_Name
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setItem_Name($item_Name = null)
    {
        // validation for constraint: string
        if (!is_null($item_Name) && !is_string($item_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Name, true), gettype($item_Name)), __LINE__);
        }
        $this->Item_Name = $item_Name;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Item_URL value
     * @return string|null
     */
    public function getItem_URL()
    {
        return $this->Item_URL;
    }
    /**
     * Set Item_URL value
     * @param string $item_URL
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setItem_URL($item_URL = null)
    {
        // validation for constraint: string
        if (!is_null($item_URL) && !is_string($item_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_URL, true), gettype($item_URL)), __LINE__);
        }
        $this->Item_URL = $item_URL;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType[]|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodity_Code_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodity_Code_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodity_Code_ReferenceForArrayConstraintsFromSetCommodity_Code_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Load_Item_DataTypeCommodity_Code_ReferenceItem) {
            // validation for constraint: itemType
            if (!$catalog_Load_Item_DataTypeCommodity_Code_ReferenceItem instanceof \StructType\Commodity_CodeObjectType) {
                $invalidValues[] = is_object($catalog_Load_Item_DataTypeCommodity_Code_ReferenceItem) ? get_class($catalog_Load_Item_DataTypeCommodity_Code_ReferenceItem) : sprintf('%s(%s)', gettype($catalog_Load_Item_DataTypeCommodity_Code_ReferenceItem), var_export($catalog_Load_Item_DataTypeCommodity_Code_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType[] $commodity_Code_Reference
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setCommodity_Code_Reference(array $commodity_Code_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($commodity_Code_ReferenceArrayErrorMessage = self::validateCommodity_Code_ReferenceForArrayConstraintsFromSetCommodity_Code_Reference($commodity_Code_Reference))) {
            throw new \InvalidArgumentException($commodity_Code_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Add item to Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType $item
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function addToCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_CodeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodity_Code_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return isset($this->Spend_Category_Reference) ? $this->Spend_Category_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSpend_Category_ReferenceForChoiceConstraintsFromSetSpend_Category_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UNSPSC_Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Spend_Category_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Spend_Category_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        // validation for constraint: choice(Spend_Category_Reference, UNSPSC_Code)
        if ('' !== ($spend_Category_ReferenceChoiceErrorMessage = self::validateSpend_Category_ReferenceForChoiceConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($spend_Category_Reference) || (is_array($spend_Category_Reference) && empty($spend_Category_Reference))) {
            unset($this->Spend_Category_Reference);
        } else {
            $this->Spend_Category_Reference = $spend_Category_Reference;
        }
        return $this;
    }
    /**
     * Get UNSPSC_Code value
     * @return float|null
     */
    public function getUNSPSC_Code()
    {
        return isset($this->UNSPSC_Code) ? $this->UNSPSC_Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUNSPSC_Code method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUNSPSC_Code method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUNSPSC_CodeForChoiceConstraintsFromSetUNSPSC_Code($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Spend_Category_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UNSPSC_Code can\'t be set as the property %s is already set. Only one property must be set among these properties: UNSPSC_Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UNSPSC_Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $uNSPSC_Code
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setUNSPSC_Code($uNSPSC_Code = null)
    {
        // validation for constraint: float
        if (!is_null($uNSPSC_Code) && !(is_float($uNSPSC_Code) || is_numeric($uNSPSC_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNSPSC_Code, true), gettype($uNSPSC_Code)), __LINE__);
        }
        // validation for constraint: choice(Spend_Category_Reference, UNSPSC_Code)
        if ('' !== ($uNSPSC_CodeChoiceErrorMessage = self::validateUNSPSC_CodeForChoiceConstraintsFromSetUNSPSC_Code($uNSPSC_Code))) {
            throw new \InvalidArgumentException($uNSPSC_CodeChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($uNSPSC_Code) && mb_strlen(mb_substr($uNSPSC_Code, false !== mb_strpos($uNSPSC_Code, '.') ? mb_strpos($uNSPSC_Code, '.') + 1 : mb_strlen($uNSPSC_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($uNSPSC_Code, true), mb_strlen(mb_substr($uNSPSC_Code, mb_strpos($uNSPSC_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($uNSPSC_Code) && $uNSPSC_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($uNSPSC_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($uNSPSC_Code) && mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($uNSPSC_Code, true), mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code))), __LINE__);
        }
        if (is_null($uNSPSC_Code) || (is_array($uNSPSC_Code) && empty($uNSPSC_Code))) {
            unset($this->UNSPSC_Code);
        } else {
            $this->UNSPSC_Code = $uNSPSC_Code;
        }
        return $this;
    }
    /**
     * Get Alternate_Item_Identifiers value
     * @return \StructType\Catalog_Load_Alternate_Item_IdentifierType[]|null
     */
    public function getAlternate_Item_Identifiers()
    {
        return $this->Alternate_Item_Identifiers;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifiers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifiers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_IdentifiersForArrayConstraintsFromSetAlternate_Item_Identifiers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Load_Item_DataTypeAlternate_Item_IdentifiersItem) {
            // validation for constraint: itemType
            if (!$catalog_Load_Item_DataTypeAlternate_Item_IdentifiersItem instanceof \StructType\Catalog_Load_Alternate_Item_IdentifierType) {
                $invalidValues[] = is_object($catalog_Load_Item_DataTypeAlternate_Item_IdentifiersItem) ? get_class($catalog_Load_Item_DataTypeAlternate_Item_IdentifiersItem) : sprintf('%s(%s)', gettype($catalog_Load_Item_DataTypeAlternate_Item_IdentifiersItem), var_export($catalog_Load_Item_DataTypeAlternate_Item_IdentifiersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifiers property can only contain items of type \StructType\Catalog_Load_Alternate_Item_IdentifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifiers value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Alternate_Item_IdentifierType[] $alternate_Item_Identifiers
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setAlternate_Item_Identifiers(array $alternate_Item_Identifiers = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_IdentifiersArrayErrorMessage = self::validateAlternate_Item_IdentifiersForArrayConstraintsFromSetAlternate_Item_Identifiers($alternate_Item_Identifiers))) {
            throw new \InvalidArgumentException($alternate_Item_IdentifiersArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifiers = $alternate_Item_Identifiers;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifiers value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Alternate_Item_IdentifierType $item
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function addToAlternate_Item_Identifiers(\StructType\Catalog_Load_Alternate_Item_IdentifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Load_Alternate_Item_IdentifierType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifiers property can only contain items of type \StructType\Catalog_Load_Alternate_Item_IdentifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifiers[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType[]|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Load_Item_DataTypeItem_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$catalog_Load_Item_DataTypeItem_Tag_ReferenceItem instanceof \StructType\Item_TagObjectType) {
                $invalidValues[] = is_object($catalog_Load_Item_DataTypeItem_Tag_ReferenceItem) ? get_class($catalog_Load_Item_DataTypeItem_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($catalog_Load_Item_DataTypeItem_Tag_ReferenceItem), var_export($catalog_Load_Item_DataTypeItem_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setItem_Tag_Reference(array $item_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_ReferenceArrayErrorMessage = self::validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference($item_Tag_Reference))) {
            throw new \InvalidArgumentException($item_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType $item
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function addToItem_Tag_Reference(\StructType\Item_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Primary_Image_Data value
     * @return \StructType\Primary_Image_DataType|null
     */
    public function getPrimary_Image_Data()
    {
        return $this->Primary_Image_Data;
    }
    /**
     * Set Primary_Image_Data value
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setPrimary_Image_Data(\StructType\Primary_Image_DataType $primary_Image_Data = null)
    {
        $this->Primary_Image_Data = $primary_Image_Data;
        return $this;
    }
    /**
     * Get Additional_Image_Data value
     * @return \StructType\Additional_Image_DataType[]|null
     */
    public function getAdditional_Image_Data()
    {
        return $this->Additional_Image_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Image_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Image_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Load_Item_DataTypeAdditional_Image_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_Load_Item_DataTypeAdditional_Image_DataItem instanceof \StructType\Additional_Image_DataType) {
                $invalidValues[] = is_object($catalog_Load_Item_DataTypeAdditional_Image_DataItem) ? get_class($catalog_Load_Item_DataTypeAdditional_Image_DataItem) : sprintf('%s(%s)', gettype($catalog_Load_Item_DataTypeAdditional_Image_DataItem), var_export($catalog_Load_Item_DataTypeAdditional_Image_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setAdditional_Image_Data(array $additional_Image_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Image_DataArrayErrorMessage = self::validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data($additional_Image_Data))) {
            throw new \InvalidArgumentException($additional_Image_DataArrayErrorMessage, __LINE__);
        }
        $this->Additional_Image_Data = $additional_Image_Data;
        return $this;
    }
    /**
     * Add item to Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType $item
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function addToAdditional_Image_Data(\StructType\Additional_Image_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Additional_Image_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Image_Data[] = $item;
        return $this;
    }
    /**
     * Get Base_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getBase_Unit_of_Measure_Reference()
    {
        return isset($this->Base_Unit_of_Measure_Reference) ? $this->Base_Unit_of_Measure_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBase_Unit_of_Measure_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBase_Unit_of_Measure_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBase_Unit_of_Measure_ReferenceForChoiceConstraintsFromSetBase_Unit_of_Measure_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UN_CEFACT_Base_UOM_Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Base_Unit_of_Measure_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Base_Unit_of_Measure_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Base_Unit_of_Measure_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setBase_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null)
    {
        // validation for constraint: choice(Base_Unit_of_Measure_Reference, UN_CEFACT_Base_UOM_Code)
        if ('' !== ($base_Unit_of_Measure_ReferenceChoiceErrorMessage = self::validateBase_Unit_of_Measure_ReferenceForChoiceConstraintsFromSetBase_Unit_of_Measure_Reference($base_Unit_of_Measure_Reference))) {
            throw new \InvalidArgumentException($base_Unit_of_Measure_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($base_Unit_of_Measure_Reference) || (is_array($base_Unit_of_Measure_Reference) && empty($base_Unit_of_Measure_Reference))) {
            unset($this->Base_Unit_of_Measure_Reference);
        } else {
            $this->Base_Unit_of_Measure_Reference = $base_Unit_of_Measure_Reference;
        }
        return $this;
    }
    /**
     * Get UN_CEFACT_Base_UOM_Code value
     * @return string|null
     */
    public function getUN_CEFACT_Base_UOM_Code()
    {
        return isset($this->UN_CEFACT_Base_UOM_Code) ? $this->UN_CEFACT_Base_UOM_Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUN_CEFACT_Base_UOM_Code method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUN_CEFACT_Base_UOM_Code method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUN_CEFACT_Base_UOM_CodeForChoiceConstraintsFromSetUN_CEFACT_Base_UOM_Code($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Base_Unit_of_Measure_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UN_CEFACT_Base_UOM_Code can\'t be set as the property %s is already set. Only one property must be set among these properties: UN_CEFACT_Base_UOM_Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UN_CEFACT_Base_UOM_Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uN_CEFACT_Base_UOM_Code
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setUN_CEFACT_Base_UOM_Code($uN_CEFACT_Base_UOM_Code = null)
    {
        // validation for constraint: string
        if (!is_null($uN_CEFACT_Base_UOM_Code) && !is_string($uN_CEFACT_Base_UOM_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uN_CEFACT_Base_UOM_Code, true), gettype($uN_CEFACT_Base_UOM_Code)), __LINE__);
        }
        // validation for constraint: choice(Base_Unit_of_Measure_Reference, UN_CEFACT_Base_UOM_Code)
        if ('' !== ($uN_CEFACT_Base_UOM_CodeChoiceErrorMessage = self::validateUN_CEFACT_Base_UOM_CodeForChoiceConstraintsFromSetUN_CEFACT_Base_UOM_Code($uN_CEFACT_Base_UOM_Code))) {
            throw new \InvalidArgumentException($uN_CEFACT_Base_UOM_CodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($uN_CEFACT_Base_UOM_Code) || (is_array($uN_CEFACT_Base_UOM_Code) && empty($uN_CEFACT_Base_UOM_Code))) {
            unset($this->UN_CEFACT_Base_UOM_Code);
        } else {
            $this->UN_CEFACT_Base_UOM_Code = $uN_CEFACT_Base_UOM_Code;
        }
        return $this;
    }
    /**
     * Get Catalog_Load_Item_Unit_of_Measure_Data value
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType[]|null
     */
    public function getCatalog_Load_Item_Unit_of_Measure_Data()
    {
        return $this->Catalog_Load_Item_Unit_of_Measure_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Load_Item_Unit_of_Measure_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Load_Item_Unit_of_Measure_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Load_Item_Unit_of_Measure_DataForArrayConstraintsFromSetCatalog_Load_Item_Unit_of_Measure_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Load_Item_DataTypeCatalog_Load_Item_Unit_of_Measure_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_Load_Item_DataTypeCatalog_Load_Item_Unit_of_Measure_DataItem instanceof \StructType\Catalog_Load_Item_Unit_of_Measure_DataType) {
                $invalidValues[] = is_object($catalog_Load_Item_DataTypeCatalog_Load_Item_Unit_of_Measure_DataItem) ? get_class($catalog_Load_Item_DataTypeCatalog_Load_Item_Unit_of_Measure_DataItem) : sprintf('%s(%s)', gettype($catalog_Load_Item_DataTypeCatalog_Load_Item_Unit_of_Measure_DataItem), var_export($catalog_Load_Item_DataTypeCatalog_Load_Item_Unit_of_Measure_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Load_Item_Unit_of_Measure_Data property can only contain items of type \StructType\Catalog_Load_Item_Unit_of_Measure_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Load_Item_Unit_of_Measure_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Item_Unit_of_Measure_DataType[] $catalog_Load_Item_Unit_of_Measure_Data
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setCatalog_Load_Item_Unit_of_Measure_Data(array $catalog_Load_Item_Unit_of_Measure_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Load_Item_Unit_of_Measure_DataArrayErrorMessage = self::validateCatalog_Load_Item_Unit_of_Measure_DataForArrayConstraintsFromSetCatalog_Load_Item_Unit_of_Measure_Data($catalog_Load_Item_Unit_of_Measure_Data))) {
            throw new \InvalidArgumentException($catalog_Load_Item_Unit_of_Measure_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Load_Item_Unit_of_Measure_Data = $catalog_Load_Item_Unit_of_Measure_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Load_Item_Unit_of_Measure_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Load_Item_Unit_of_Measure_DataType $item
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function addToCatalog_Load_Item_Unit_of_Measure_Data(\StructType\Catalog_Load_Item_Unit_of_Measure_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Load_Item_Unit_of_Measure_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Load_Item_Unit_of_Measure_Data property can only contain items of type \StructType\Catalog_Load_Item_Unit_of_Measure_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Load_Item_Unit_of_Measure_Data[] = $item;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Catalog_Load_Item_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
}
