<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airport_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Spend Data instances of the same Data Value and Attribute Type is not allowed. | Element that contains Airport Data
 * @subpackage Structs
 */
class Airport_DataType extends AbstractStructBase
{
    /**
     * The Spend_Data_ID
     * Meta information extracted from the WSDL
     * - documentation: Airport ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Data_ID;
    /**
     * The Airport_Value
     * Meta information extracted from the WSDL
     * - documentation: Airport Value
     * - maxOccurs: 1
     * @var string
     */
    public $Airport_Value;
    /**
     * The Airport_Name
     * Meta information extracted from the WSDL
     * - documentation: Airport Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Airport_Name;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country in which Airport is located
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Country_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country Region within which the Airport is located
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Country_Region_Reference;
    /**
     * The Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel City in which Airport is located
     * - minOccurs: 0
     * @var \StructType\Travel_CityObjectType
     */
    public $Travel_City_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: If the value is 1, the airport will be marked as inactive. By default , airports are considered active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Airport_DataType
     * @uses Airport_DataType::setSpend_Data_ID()
     * @uses Airport_DataType::setAirport_Value()
     * @uses Airport_DataType::setAirport_Name()
     * @uses Airport_DataType::setCountry_Reference()
     * @uses Airport_DataType::setCountry_Region_Reference()
     * @uses Airport_DataType::setTravel_City_Reference()
     * @uses Airport_DataType::setInactive()
     * @param string $spend_Data_ID
     * @param string $airport_Value
     * @param string $airport_Name
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\Country_RegionObjectType $country_Region_Reference
     * @param \StructType\Travel_CityObjectType $travel_City_Reference
     * @param bool $inactive
     */
    public function __construct($spend_Data_ID = null, $airport_Value = null, $airport_Name = null, \StructType\CountryObjectType $country_Reference = null, \StructType\Country_RegionObjectType $country_Region_Reference = null, \StructType\Travel_CityObjectType $travel_City_Reference = null, $inactive = null)
    {
        $this
            ->setSpend_Data_ID($spend_Data_ID)
            ->setAirport_Value($airport_Value)
            ->setAirport_Name($airport_Name)
            ->setCountry_Reference($country_Reference)
            ->setCountry_Region_Reference($country_Region_Reference)
            ->setTravel_City_Reference($travel_City_Reference)
            ->setInactive($inactive);
    }
    /**
     * Get Spend_Data_ID value
     * @return string|null
     */
    public function getSpend_Data_ID()
    {
        return $this->Spend_Data_ID;
    }
    /**
     * Set Spend_Data_ID value
     * @param string $spend_Data_ID
     * @return \StructType\Airport_DataType
     */
    public function setSpend_Data_ID($spend_Data_ID = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Data_ID) && !is_string($spend_Data_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Data_ID, true), gettype($spend_Data_ID)), __LINE__);
        }
        $this->Spend_Data_ID = $spend_Data_ID;
        return $this;
    }
    /**
     * Get Airport_Value value
     * @return string|null
     */
    public function getAirport_Value()
    {
        return $this->Airport_Value;
    }
    /**
     * Set Airport_Value value
     * @param string $airport_Value
     * @return \StructType\Airport_DataType
     */
    public function setAirport_Value($airport_Value = null)
    {
        // validation for constraint: string
        if (!is_null($airport_Value) && !is_string($airport_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airport_Value, true), gettype($airport_Value)), __LINE__);
        }
        $this->Airport_Value = $airport_Value;
        return $this;
    }
    /**
     * Get Airport_Name value
     * @return string|null
     */
    public function getAirport_Name()
    {
        return $this->Airport_Name;
    }
    /**
     * Set Airport_Name value
     * @param string $airport_Name
     * @return \StructType\Airport_DataType
     */
    public function setAirport_Name($airport_Name = null)
    {
        // validation for constraint: string
        if (!is_null($airport_Name) && !is_string($airport_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airport_Name, true), gettype($airport_Name)), __LINE__);
        }
        $this->Airport_Name = $airport_Name;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Airport_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Country_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getCountry_Region_Reference()
    {
        return $this->Country_Region_Reference;
    }
    /**
     * Set Country_Region_Reference value
     * @param \StructType\Country_RegionObjectType $country_Region_Reference
     * @return \StructType\Airport_DataType
     */
    public function setCountry_Region_Reference(\StructType\Country_RegionObjectType $country_Region_Reference = null)
    {
        $this->Country_Region_Reference = $country_Region_Reference;
        return $this;
    }
    /**
     * Get Travel_City_Reference value
     * @return \StructType\Travel_CityObjectType|null
     */
    public function getTravel_City_Reference()
    {
        return $this->Travel_City_Reference;
    }
    /**
     * Set Travel_City_Reference value
     * @param \StructType\Travel_CityObjectType $travel_City_Reference
     * @return \StructType\Airport_DataType
     */
    public function setTravel_City_Reference(\StructType\Travel_CityObjectType $travel_City_Reference = null)
    {
        $this->Travel_City_Reference = $travel_City_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Airport_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
