<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Refund_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Refund request criteria.
 * @subpackage Structs
 */
class Supplier_Refund_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for Refund Transaction
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType[]
     */
    public $Currency_Reference;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Refund Payment Type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType[]
     */
    public $Payment_Type_Reference;
    /**
     * The Refund_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Supplier Refund On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Refund_Date_On_or_After;
    /**
     * The Refund_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Supplier Refund On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Refund_Date_On_or_Before;
    /**
     * Constructor method for Supplier_Refund_Request_CriteriaType
     * @uses Supplier_Refund_Request_CriteriaType::setCompany_Reference()
     * @uses Supplier_Refund_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Refund_Request_CriteriaType::setCurrency_Reference()
     * @uses Supplier_Refund_Request_CriteriaType::setPayment_Type_Reference()
     * @uses Supplier_Refund_Request_CriteriaType::setRefund_Date_On_or_After()
     * @uses Supplier_Refund_Request_CriteriaType::setRefund_Date_On_or_Before()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     * @param \StructType\Payment_TypeObjectType[] $payment_Type_Reference
     * @param string $refund_Date_On_or_After
     * @param string $refund_Date_On_or_Before
     */
    public function __construct(array $company_Reference = array(), array $supplier_Reference = array(), array $currency_Reference = array(), array $payment_Type_Reference = array(), $refund_Date_On_or_After = null, $refund_Date_On_or_Before = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setRefund_Date_On_or_After($refund_Date_On_or_After)
            ->setRefund_Date_On_or_Before($refund_Date_On_or_Before);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Refund_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($supplier_Refund_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Refund_Request_CriteriaTypeCompany_ReferenceItem), var_export($supplier_Refund_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Refund_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Refund_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Refund_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Refund_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType[]|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_Request_CriteriaTypeCurrency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_Request_CriteriaTypeCurrency_ReferenceItem instanceof \StructType\CurrencyObjectType) {
                $invalidValues[] = is_object($supplier_Refund_Request_CriteriaTypeCurrency_ReferenceItem) ? get_class($supplier_Refund_Request_CriteriaTypeCurrency_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Refund_Request_CriteriaTypeCurrency_ReferenceItem), var_export($supplier_Refund_Request_CriteriaTypeCurrency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType[] $currency_Reference
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function setCurrency_Reference(array $currency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_ReferenceArrayErrorMessage = self::validateCurrency_ReferenceForArrayConstraintsFromSetCurrency_Reference($currency_Reference))) {
            throw new \InvalidArgumentException($currency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Add item to Currency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CurrencyObjectType $item
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function addToCurrency_Reference(\StructType\CurrencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CurrencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Reference property can only contain items of type \StructType\CurrencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Reference[] = $item;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType[]|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPayment_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayment_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayment_Type_ReferenceForArrayConstraintsFromSetPayment_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_Request_CriteriaTypePayment_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_Request_CriteriaTypePayment_Type_ReferenceItem instanceof \StructType\Payment_TypeObjectType) {
                $invalidValues[] = is_object($supplier_Refund_Request_CriteriaTypePayment_Type_ReferenceItem) ? get_class($supplier_Refund_Request_CriteriaTypePayment_Type_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Refund_Request_CriteriaTypePayment_Type_ReferenceItem), var_export($supplier_Refund_Request_CriteriaTypePayment_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payment_Type_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payment_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType[] $payment_Type_Reference
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function setPayment_Type_Reference(array $payment_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($payment_Type_ReferenceArrayErrorMessage = self::validatePayment_Type_ReferenceForArrayConstraintsFromSetPayment_Type_Reference($payment_Type_Reference))) {
            throw new \InvalidArgumentException($payment_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Add item to Payment_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Payment_TypeObjectType $item
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function addToPayment_Type_Reference(\StructType\Payment_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payment_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Payment_Type_Reference property can only contain items of type \StructType\Payment_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payment_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Refund_Date_On_or_After value
     * @return string|null
     */
    public function getRefund_Date_On_or_After()
    {
        return $this->Refund_Date_On_or_After;
    }
    /**
     * Set Refund_Date_On_or_After value
     * @param string $refund_Date_On_or_After
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function setRefund_Date_On_or_After($refund_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($refund_Date_On_or_After) && !is_string($refund_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refund_Date_On_or_After, true), gettype($refund_Date_On_or_After)), __LINE__);
        }
        $this->Refund_Date_On_or_After = $refund_Date_On_or_After;
        return $this;
    }
    /**
     * Get Refund_Date_On_or_Before value
     * @return string|null
     */
    public function getRefund_Date_On_or_Before()
    {
        return $this->Refund_Date_On_or_Before;
    }
    /**
     * Set Refund_Date_On_or_Before value
     * @param string $refund_Date_On_or_Before
     * @return \StructType\Supplier_Refund_Request_CriteriaType
     */
    public function setRefund_Date_On_or_Before($refund_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($refund_Date_On_or_Before) && !is_string($refund_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refund_Date_On_or_Before, true), gettype($refund_Date_On_or_Before)), __LINE__);
        }
        $this->Refund_Date_On_or_Before = $refund_Date_On_or_Before;
        return $this;
    }
}
