<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Resource_Category_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Spend Category reference for update and all Spend Category data items
 * @subpackage Structs
 */
class Put_Resource_Category_RequestType extends AbstractStructBase
{
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category for update only purposes
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Resource_Category_Data
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Data
     * @var \StructType\Spend_Category_DataType
     */
    public $Resource_Category_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Resource_Category_RequestType
     * @uses Put_Resource_Category_RequestType::setResource_Category_Reference()
     * @uses Put_Resource_Category_RequestType::setResource_Category_Data()
     * @uses Put_Resource_Category_RequestType::setAdd_Only()
     * @uses Put_Resource_Category_RequestType::setVersion()
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Spend_Category_DataType $resource_Category_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null, \StructType\Spend_Category_DataType $resource_Category_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setResource_Category_Data($resource_Category_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Put_Resource_Category_RequestType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Resource_Category_Data value
     * @return \StructType\Spend_Category_DataType|null
     */
    public function getResource_Category_Data()
    {
        return $this->Resource_Category_Data;
    }
    /**
     * Set Resource_Category_Data value
     * @param \StructType\Spend_Category_DataType $resource_Category_Data
     * @return \StructType\Put_Resource_Category_RequestType
     */
    public function setResource_Category_Data(\StructType\Spend_Category_DataType $resource_Category_Data = null)
    {
        $this->Resource_Category_Data = $resource_Category_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Resource_Category_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Resource_Category_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
