<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Airport_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Airport, or change 'Add Only' to 'false' to edit the existing Airport. | Element containing Airport reference for update and all Airport data items
 * @subpackage Structs
 */
class Put_Airport_RequestType extends AbstractStructBase
{
    /**
     * The Airport_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airport Reference
     * - minOccurs: 0
     * @var \StructType\AirportObjectType
     */
    public $Airport_Reference;
    /**
     * The Airport_Data
     * Meta information extracted from the WSDL
     * - documentation: Airport Data
     * @var \StructType\Airport_DataType
     */
    public $Airport_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Airport_RequestType
     * @uses Put_Airport_RequestType::setAirport_Reference()
     * @uses Put_Airport_RequestType::setAirport_Data()
     * @uses Put_Airport_RequestType::setAdd_Only()
     * @uses Put_Airport_RequestType::setVersion()
     * @param \StructType\AirportObjectType $airport_Reference
     * @param \StructType\Airport_DataType $airport_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\AirportObjectType $airport_Reference = null, \StructType\Airport_DataType $airport_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setAirport_Reference($airport_Reference)
            ->setAirport_Data($airport_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Airport_Reference value
     * @return \StructType\AirportObjectType|null
     */
    public function getAirport_Reference()
    {
        return $this->Airport_Reference;
    }
    /**
     * Set Airport_Reference value
     * @param \StructType\AirportObjectType $airport_Reference
     * @return \StructType\Put_Airport_RequestType
     */
    public function setAirport_Reference(\StructType\AirportObjectType $airport_Reference = null)
    {
        $this->Airport_Reference = $airport_Reference;
        return $this;
    }
    /**
     * Get Airport_Data value
     * @return \StructType\Airport_DataType|null
     */
    public function getAirport_Data()
    {
        return $this->Airport_Data;
    }
    /**
     * Set Airport_Data value
     * @param \StructType\Airport_DataType $airport_Data
     * @return \StructType\Put_Airport_RequestType
     */
    public function setAirport_Data(\StructType\Airport_DataType $airport_Data = null)
    {
        $this->Airport_Data = $airport_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Airport_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Airport_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
