<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Report Reference element contains the specific instance set containing the requested Expense Report. The ID is the value and the Type attribute is either the Lookup ID type or the Workday ID (GUID) for the instance of Expense
 * Report.
 * @subpackage Structs
 */
class Expense_Report_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Expense Report object.
     * - maxOccurs: unbounded
     * @var \StructType\Expense_ReportObjectType[]
     */
    public $Expense_Report_Reference;
    /**
     * Constructor method for Expense_Report_Request_ReferencesType
     * @uses Expense_Report_Request_ReferencesType::setExpense_Report_Reference()
     * @param \StructType\Expense_ReportObjectType[] $expense_Report_Reference
     */
    public function __construct(array $expense_Report_Reference = array())
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType[]|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Report_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Report_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Report_ReferenceForArrayConstraintsFromSetExpense_Report_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Request_ReferencesTypeExpense_Report_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Request_ReferencesTypeExpense_Report_ReferenceItem instanceof \StructType\Expense_ReportObjectType) {
                $invalidValues[] = is_object($expense_Report_Request_ReferencesTypeExpense_Report_ReferenceItem) ? get_class($expense_Report_Request_ReferencesTypeExpense_Report_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Request_ReferencesTypeExpense_Report_ReferenceItem), var_export($expense_Report_Request_ReferencesTypeExpense_Report_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Report_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Report_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType[] $expense_Report_Reference
     * @return \StructType\Expense_Report_Request_ReferencesType
     */
    public function setExpense_Report_Reference(array $expense_Report_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Report_ReferenceArrayErrorMessage = self::validateExpense_Report_ReferenceForArrayConstraintsFromSetExpense_Report_Reference($expense_Report_Reference))) {
            throw new \InvalidArgumentException($expense_Report_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Report_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType $item
     * @return \StructType\Expense_Report_Request_ReferencesType
     */
    public function addToExpense_Report_Reference(\StructType\Expense_ReportObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ReportObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Report_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Report_Reference[] = $item;
        return $this;
    }
}
