<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_Code_Type_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Commodity Code Type Request References
 * @subpackage Structs
 */
class Commodity_Code_Type_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Commodity_Code_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Commodity Code Type to be retrieved
     * - maxOccurs: unbounded
     * @var \StructType\Commodity_Code_TypeObjectType[]
     */
    public $Commodity_Code_Type_Reference;
    /**
     * Constructor method for Commodity_Code_Type_Request_ReferencesType
     * @uses Commodity_Code_Type_Request_ReferencesType::setCommodity_Code_Type_Reference()
     * @param \StructType\Commodity_Code_TypeObjectType[] $commodity_Code_Type_Reference
     */
    public function __construct(array $commodity_Code_Type_Reference = array())
    {
        $this
            ->setCommodity_Code_Type_Reference($commodity_Code_Type_Reference);
    }
    /**
     * Get Commodity_Code_Type_Reference value
     * @return \StructType\Commodity_Code_TypeObjectType[]|null
     */
    public function getCommodity_Code_Type_Reference()
    {
        return $this->Commodity_Code_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodity_Code_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodity_Code_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodity_Code_Type_ReferenceForArrayConstraintsFromSetCommodity_Code_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_Code_Type_Request_ReferencesTypeCommodity_Code_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$commodity_Code_Type_Request_ReferencesTypeCommodity_Code_Type_ReferenceItem instanceof \StructType\Commodity_Code_TypeObjectType) {
                $invalidValues[] = is_object($commodity_Code_Type_Request_ReferencesTypeCommodity_Code_Type_ReferenceItem) ? get_class($commodity_Code_Type_Request_ReferencesTypeCommodity_Code_Type_ReferenceItem) : sprintf('%s(%s)', gettype($commodity_Code_Type_Request_ReferencesTypeCommodity_Code_Type_ReferenceItem), var_export($commodity_Code_Type_Request_ReferencesTypeCommodity_Code_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodity_Code_Type_Reference property can only contain items of type \StructType\Commodity_Code_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodity_Code_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_Code_TypeObjectType[] $commodity_Code_Type_Reference
     * @return \StructType\Commodity_Code_Type_Request_ReferencesType
     */
    public function setCommodity_Code_Type_Reference(array $commodity_Code_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($commodity_Code_Type_ReferenceArrayErrorMessage = self::validateCommodity_Code_Type_ReferenceForArrayConstraintsFromSetCommodity_Code_Type_Reference($commodity_Code_Type_Reference))) {
            throw new \InvalidArgumentException($commodity_Code_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Commodity_Code_Type_Reference = $commodity_Code_Type_Reference;
        return $this;
    }
    /**
     * Add item to Commodity_Code_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_Code_TypeObjectType $item
     * @return \StructType\Commodity_Code_Type_Request_ReferencesType
     */
    public function addToCommodity_Code_Type_Reference(\StructType\Commodity_Code_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_Code_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Commodity_Code_Type_Reference property can only contain items of type \StructType\Commodity_Code_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodity_Code_Type_Reference[] = $item;
        return $this;
    }
}
