<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attendee_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that encapsulates the attendee type info (worker, guest, guest name). Only one value can be used at a time.
 * @subpackage Structs
 */
class Attendee_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The applicant you have entered is not valid. You must use the employee instance for this person. | Reference to the worker or applicant who was an attendee for the expense.
     * - choice: Worker_Reference | Guest_Reference | Guest_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Worker_Reference;
    /**
     * The Guest_Reference
     * Meta information extracted from the WSDL
     * - documentation: The guest you have entered is not valid for the expense payee | Reference to the guest who was an attendee for the expense. Only guests associated with the expense payee will be allowed.
     * - choice: Worker_Reference | Guest_Reference | Guest_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Guest_Reference;
    /**
     * The Guest_Name
     * Meta information extracted from the WSDL
     * - documentation: Text representing the name of the guest. If the guest exists already and is associated with the expense payee then it will be used. Otherwise, a new guest will be created.
     * - choice: Worker_Reference | Guest_Reference | Guest_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guest_Name;
    /**
     * Constructor method for Attendee_DataType
     * @uses Attendee_DataType::setWorker_Reference()
     * @uses Attendee_DataType::setGuest_Reference()
     * @uses Attendee_DataType::setGuest_Name()
     * @param \StructType\Expense_PayeeObjectType $worker_Reference
     * @param \StructType\Unique_IdentifierObjectType $guest_Reference
     * @param string $guest_Name
     */
    public function __construct(\StructType\Expense_PayeeObjectType $worker_Reference = null, \StructType\Unique_IdentifierObjectType $guest_Reference = null, $guest_Name = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setGuest_Reference($guest_Reference)
            ->setGuest_Name($guest_Name);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getWorker_Reference()
    {
        return isset($this->Worker_Reference) ? $this->Worker_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWorker_ReferenceForChoiceConstraintsFromSetWorker_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Guest_Reference',
            'Guest_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Worker_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Worker_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Worker_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $worker_Reference
     * @return \StructType\Attendee_DataType
     */
    public function setWorker_Reference(\StructType\Expense_PayeeObjectType $worker_Reference = null)
    {
        // validation for constraint: choice(Worker_Reference, Guest_Reference, Guest_Name)
        if ('' !== ($worker_ReferenceChoiceErrorMessage = self::validateWorker_ReferenceForChoiceConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($worker_Reference) || (is_array($worker_Reference) && empty($worker_Reference))) {
            unset($this->Worker_Reference);
        } else {
            $this->Worker_Reference = $worker_Reference;
        }
        return $this;
    }
    /**
     * Get Guest_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getGuest_Reference()
    {
        return isset($this->Guest_Reference) ? $this->Guest_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGuest_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGuest_ReferenceForChoiceConstraintsFromSetGuest_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Worker_Reference',
            'Guest_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Guest_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Guest_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Guest_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $guest_Reference
     * @return \StructType\Attendee_DataType
     */
    public function setGuest_Reference(\StructType\Unique_IdentifierObjectType $guest_Reference = null)
    {
        // validation for constraint: choice(Worker_Reference, Guest_Reference, Guest_Name)
        if ('' !== ($guest_ReferenceChoiceErrorMessage = self::validateGuest_ReferenceForChoiceConstraintsFromSetGuest_Reference($guest_Reference))) {
            throw new \InvalidArgumentException($guest_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($guest_Reference) || (is_array($guest_Reference) && empty($guest_Reference))) {
            unset($this->Guest_Reference);
        } else {
            $this->Guest_Reference = $guest_Reference;
        }
        return $this;
    }
    /**
     * Get Guest_Name value
     * @return string|null
     */
    public function getGuest_Name()
    {
        return isset($this->Guest_Name) ? $this->Guest_Name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGuest_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest_Name method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGuest_NameForChoiceConstraintsFromSetGuest_Name($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Worker_Reference',
            'Guest_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Guest_Name can\'t be set as the property %s is already set. Only one property must be set among these properties: Guest_Name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Guest_Name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $guest_Name
     * @return \StructType\Attendee_DataType
     */
    public function setGuest_Name($guest_Name = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Name) && !is_string($guest_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Name, true), gettype($guest_Name)), __LINE__);
        }
        // validation for constraint: choice(Worker_Reference, Guest_Reference, Guest_Name)
        if ('' !== ($guest_NameChoiceErrorMessage = self::validateGuest_NameForChoiceConstraintsFromSetGuest_Name($guest_Name))) {
            throw new \InvalidArgumentException($guest_NameChoiceErrorMessage, __LINE__);
        }
        if (is_null($guest_Name) || (is_array($guest_Name) && empty($guest_Name))) {
            unset($this->Guest_Name);
        } else {
            $this->Guest_Name = $guest_Name;
        }
        return $this;
    }
}
