<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worktag_Split_Template_Criteria_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for Worktag Split Template Restriction
 * @subpackage Structs
 */
class Worktag_Split_Template_Criteria_DataType extends AbstractStructBase
{
    /**
     * The Worktag_Split_Template_Restriction_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for Worktag Split Template Restriction Data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worktag_Split_Template_Restriction_ID;
    /**
     * The Template_Restriction_Name
     * Meta information extracted from the WSDL
     * - documentation: Name for Worktag Split Template Restriction
     * - maxOccurs: 1
     * @var string
     */
    public $Template_Restriction_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description for Worktag Split Template Restriction
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Restricted_To_Companies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Restrict by Companies and Company Hierarchies for Worktag Split Template Restriction
     * - maxOccurs: unbounded
     * @var \StructType\OrganizationObjectType[]
     */
    public $Restricted_To_Companies_Reference;
    /**
     * Constructor method for Worktag_Split_Template_Criteria_DataType
     * @uses Worktag_Split_Template_Criteria_DataType::setWorktag_Split_Template_Restriction_ID()
     * @uses Worktag_Split_Template_Criteria_DataType::setTemplate_Restriction_Name()
     * @uses Worktag_Split_Template_Criteria_DataType::setDescription()
     * @uses Worktag_Split_Template_Criteria_DataType::setRestricted_To_Companies_Reference()
     * @param string $worktag_Split_Template_Restriction_ID
     * @param string $template_Restriction_Name
     * @param string $description
     * @param \StructType\OrganizationObjectType[] $restricted_To_Companies_Reference
     */
    public function __construct($worktag_Split_Template_Restriction_ID = null, $template_Restriction_Name = null, $description = null, array $restricted_To_Companies_Reference = array())
    {
        $this
            ->setWorktag_Split_Template_Restriction_ID($worktag_Split_Template_Restriction_ID)
            ->setTemplate_Restriction_Name($template_Restriction_Name)
            ->setDescription($description)
            ->setRestricted_To_Companies_Reference($restricted_To_Companies_Reference);
    }
    /**
     * Get Worktag_Split_Template_Restriction_ID value
     * @return string|null
     */
    public function getWorktag_Split_Template_Restriction_ID()
    {
        return $this->Worktag_Split_Template_Restriction_ID;
    }
    /**
     * Set Worktag_Split_Template_Restriction_ID value
     * @param string $worktag_Split_Template_Restriction_ID
     * @return \StructType\Worktag_Split_Template_Criteria_DataType
     */
    public function setWorktag_Split_Template_Restriction_ID($worktag_Split_Template_Restriction_ID = null)
    {
        // validation for constraint: string
        if (!is_null($worktag_Split_Template_Restriction_ID) && !is_string($worktag_Split_Template_Restriction_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worktag_Split_Template_Restriction_ID, true), gettype($worktag_Split_Template_Restriction_ID)), __LINE__);
        }
        $this->Worktag_Split_Template_Restriction_ID = $worktag_Split_Template_Restriction_ID;
        return $this;
    }
    /**
     * Get Template_Restriction_Name value
     * @return string|null
     */
    public function getTemplate_Restriction_Name()
    {
        return $this->Template_Restriction_Name;
    }
    /**
     * Set Template_Restriction_Name value
     * @param string $template_Restriction_Name
     * @return \StructType\Worktag_Split_Template_Criteria_DataType
     */
    public function setTemplate_Restriction_Name($template_Restriction_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Restriction_Name) && !is_string($template_Restriction_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Restriction_Name, true), gettype($template_Restriction_Name)), __LINE__);
        }
        $this->Template_Restriction_Name = $template_Restriction_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Worktag_Split_Template_Criteria_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Restricted_To_Companies_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getRestricted_To_Companies_Reference()
    {
        return $this->Restricted_To_Companies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_To_Companies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_To_Companies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_To_Companies_ReferenceForArrayConstraintsFromSetRestricted_To_Companies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worktag_Split_Template_Criteria_DataTypeRestricted_To_Companies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$worktag_Split_Template_Criteria_DataTypeRestricted_To_Companies_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($worktag_Split_Template_Criteria_DataTypeRestricted_To_Companies_ReferenceItem) ? get_class($worktag_Split_Template_Criteria_DataTypeRestricted_To_Companies_ReferenceItem) : sprintf('%s(%s)', gettype($worktag_Split_Template_Criteria_DataTypeRestricted_To_Companies_ReferenceItem), var_export($worktag_Split_Template_Criteria_DataTypeRestricted_To_Companies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_To_Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_To_Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $restricted_To_Companies_Reference
     * @return \StructType\Worktag_Split_Template_Criteria_DataType
     */
    public function setRestricted_To_Companies_Reference(array $restricted_To_Companies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_To_Companies_ReferenceArrayErrorMessage = self::validateRestricted_To_Companies_ReferenceForArrayConstraintsFromSetRestricted_To_Companies_Reference($restricted_To_Companies_Reference))) {
            throw new \InvalidArgumentException($restricted_To_Companies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_To_Companies_Reference = $restricted_To_Companies_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_To_Companies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Worktag_Split_Template_Criteria_DataType
     */
    public function addToRestricted_To_Companies_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_To_Companies_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_To_Companies_Reference[] = $item;
        return $this;
    }
}
