<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Withholding_Tax_Certificate_NumberType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information Relating to Gapless Tax Certificate Numbers
 * @subpackage Structs
 */
class Withholding_Tax_Certificate_NumberType extends AbstractStructBase
{
    /**
     * The Tax_Certificate_Number
     * Meta information extracted from the WSDL
     * - documentation: Withholding Tax Certificate Number
     * - minOccurs: 0
     * @var string
     */
    public $Tax_Certificate_Number;
    /**
     * The Tax_Authority_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Authority for Withholding Tax Certificate Number
     * - minOccurs: 0
     * @var \StructType\Tax_AuthorityObjectType
     */
    public $Tax_Authority_Reference;
    /**
     * The Tax_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Category for Withholding Tax Certificate Number
     * - minOccurs: 0
     * @var \StructType\Tax_CategoryObjectType
     */
    public $Tax_Category_Reference;
    /**
     * The Last_Updated_Date
     * Meta information extracted from the WSDL
     * - documentation: Last Updated Date for Tax Certificate Number
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated_Date;
    /**
     * Constructor method for Withholding_Tax_Certificate_NumberType
     * @uses Withholding_Tax_Certificate_NumberType::setTax_Certificate_Number()
     * @uses Withholding_Tax_Certificate_NumberType::setTax_Authority_Reference()
     * @uses Withholding_Tax_Certificate_NumberType::setTax_Category_Reference()
     * @uses Withholding_Tax_Certificate_NumberType::setLast_Updated_Date()
     * @param string $tax_Certificate_Number
     * @param \StructType\Tax_AuthorityObjectType $tax_Authority_Reference
     * @param \StructType\Tax_CategoryObjectType $tax_Category_Reference
     * @param string $last_Updated_Date
     */
    public function __construct($tax_Certificate_Number = null, \StructType\Tax_AuthorityObjectType $tax_Authority_Reference = null, \StructType\Tax_CategoryObjectType $tax_Category_Reference = null, $last_Updated_Date = null)
    {
        $this
            ->setTax_Certificate_Number($tax_Certificate_Number)
            ->setTax_Authority_Reference($tax_Authority_Reference)
            ->setTax_Category_Reference($tax_Category_Reference)
            ->setLast_Updated_Date($last_Updated_Date);
    }
    /**
     * Get Tax_Certificate_Number value
     * @return string|null
     */
    public function getTax_Certificate_Number()
    {
        return $this->Tax_Certificate_Number;
    }
    /**
     * Set Tax_Certificate_Number value
     * @param string $tax_Certificate_Number
     * @return \StructType\Withholding_Tax_Certificate_NumberType
     */
    public function setTax_Certificate_Number($tax_Certificate_Number = null)
    {
        // validation for constraint: string
        if (!is_null($tax_Certificate_Number) && !is_string($tax_Certificate_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax_Certificate_Number, true), gettype($tax_Certificate_Number)), __LINE__);
        }
        $this->Tax_Certificate_Number = $tax_Certificate_Number;
        return $this;
    }
    /**
     * Get Tax_Authority_Reference value
     * @return \StructType\Tax_AuthorityObjectType|null
     */
    public function getTax_Authority_Reference()
    {
        return $this->Tax_Authority_Reference;
    }
    /**
     * Set Tax_Authority_Reference value
     * @param \StructType\Tax_AuthorityObjectType $tax_Authority_Reference
     * @return \StructType\Withholding_Tax_Certificate_NumberType
     */
    public function setTax_Authority_Reference(\StructType\Tax_AuthorityObjectType $tax_Authority_Reference = null)
    {
        $this->Tax_Authority_Reference = $tax_Authority_Reference;
        return $this;
    }
    /**
     * Get Tax_Category_Reference value
     * @return \StructType\Tax_CategoryObjectType|null
     */
    public function getTax_Category_Reference()
    {
        return $this->Tax_Category_Reference;
    }
    /**
     * Set Tax_Category_Reference value
     * @param \StructType\Tax_CategoryObjectType $tax_Category_Reference
     * @return \StructType\Withholding_Tax_Certificate_NumberType
     */
    public function setTax_Category_Reference(\StructType\Tax_CategoryObjectType $tax_Category_Reference = null)
    {
        $this->Tax_Category_Reference = $tax_Category_Reference;
        return $this;
    }
    /**
     * Get Last_Updated_Date value
     * @return string|null
     */
    public function getLast_Updated_Date()
    {
        return $this->Last_Updated_Date;
    }
    /**
     * Set Last_Updated_Date value
     * @param string $last_Updated_Date
     * @return \StructType\Withholding_Tax_Certificate_NumberType
     */
    public function setLast_Updated_Date($last_Updated_Date = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated_Date) && !is_string($last_Updated_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated_Date, true), gettype($last_Updated_Date)), __LINE__);
        }
        $this->Last_Updated_Date = $last_Updated_Date;
        return $this;
    }
}
