<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Asset_To_Different_Company_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing data needed to transfer Asset to another Company.
 * @subpackage Structs
 */
class Transfer_Asset_To_Different_Company_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Asset one would like to be transferred to another Company.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Transaction effective date of the asset transfer.
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Transfer_To_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company one would like the Asset transferred to.
     * @var \StructType\CompanyObjectType
     */
    public $Transfer_To_Company_Reference;
    /**
     * Constructor method for Transfer_Asset_To_Different_Company_DataType
     * @uses Transfer_Asset_To_Different_Company_DataType::setAsset_Reference()
     * @uses Transfer_Asset_To_Different_Company_DataType::setTransaction_Effective_Date()
     * @uses Transfer_Asset_To_Different_Company_DataType::setTransfer_To_Company_Reference()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $transaction_Effective_Date
     * @param \StructType\CompanyObjectType $transfer_To_Company_Reference
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $transaction_Effective_Date = null, \StructType\CompanyObjectType $transfer_To_Company_Reference = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setTransfer_To_Company_Reference($transfer_To_Company_Reference);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Transfer_Asset_To_Different_Company_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Transfer_Asset_To_Different_Company_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Transfer_To_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getTransfer_To_Company_Reference()
    {
        return $this->Transfer_To_Company_Reference;
    }
    /**
     * Set Transfer_To_Company_Reference value
     * @param \StructType\CompanyObjectType $transfer_To_Company_Reference
     * @return \StructType\Transfer_Asset_To_Different_Company_DataType
     */
    public function setTransfer_To_Company_Reference(\StructType\CompanyObjectType $transfer_To_Company_Reference = null)
    {
        $this->Transfer_To_Company_Reference = $transfer_To_Company_Reference;
        return $this;
    }
}
