<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_Hierarchy_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Spend Category Hierarchy request criteria
 * @subpackage Structs
 */
class Spend_Category_Hierarchy_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Spend_Category_Hierarchy_Name
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Hierarchy Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Category_Hierarchy_Name;
    /**
     * The Exclude_Hierarchy_Dependencies
     * Meta information extracted from the WSDL
     * - documentation: Exclude Hierarchy Dependencies
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Hierarchy_Dependencies;
    /**
     * Constructor method for Spend_Category_Hierarchy_Request_CriteriaType
     * @uses Spend_Category_Hierarchy_Request_CriteriaType::setSpend_Category_Hierarchy_Name()
     * @uses Spend_Category_Hierarchy_Request_CriteriaType::setExclude_Hierarchy_Dependencies()
     * @param string $spend_Category_Hierarchy_Name
     * @param bool $exclude_Hierarchy_Dependencies
     */
    public function __construct($spend_Category_Hierarchy_Name = null, $exclude_Hierarchy_Dependencies = null)
    {
        $this
            ->setSpend_Category_Hierarchy_Name($spend_Category_Hierarchy_Name)
            ->setExclude_Hierarchy_Dependencies($exclude_Hierarchy_Dependencies);
    }
    /**
     * Get Spend_Category_Hierarchy_Name value
     * @return string|null
     */
    public function getSpend_Category_Hierarchy_Name()
    {
        return $this->Spend_Category_Hierarchy_Name;
    }
    /**
     * Set Spend_Category_Hierarchy_Name value
     * @param string $spend_Category_Hierarchy_Name
     * @return \StructType\Spend_Category_Hierarchy_Request_CriteriaType
     */
    public function setSpend_Category_Hierarchy_Name($spend_Category_Hierarchy_Name = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Category_Hierarchy_Name) && !is_string($spend_Category_Hierarchy_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Category_Hierarchy_Name, true), gettype($spend_Category_Hierarchy_Name)), __LINE__);
        }
        $this->Spend_Category_Hierarchy_Name = $spend_Category_Hierarchy_Name;
        return $this;
    }
    /**
     * Get Exclude_Hierarchy_Dependencies value
     * @return bool|null
     */
    public function getExclude_Hierarchy_Dependencies()
    {
        return $this->Exclude_Hierarchy_Dependencies;
    }
    /**
     * Set Exclude_Hierarchy_Dependencies value
     * @param bool $exclude_Hierarchy_Dependencies
     * @return \StructType\Spend_Category_Hierarchy_Request_CriteriaType
     */
    public function setExclude_Hierarchy_Dependencies($exclude_Hierarchy_Dependencies = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Hierarchy_Dependencies) && !is_bool($exclude_Hierarchy_Dependencies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Hierarchy_Dependencies, true), gettype($exclude_Hierarchy_Dependencies)), __LINE__);
        }
        $this->Exclude_Hierarchy_Dependencies = $exclude_Hierarchy_Dependencies;
        return $this;
    }
}
