<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Resource Order Line Data
 * @subpackage Structs
 */
class Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Canceled
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Purchase Order Line is Canceled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Purchase_Order_Line_Canceled;
    /**
     * The Job_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Profile Reference
     * - minOccurs: 0
     * @var \StructType\Job_ProfileObjectType
     */
    public $Job_Profile_Reference;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Contract_Pay_Rate
     * Meta information extracted from the WSDL
     * - documentation: Contract Pay Rate | The contract pay rate for the contingent worker of the purchase order line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Contract_Pay_Rate;
    /**
     * The Position_Time_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Position Time Type Reference
     * - minOccurs: 0
     * @var \StructType\Position_Time_TypeObjectType
     */
    public $Position_Time_Type_Reference;
    /**
     * The Scheduled_Hours
     * Meta information extracted from the WSDL
     * - documentation: Scheduled Hours | The scheduled work hours for the contingent worker of the purchase order line.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Scheduled_Hours;
    /**
     * The UNSPSC_Code
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code | Catalog Item UNSPSC code for Spend Category | UNSPSC code as provided by the Supplier or if missing, the start UNSPSC code on the Spend Category UNSPSC range.cXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/Classification@domain[UNSPSC]
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $UNSPSC_Code;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * Constructor method for
     * Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPurchase_Order_Line_Canceled()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setJob_Profile_Reference()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setStart_Date()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setEnd_Date()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setContract_Pay_Rate()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPosition_Time_Type_Reference()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setScheduled_Hours()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setUNSPSC_Code()
     * @uses Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setLine_Number()
     * @param bool $purchase_Order_Line_Canceled
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param float $contract_Pay_Rate
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @param float $scheduled_Hours
     * @param float $uNSPSC_Code
     * @param float $line_Number
     */
    public function __construct($purchase_Order_Line_Canceled = null, \StructType\Job_ProfileObjectType $job_Profile_Reference = null, $start_Date = null, $end_Date = null, $contract_Pay_Rate = null, \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null, $scheduled_Hours = null, $uNSPSC_Code = null, $line_Number = null)
    {
        $this
            ->setPurchase_Order_Line_Canceled($purchase_Order_Line_Canceled)
            ->setJob_Profile_Reference($job_Profile_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setContract_Pay_Rate($contract_Pay_Rate)
            ->setPosition_Time_Type_Reference($position_Time_Type_Reference)
            ->setScheduled_Hours($scheduled_Hours)
            ->setUNSPSC_Code($uNSPSC_Code)
            ->setLine_Number($line_Number);
    }
    /**
     * Get Purchase_Order_Line_Canceled value
     * @return bool|null
     */
    public function getPurchase_Order_Line_Canceled()
    {
        return $this->Purchase_Order_Line_Canceled;
    }
    /**
     * Set Purchase_Order_Line_Canceled value
     * @param bool $purchase_Order_Line_Canceled
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPurchase_Order_Line_Canceled($purchase_Order_Line_Canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchase_Order_Line_Canceled) && !is_bool($purchase_Order_Line_Canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchase_Order_Line_Canceled, true), gettype($purchase_Order_Line_Canceled)), __LINE__);
        }
        $this->Purchase_Order_Line_Canceled = $purchase_Order_Line_Canceled;
        return $this;
    }
    /**
     * Get Job_Profile_Reference value
     * @return \StructType\Job_ProfileObjectType|null
     */
    public function getJob_Profile_Reference()
    {
        return $this->Job_Profile_Reference;
    }
    /**
     * Set Job_Profile_Reference value
     * @param \StructType\Job_ProfileObjectType $job_Profile_Reference
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setJob_Profile_Reference(\StructType\Job_ProfileObjectType $job_Profile_Reference = null)
    {
        $this->Job_Profile_Reference = $job_Profile_Reference;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Contract_Pay_Rate value
     * @return float|null
     */
    public function getContract_Pay_Rate()
    {
        return $this->Contract_Pay_Rate;
    }
    /**
     * Set Contract_Pay_Rate value
     * @param float $contract_Pay_Rate
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setContract_Pay_Rate($contract_Pay_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($contract_Pay_Rate) && !(is_float($contract_Pay_Rate) || is_numeric($contract_Pay_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contract_Pay_Rate, true), gettype($contract_Pay_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($contract_Pay_Rate) && mb_strlen(mb_substr($contract_Pay_Rate, false !== mb_strpos($contract_Pay_Rate, '.') ? mb_strpos($contract_Pay_Rate, '.') + 1 : mb_strlen($contract_Pay_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($contract_Pay_Rate, true), mb_strlen(mb_substr($contract_Pay_Rate, mb_strpos($contract_Pay_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($contract_Pay_Rate) && $contract_Pay_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($contract_Pay_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($contract_Pay_Rate) && mb_strlen(preg_replace('/(\D)/', '', $contract_Pay_Rate)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($contract_Pay_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $contract_Pay_Rate))), __LINE__);
        }
        $this->Contract_Pay_Rate = $contract_Pay_Rate;
        return $this;
    }
    /**
     * Get Position_Time_Type_Reference value
     * @return \StructType\Position_Time_TypeObjectType|null
     */
    public function getPosition_Time_Type_Reference()
    {
        return $this->Position_Time_Type_Reference;
    }
    /**
     * Set Position_Time_Type_Reference value
     * @param \StructType\Position_Time_TypeObjectType $position_Time_Type_Reference
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPosition_Time_Type_Reference(\StructType\Position_Time_TypeObjectType $position_Time_Type_Reference = null)
    {
        $this->Position_Time_Type_Reference = $position_Time_Type_Reference;
        return $this;
    }
    /**
     * Get Scheduled_Hours value
     * @return float|null
     */
    public function getScheduled_Hours()
    {
        return $this->Scheduled_Hours;
    }
    /**
     * Set Scheduled_Hours value
     * @param float $scheduled_Hours
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setScheduled_Hours($scheduled_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($scheduled_Hours) && !(is_float($scheduled_Hours) || is_numeric($scheduled_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($scheduled_Hours, true), gettype($scheduled_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($scheduled_Hours) && mb_strlen(mb_substr($scheduled_Hours, false !== mb_strpos($scheduled_Hours, '.') ? mb_strpos($scheduled_Hours, '.') + 1 : mb_strlen($scheduled_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($scheduled_Hours, true), mb_strlen(mb_substr($scheduled_Hours, mb_strpos($scheduled_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($scheduled_Hours) && mb_strlen(preg_replace('/(\D)/', '', $scheduled_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($scheduled_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $scheduled_Hours))), __LINE__);
        }
        $this->Scheduled_Hours = $scheduled_Hours;
        return $this;
    }
    /**
     * Get UNSPSC_Code value
     * @return float|null
     */
    public function getUNSPSC_Code()
    {
        return $this->UNSPSC_Code;
    }
    /**
     * Set UNSPSC_Code value
     * @param float $uNSPSC_Code
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setUNSPSC_Code($uNSPSC_Code = null)
    {
        // validation for constraint: float
        if (!is_null($uNSPSC_Code) && !(is_float($uNSPSC_Code) || is_numeric($uNSPSC_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNSPSC_Code, true), gettype($uNSPSC_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($uNSPSC_Code) && mb_strlen(mb_substr($uNSPSC_Code, false !== mb_strpos($uNSPSC_Code, '.') ? mb_strpos($uNSPSC_Code, '.') + 1 : mb_strlen($uNSPSC_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($uNSPSC_Code, true), mb_strlen(mb_substr($uNSPSC_Code, mb_strpos($uNSPSC_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($uNSPSC_Code) && $uNSPSC_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($uNSPSC_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($uNSPSC_Code) && mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($uNSPSC_Code, true), mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code))), __LINE__);
        }
        $this->UNSPSC_Code = $uNSPSC_Code;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Resource_Order__Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
}
