<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Classification_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing supplier classification reference for update and all supplier classification data items.
 * @subpackage Structs
 */
class Put_Supplier_Classification_RequestType extends AbstractStructBase
{
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Add_Only;
    /**
     * The Supplier_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing supplier classification for update only purposes
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_ClassificationObjectType
     */
    public $Supplier_Classification_Reference;
    /**
     * The Supplier_Classification_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification Data
     * @var \StructType\Supplier_Classification_DataType
     */
    public $Supplier_Classification_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Classification_RequestType
     * @uses Put_Supplier_Classification_RequestType::setAdd_Only()
     * @uses Put_Supplier_Classification_RequestType::setSupplier_Classification_Reference()
     * @uses Put_Supplier_Classification_RequestType::setSupplier_Classification_Data()
     * @uses Put_Supplier_Classification_RequestType::setVersion()
     * @param bool $add_Only
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @param \StructType\Supplier_Classification_DataType $supplier_Classification_Data
     * @param string $version
     */
    public function __construct($add_Only = null, \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null, \StructType\Supplier_Classification_DataType $supplier_Classification_Data = null, $version = null)
    {
        $this
            ->setAdd_Only($add_Only)
            ->setSupplier_Classification_Reference($supplier_Classification_Reference)
            ->setSupplier_Classification_Data($supplier_Classification_Data)
            ->setVersion($version);
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Supplier_Classification_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get Supplier_Classification_Reference value
     * @return \StructType\Custom_Supplier_ClassificationObjectType|null
     */
    public function getSupplier_Classification_Reference()
    {
        return $this->Supplier_Classification_Reference;
    }
    /**
     * Set Supplier_Classification_Reference value
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @return \StructType\Put_Supplier_Classification_RequestType
     */
    public function setSupplier_Classification_Reference(\StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null)
    {
        $this->Supplier_Classification_Reference = $supplier_Classification_Reference;
        return $this;
    }
    /**
     * Get Supplier_Classification_Data value
     * @return \StructType\Supplier_Classification_DataType|null
     */
    public function getSupplier_Classification_Data()
    {
        return $this->Supplier_Classification_Data;
    }
    /**
     * Set Supplier_Classification_Data value
     * @param \StructType\Supplier_Classification_DataType $supplier_Classification_Data
     * @return \StructType\Put_Supplier_Classification_RequestType
     */
    public function setSupplier_Classification_Data(\StructType\Supplier_Classification_DataType $supplier_Classification_Data = null)
    {
        $this->Supplier_Classification_Data = $supplier_Classification_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Classification_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
