<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Expense_Rate_Table_Rule_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the top-level request element for all "Put" Expense Rate Table Rule operations.
 * @subpackage Structs
 */
class Put_Expense_Rate_Table_Rule_RequestType extends AbstractStructBase
{
    /**
     * The Expense_Rate_Table_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Rate Table Rule for update-only purposes.
     * - minOccurs: 0
     * @var \StructType\Condition_RuleObjectType
     */
    public $Expense_Rate_Table_Rule_Reference;
    /**
     * The Expense_Rate_Table_Rule_Data
     * @var \StructType\Expense_Rate_Table_Rule_DataType
     */
    public $Expense_Rate_Table_Rule_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Expense_Rate_Table_Rule_RequestType
     * @uses Put_Expense_Rate_Table_Rule_RequestType::setExpense_Rate_Table_Rule_Reference()
     * @uses Put_Expense_Rate_Table_Rule_RequestType::setExpense_Rate_Table_Rule_Data()
     * @uses Put_Expense_Rate_Table_Rule_RequestType::setAdd_Only()
     * @uses Put_Expense_Rate_Table_Rule_RequestType::setVersion()
     * @param \StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference
     * @param \StructType\Expense_Rate_Table_Rule_DataType $expense_Rate_Table_Rule_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference = null, \StructType\Expense_Rate_Table_Rule_DataType $expense_Rate_Table_Rule_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Rate_Table_Rule_Reference($expense_Rate_Table_Rule_Reference)
            ->setExpense_Rate_Table_Rule_Data($expense_Rate_Table_Rule_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Rate_Table_Rule_Reference value
     * @return \StructType\Condition_RuleObjectType|null
     */
    public function getExpense_Rate_Table_Rule_Reference()
    {
        return $this->Expense_Rate_Table_Rule_Reference;
    }
    /**
     * Set Expense_Rate_Table_Rule_Reference value
     * @param \StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference
     * @return \StructType\Put_Expense_Rate_Table_Rule_RequestType
     */
    public function setExpense_Rate_Table_Rule_Reference(\StructType\Condition_RuleObjectType $expense_Rate_Table_Rule_Reference = null)
    {
        $this->Expense_Rate_Table_Rule_Reference = $expense_Rate_Table_Rule_Reference;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Rule_Data value
     * @return \StructType\Expense_Rate_Table_Rule_DataType|null
     */
    public function getExpense_Rate_Table_Rule_Data()
    {
        return $this->Expense_Rate_Table_Rule_Data;
    }
    /**
     * Set Expense_Rate_Table_Rule_Data value
     * @param \StructType\Expense_Rate_Table_Rule_DataType $expense_Rate_Table_Rule_Data
     * @return \StructType\Put_Expense_Rate_Table_Rule_RequestType
     */
    public function setExpense_Rate_Table_Rule_Data(\StructType\Expense_Rate_Table_Rule_DataType $expense_Rate_Table_Rule_Data = null)
    {
        $this->Expense_Rate_Table_Rule_Data = $expense_Rate_Table_Rule_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Expense_Rate_Table_Rule_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Expense_Rate_Table_Rule_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
