<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Expense_Credit_Card_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Put Expense Credit Card Response Data
 * @subpackage Structs
 */
class Put_Expense_Credit_Card_ResponseType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Credit Card Reference
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Expense_Credit_Card_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Expense_Credit_Card_ResponseType
     * @uses Put_Expense_Credit_Card_ResponseType::setExpense_Credit_Card_Reference()
     * @uses Put_Expense_Credit_Card_ResponseType::setVersion()
     * @param \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference
     * @param string $version
     */
    public function __construct(\StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference = null, $version = null)
    {
        $this
            ->setExpense_Credit_Card_Reference($expense_Credit_Card_Reference)
            ->setVersion($version);
    }
    /**
     * Get Expense_Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getExpense_Credit_Card_Reference()
    {
        return $this->Expense_Credit_Card_Reference;
    }
    /**
     * Set Expense_Credit_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference
     * @return \StructType\Put_Expense_Credit_Card_ResponseType
     */
    public function setExpense_Credit_Card_Reference(\StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference = null)
    {
        $this->Expense_Credit_Card_Reference = $expense_Credit_Card_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Expense_Credit_Card_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
