<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Order_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Item Reference is not allowed if there is a Requisition Line Reference for a Web Item. This is because characteristics such as Supplier Item Identifier will be coming from the Web Item and not the Item Reference. | The Requisition
 * Line referenced is from a Requisition that is Closed or Pending Close. | Submit approved Requisition Line that is not fully sourced and business process events that are not in progress. | Inventory Replenishment is not a valid delivery type if either
 * the header or line company is enabled for Alternate Ledger Currency | Leave the Delivery Type field blank. You can't enter a Delivery Type for External Warehouse type purchase orders. | Remove lines with ad hoc noncatalog items. You can't enter ad
 * hoc noncatalog items on External Warehouse type purchase orders. | Enter only stocked items on External Warehouse type purchase orders. | Enter a catalog item associated to a purchase item. Workday doesn't support catalog items that aren't associated
 * to purchase items on consignment purchase orders. | Supplier Item Identifiers can be set or updated for lines with no items or having non-catalog items. Catalog Items also have Supplier Item Identifiers, but we cannot change the existing value using
 * this web service. For this web service, the value will be ignored (but will not fire an error) if there is a Web Item (punchout item) associated with the Requisition Line Reference; we will store the Supplier Item Identifier from the Web Item
 * instead. | Item is from a Supplier Contract that does not accept Manual Purchase Orders. | Quantity must be greater than zero and cannot be partial when the document line's spend category is Tracked (unless related to a supplier contract line). | Can
 * not have any combination of Project, Project Phase or Project Task worktags for the same line. | Only one worktag for each type is allowed for each document line. | Please specify an Item or a Spend Category. | Quantity cannot be negative | Element
 * containing Goods Purchase Order Line data. A Purchase Order may have multiple goods purchase order lines.
 * @subpackage Structs
 */
class Item_Order_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing purchase item. Specifying the purchase item will default values for the Item Description, Spend Category, Tax Applicability, Unit of Measure, and Unit Cost if these options are defined on the purchase item
     * itself.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Goods_Purchase_Order_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Goods_Purchase_Order_Line_ID;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company of the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Item Identifier for a Goods Order Line. If the Item Reference is for a Catalog Item or the Requisition Line Reference is for a Web Item, the entered value will be ignored and Supplier Item Identifier from that Item will
     * be used (even if it is blank)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Supplier_Part_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Part ID. This field is read-only and ignored on Submit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Part_ID;
    /**
     * The Supplier_Part_Auxiliary_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Part Auxiliary ID. This field is read-only and ignored on Submit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Part_Auxiliary_ID;
    /**
     * The UNSPSC_Code
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code. This field is read-only and ignored on Submit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UNSPSC_Code;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Text description of the purchase item. If an item is provided, the description will default from that item. If no item is provided (ad-hoc), the entered free-form text description will be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: An optional reference to an existing Supplier Contract Line in the Workday system. This is used to link the Item Order Line with a Supplier Contract Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Payment_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_Payment_StatusObjectType
     */
    public $Payment_Status_Reference;
    /**
     * The Invoice_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Status_Reference;
    /**
     * The Receiving_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receiving Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Receiving_Status_Reference;
    /**
     * The Shipping_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Shipping_Status_Reference;
    /**
     * The Tracking_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tracking Status for Purchase Order Line. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\PO_Acknowledgement_StatusObjectType
     */
    public $Tracking_Status_Reference;
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend Category for the Purchase Item.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Resource_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Applicability Reference is required is Tax Code is specified. | Reference to the Tax Applicability for the Purchase Item. If the item has Tax Code defined, then the Tax Applicability is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Code for the Purchase Item. The Tax Code is defaulted from the Purchase Order Data element if one is specified.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Options_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Options_Data;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String associated with the Item specified on the Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Unit Of Measure for the Purchase Item. The Unit Of Measure will be defaulted based on the Purchase Item if one is specified.
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Requested_as_No_Charge
     * Meta information extracted from the WSDL
     * - documentation: No Charge field on Purchase Order Goods Line. This is a read-only field which is ignored when you submit inbound web services.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Requested_as_No_Charge;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Lot_Serial_Information_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Lot_Serial_Information_DataType
     */
    public $Lot_Serial_Information_Data;
    /**
     * The Due_Date
     * Meta information extracted from the WSDL
     * - documentation: The anticipated date by which the Purchase Order Line should be fulfilled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date;
    /**
     * The Delivery_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Delivery Type for the Purchase Items with Inventory Spend Category
     * - minOccurs: 0
     * @var \StructType\Delivery_TypeObjectType
     */
    public $Delivery_Type_Reference;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Prepaid flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Retention
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: The requested delivery date from the related requisition line for the current purchase order or purchase order change order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a purchase order line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Purchase Order Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains a reference instance or a Address Reference ID for an existing address
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Global_Location_Number
     * Meta information extracted from the WSDL
     * - documentation: Global Location Number (GLN) for Ship-to Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Global_Location_Number;
    /**
     * The Ship_To_Location_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Location Identifier for Ship-to Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Location_Identifier;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ship-to contact worker associated to the line item.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Deliver_To_Location_GLN
     * Meta information extracted from the WSDL
     * - documentation: Global Location Number (GLN) for Deliver-To Location
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliver_To_Location_GLN;
    /**
     * The Deliver_To_Location_Location_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Location Identifier for Deliver-to Location
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliver_To_Location_Location_Identifier;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: This field is only enabled for Companies and Tenants which are Opted-In to Consolidate Requisition Lines by Supplier regardless of Supplier Contract.Use this field to assign a specific Supplier Contract to this Spend Line.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Requisition_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Requisition Line linked to the Purchase Order Line.
     * - minOccurs: 0
     * @var \StructType\Requisition_LineObjectType
     */
    public $Requisition_Line_Reference;
    /**
     * The Storage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing location for the item.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Storage_Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worktags provided are not valid for this transaction | Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for
     * each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Goods_Purchase_Order_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Goods_Purchase_Order_Line_Split_Data;
    /**
     * The Alternate_Item_Identifiers_Data
     * Meta information extracted from the WSDL
     * - documentation: Alternate Item Identifiers for Procurement Item on Item Order Line.This field is read-only, and will be ignored on Submit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Item_Identifiers_DataType[]
     */
    public $Alternate_Item_Identifiers_Data;
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item tags for Procurement Item on Item Order Line.This field is read-only, and will be ignored on Submit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType[]
     */
    public $Item_Tag_Reference;
    /**
     * The Close_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The status of a closed purchase order line. This field is read-only and ignored when you submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Close_Status_Reference;
    /**
     * The Close_Status_Information
     * Meta information extracted from the WSDL
     * - documentation: Additional information on the status of the closed purchase order (PO) line. Includes information such as the date the PO line was closed, who closed the line, and the reason it was closed. This field is read-only and ignored when
     * you submit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Close_Status_InformationType[]
     */
    public $Close_Status_Information;
    /**
     * Constructor method for Item_Order_Line_Replacement_DataType
     * @uses Item_Order_Line_Replacement_DataType::setItem_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setGoods_Purchase_Order_Line_ID()
     * @uses Item_Order_Line_Replacement_DataType::setLine_Number()
     * @uses Item_Order_Line_Replacement_DataType::setLine_Company_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setSupplier_Item_Identifier()
     * @uses Item_Order_Line_Replacement_DataType::setSupplier_Part_ID()
     * @uses Item_Order_Line_Replacement_DataType::setSupplier_Part_Auxiliary_ID()
     * @uses Item_Order_Line_Replacement_DataType::setUNSPSC_Code()
     * @uses Item_Order_Line_Replacement_DataType::setItem_Description()
     * @uses Item_Order_Line_Replacement_DataType::setSupplier_Contract_Line_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setCommodity_Code_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setPayment_Status_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setInvoice_Status_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setReceiving_Status_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setShipping_Status_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setTracking_Status_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setResource_Category_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setTax_Applicability_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setTax_Code_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setTax_Rate_Options_Data()
     * @uses Item_Order_Line_Replacement_DataType::setPackaging_String()
     * @uses Item_Order_Line_Replacement_DataType::setQuantity()
     * @uses Item_Order_Line_Replacement_DataType::setUnit_of_Measure_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setUnit_Cost()
     * @uses Item_Order_Line_Replacement_DataType::setRequested_as_No_Charge()
     * @uses Item_Order_Line_Replacement_DataType::setExtended_Amount()
     * @uses Item_Order_Line_Replacement_DataType::setLot_Serial_Information_Data()
     * @uses Item_Order_Line_Replacement_DataType::setDue_Date()
     * @uses Item_Order_Line_Replacement_DataType::setDelivery_Type_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setPrepaid()
     * @uses Item_Order_Line_Replacement_DataType::setRetention()
     * @uses Item_Order_Line_Replacement_DataType::setRequested_Delivery_Date()
     * @uses Item_Order_Line_Replacement_DataType::setBudget_Date()
     * @uses Item_Order_Line_Replacement_DataType::setMemo()
     * @uses Item_Order_Line_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setShip_To_Global_Location_Number()
     * @uses Item_Order_Line_Replacement_DataType::setShip_To_Location_Identifier()
     * @uses Item_Order_Line_Replacement_DataType::setShip_To_Contact_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setDeliver_To_Location_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setDeliver_To_Location_GLN()
     * @uses Item_Order_Line_Replacement_DataType::setDeliver_To_Location_Location_Identifier()
     * @uses Item_Order_Line_Replacement_DataType::setSupplier_Contract_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setRequisition_Line_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setStorage_Location_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setWorktags_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setGoods_Purchase_Order_Line_Split_Data()
     * @uses Item_Order_Line_Replacement_DataType::setAlternate_Item_Identifiers_Data()
     * @uses Item_Order_Line_Replacement_DataType::setItem_Tag_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setClose_Status_Reference()
     * @uses Item_Order_Line_Replacement_DataType::setClose_Status_Information()
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $goods_Purchase_Order_Line_ID
     * @param float $line_Number
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param string $supplier_Item_Identifier
     * @param string $supplier_Part_ID
     * @param string $supplier_Part_Auxiliary_ID
     * @param string $uNSPSC_Code
     * @param string $item_Description
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @param \StructType\Document_StatusObjectType $shipping_Status_Reference
     * @param \StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @param string $packaging_String
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param bool $requested_as_No_Charge
     * @param float $extended_Amount
     * @param \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data
     * @param string $due_Date
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @param bool $prepaid
     * @param bool $retention
     * @param string $requested_Delivery_Date
     * @param string $budget_Date
     * @param string $memo
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param string $ship_To_Global_Location_Number
     * @param string $ship_To_Location_Identifier
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $deliver_To_Location_GLN
     * @param string $deliver_To_Location_Location_Identifier
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Requisition_LineObjectType $requisition_Line_Reference
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $goods_Purchase_Order_Line_Split_Data
     * @param \StructType\Alternate_Item_Identifiers_DataType[] $alternate_Item_Identifiers_Data
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @param \StructType\Document_StatusObjectType $close_Status_Reference
     * @param \StructType\Close_Status_InformationType[] $close_Status_Information
     */
    public function __construct(\StructType\Procurement_ItemObjectType $item_Reference = null, $goods_Purchase_Order_Line_ID = null, $line_Number = null, \StructType\CompanyObjectType $line_Company_Reference = null, $supplier_Item_Identifier = null, $supplier_Part_ID = null, $supplier_Part_Auxiliary_ID = null, $uNSPSC_Code = null, $item_Description = null, \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, \StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null, \StructType\Document_StatusObjectType $invoice_Status_Reference = null, \StructType\Document_StatusObjectType $receiving_Status_Reference = null, \StructType\Document_StatusObjectType $shipping_Status_Reference = null, \StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference = null, \StructType\Spend_CategoryObjectType $resource_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null, $packaging_String = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $requested_as_No_Charge = null, $extended_Amount = null, \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data = null, $due_Date = null, \StructType\Delivery_TypeObjectType $delivery_Type_Reference = null, $prepaid = null, $retention = null, $requested_Delivery_Date = null, $budget_Date = null, $memo = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, $ship_To_Global_Location_Number = null, $ship_To_Location_Identifier = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $deliver_To_Location_GLN = null, $deliver_To_Location_Location_Identifier = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\Requisition_LineObjectType $requisition_Line_Reference = null, \StructType\LocationObjectType $storage_Location_Reference = null, array $worktags_Reference = array(), array $goods_Purchase_Order_Line_Split_Data = array(), array $alternate_Item_Identifiers_Data = array(), array $item_Tag_Reference = array(), \StructType\Document_StatusObjectType $close_Status_Reference = null, array $close_Status_Information = array())
    {
        $this
            ->setItem_Reference($item_Reference)
            ->setGoods_Purchase_Order_Line_ID($goods_Purchase_Order_Line_ID)
            ->setLine_Number($line_Number)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setSupplier_Part_ID($supplier_Part_ID)
            ->setSupplier_Part_Auxiliary_ID($supplier_Part_Auxiliary_ID)
            ->setUNSPSC_Code($uNSPSC_Code)
            ->setItem_Description($item_Description)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setPayment_Status_Reference($payment_Status_Reference)
            ->setInvoice_Status_Reference($invoice_Status_Reference)
            ->setReceiving_Status_Reference($receiving_Status_Reference)
            ->setShipping_Status_Reference($shipping_Status_Reference)
            ->setTracking_Status_Reference($tracking_Status_Reference)
            ->setResource_Category_Reference($resource_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Options_Data($tax_Rate_Options_Data)
            ->setPackaging_String($packaging_String)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setRequested_as_No_Charge($requested_as_No_Charge)
            ->setExtended_Amount($extended_Amount)
            ->setLot_Serial_Information_Data($lot_Serial_Information_Data)
            ->setDue_Date($due_Date)
            ->setDelivery_Type_Reference($delivery_Type_Reference)
            ->setPrepaid($prepaid)
            ->setRetention($retention)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setBudget_Date($budget_Date)
            ->setMemo($memo)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Global_Location_Number($ship_To_Global_Location_Number)
            ->setShip_To_Location_Identifier($ship_To_Location_Identifier)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setDeliver_To_Location_GLN($deliver_To_Location_GLN)
            ->setDeliver_To_Location_Location_Identifier($deliver_To_Location_Location_Identifier)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setRequisition_Line_Reference($requisition_Line_Reference)
            ->setStorage_Location_Reference($storage_Location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setGoods_Purchase_Order_Line_Split_Data($goods_Purchase_Order_Line_Split_Data)
            ->setAlternate_Item_Identifiers_Data($alternate_Item_Identifiers_Data)
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setClose_Status_Reference($close_Status_Reference)
            ->setClose_Status_Information($close_Status_Information);
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Goods_Purchase_Order_Line_ID value
     * @return string|null
     */
    public function getGoods_Purchase_Order_Line_ID()
    {
        return $this->Goods_Purchase_Order_Line_ID;
    }
    /**
     * Set Goods_Purchase_Order_Line_ID value
     * @param string $goods_Purchase_Order_Line_ID
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setGoods_Purchase_Order_Line_ID($goods_Purchase_Order_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($goods_Purchase_Order_Line_ID) && !is_string($goods_Purchase_Order_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goods_Purchase_Order_Line_ID, true), gettype($goods_Purchase_Order_Line_ID)), __LINE__);
        }
        $this->Goods_Purchase_Order_Line_ID = $goods_Purchase_Order_Line_ID;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Supplier_Part_ID value
     * @return string|null
     */
    public function getSupplier_Part_ID()
    {
        return $this->Supplier_Part_ID;
    }
    /**
     * Set Supplier_Part_ID value
     * @param string $supplier_Part_ID
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setSupplier_Part_ID($supplier_Part_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Part_ID) && !is_string($supplier_Part_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Part_ID, true), gettype($supplier_Part_ID)), __LINE__);
        }
        $this->Supplier_Part_ID = $supplier_Part_ID;
        return $this;
    }
    /**
     * Get Supplier_Part_Auxiliary_ID value
     * @return string|null
     */
    public function getSupplier_Part_Auxiliary_ID()
    {
        return $this->Supplier_Part_Auxiliary_ID;
    }
    /**
     * Set Supplier_Part_Auxiliary_ID value
     * @param string $supplier_Part_Auxiliary_ID
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setSupplier_Part_Auxiliary_ID($supplier_Part_Auxiliary_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Part_Auxiliary_ID) && !is_string($supplier_Part_Auxiliary_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Part_Auxiliary_ID, true), gettype($supplier_Part_Auxiliary_ID)), __LINE__);
        }
        $this->Supplier_Part_Auxiliary_ID = $supplier_Part_Auxiliary_ID;
        return $this;
    }
    /**
     * Get UNSPSC_Code value
     * @return string|null
     */
    public function getUNSPSC_Code()
    {
        return $this->UNSPSC_Code;
    }
    /**
     * Set UNSPSC_Code value
     * @param string $uNSPSC_Code
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setUNSPSC_Code($uNSPSC_Code = null)
    {
        // validation for constraint: string
        if (!is_null($uNSPSC_Code) && !is_string($uNSPSC_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uNSPSC_Code, true), gettype($uNSPSC_Code)), __LINE__);
        }
        $this->UNSPSC_Code = $uNSPSC_Code;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Payment_Status_Reference value
     * @return \StructType\Document_Payment_StatusObjectType|null
     */
    public function getPayment_Status_Reference()
    {
        return $this->Payment_Status_Reference;
    }
    /**
     * Set Payment_Status_Reference value
     * @param \StructType\Document_Payment_StatusObjectType $payment_Status_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setPayment_Status_Reference(\StructType\Document_Payment_StatusObjectType $payment_Status_Reference = null)
    {
        $this->Payment_Status_Reference = $payment_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Status_Reference()
    {
        return $this->Invoice_Status_Reference;
    }
    /**
     * Set Invoice_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Status_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setInvoice_Status_Reference(\StructType\Document_StatusObjectType $invoice_Status_Reference = null)
    {
        $this->Invoice_Status_Reference = $invoice_Status_Reference;
        return $this;
    }
    /**
     * Get Receiving_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getReceiving_Status_Reference()
    {
        return $this->Receiving_Status_Reference;
    }
    /**
     * Set Receiving_Status_Reference value
     * @param \StructType\Document_StatusObjectType $receiving_Status_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setReceiving_Status_Reference(\StructType\Document_StatusObjectType $receiving_Status_Reference = null)
    {
        $this->Receiving_Status_Reference = $receiving_Status_Reference;
        return $this;
    }
    /**
     * Get Shipping_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getShipping_Status_Reference()
    {
        return $this->Shipping_Status_Reference;
    }
    /**
     * Set Shipping_Status_Reference value
     * @param \StructType\Document_StatusObjectType $shipping_Status_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setShipping_Status_Reference(\StructType\Document_StatusObjectType $shipping_Status_Reference = null)
    {
        $this->Shipping_Status_Reference = $shipping_Status_Reference;
        return $this;
    }
    /**
     * Get Tracking_Status_Reference value
     * @return \StructType\PO_Acknowledgement_StatusObjectType|null
     */
    public function getTracking_Status_Reference()
    {
        return $this->Tracking_Status_Reference;
    }
    /**
     * Set Tracking_Status_Reference value
     * @param \StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setTracking_Status_Reference(\StructType\PO_Acknowledgement_StatusObjectType $tracking_Status_Reference = null)
    {
        $this->Tracking_Status_Reference = $tracking_Status_Reference;
        return $this;
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * Set Resource_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $resource_Category_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setResource_Category_Reference(\StructType\Spend_CategoryObjectType $resource_Category_Reference = null)
    {
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Options_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Options_Data()
    {
        return $this->Tax_Rate_Options_Data;
    }
    /**
     * Set Tax_Rate_Options_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setTax_Rate_Options_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Options_Data = null)
    {
        $this->Tax_Rate_Options_Data = $tax_Rate_Options_Data;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Requested_as_No_Charge value
     * @return bool|null
     */
    public function getRequested_as_No_Charge()
    {
        return $this->Requested_as_No_Charge;
    }
    /**
     * Set Requested_as_No_Charge value
     * @param bool $requested_as_No_Charge
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setRequested_as_No_Charge($requested_as_No_Charge = null)
    {
        // validation for constraint: boolean
        if (!is_null($requested_as_No_Charge) && !is_bool($requested_as_No_Charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requested_as_No_Charge, true), gettype($requested_as_No_Charge)), __LINE__);
        }
        $this->Requested_as_No_Charge = $requested_as_No_Charge;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Lot_Serial_Information_Data value
     * @return \StructType\Lot_Serial_Information_DataType|null
     */
    public function getLot_Serial_Information_Data()
    {
        return $this->Lot_Serial_Information_Data;
    }
    /**
     * Set Lot_Serial_Information_Data value
     * @param \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setLot_Serial_Information_Data(\StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data = null)
    {
        $this->Lot_Serial_Information_Data = $lot_Serial_Information_Data;
        return $this;
    }
    /**
     * Get Due_Date value
     * @return string|null
     */
    public function getDue_Date()
    {
        return $this->Due_Date;
    }
    /**
     * Set Due_Date value
     * @param string $due_Date
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setDue_Date($due_Date = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date) && !is_string($due_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date, true), gettype($due_Date)), __LINE__);
        }
        $this->Due_Date = $due_Date;
        return $this;
    }
    /**
     * Get Delivery_Type_Reference value
     * @return \StructType\Delivery_TypeObjectType|null
     */
    public function getDelivery_Type_Reference()
    {
        return $this->Delivery_Type_Reference;
    }
    /**
     * Set Delivery_Type_Reference value
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setDelivery_Type_Reference(\StructType\Delivery_TypeObjectType $delivery_Type_Reference = null)
    {
        $this->Delivery_Type_Reference = $delivery_Type_Reference;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Retention value
     * @return bool|null
     */
    public function getRetention()
    {
        return $this->Retention;
    }
    /**
     * Set Retention value
     * @param bool $retention
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setRetention($retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention) && !is_bool($retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention, true), gettype($retention)), __LINE__);
        }
        $this->Retention = $retention;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Global_Location_Number value
     * @return string|null
     */
    public function getShip_To_Global_Location_Number()
    {
        return $this->Ship_To_Global_Location_Number;
    }
    /**
     * Set Ship_To_Global_Location_Number value
     * @param string $ship_To_Global_Location_Number
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setShip_To_Global_Location_Number($ship_To_Global_Location_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Global_Location_Number) && !is_string($ship_To_Global_Location_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Global_Location_Number, true), gettype($ship_To_Global_Location_Number)), __LINE__);
        }
        $this->Ship_To_Global_Location_Number = $ship_To_Global_Location_Number;
        return $this;
    }
    /**
     * Get Ship_To_Location_Identifier value
     * @return string|null
     */
    public function getShip_To_Location_Identifier()
    {
        return $this->Ship_To_Location_Identifier;
    }
    /**
     * Set Ship_To_Location_Identifier value
     * @param string $ship_To_Location_Identifier
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setShip_To_Location_Identifier($ship_To_Location_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Location_Identifier) && !is_string($ship_To_Location_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Location_Identifier, true), gettype($ship_To_Location_Identifier)), __LINE__);
        }
        $this->Ship_To_Location_Identifier = $ship_To_Location_Identifier;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_GLN value
     * @return string|null
     */
    public function getDeliver_To_Location_GLN()
    {
        return $this->Deliver_To_Location_GLN;
    }
    /**
     * Set Deliver_To_Location_GLN value
     * @param string $deliver_To_Location_GLN
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setDeliver_To_Location_GLN($deliver_To_Location_GLN = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_To_Location_GLN) && !is_string($deliver_To_Location_GLN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_To_Location_GLN, true), gettype($deliver_To_Location_GLN)), __LINE__);
        }
        $this->Deliver_To_Location_GLN = $deliver_To_Location_GLN;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Location_Identifier value
     * @return string|null
     */
    public function getDeliver_To_Location_Location_Identifier()
    {
        return $this->Deliver_To_Location_Location_Identifier;
    }
    /**
     * Set Deliver_To_Location_Location_Identifier value
     * @param string $deliver_To_Location_Location_Identifier
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setDeliver_To_Location_Location_Identifier($deliver_To_Location_Location_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_To_Location_Location_Identifier) && !is_string($deliver_To_Location_Location_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_To_Location_Location_Identifier, true), gettype($deliver_To_Location_Location_Identifier)), __LINE__);
        }
        $this->Deliver_To_Location_Location_Identifier = $deliver_To_Location_Location_Identifier;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Requisition_Line_Reference value
     * @return \StructType\Requisition_LineObjectType|null
     */
    public function getRequisition_Line_Reference()
    {
        return $this->Requisition_Line_Reference;
    }
    /**
     * Set Requisition_Line_Reference value
     * @param \StructType\Requisition_LineObjectType $requisition_Line_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setRequisition_Line_Reference(\StructType\Requisition_LineObjectType $requisition_Line_Reference = null)
    {
        $this->Requisition_Line_Reference = $requisition_Line_Reference;
        return $this;
    }
    /**
     * Get Storage_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getStorage_Location_Reference()
    {
        return $this->Storage_Location_Reference;
    }
    /**
     * Set Storage_Location_Reference value
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setStorage_Location_Reference(\StructType\LocationObjectType $storage_Location_Reference = null)
    {
        $this->Storage_Location_Reference = $storage_Location_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Order_Line_Replacement_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($item_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) ? get_class($item_Order_Line_Replacement_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($item_Order_Line_Replacement_DataTypeWorktags_ReferenceItem), var_export($item_Order_Line_Replacement_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Goods_Purchase_Order_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getGoods_Purchase_Order_Line_Split_Data()
    {
        return $this->Goods_Purchase_Order_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGoods_Purchase_Order_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoods_Purchase_Order_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoods_Purchase_Order_Line_Split_DataForArrayConstraintsFromSetGoods_Purchase_Order_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Order_Line_Replacement_DataTypeGoods_Purchase_Order_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$item_Order_Line_Replacement_DataTypeGoods_Purchase_Order_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($item_Order_Line_Replacement_DataTypeGoods_Purchase_Order_Line_Split_DataItem) ? get_class($item_Order_Line_Replacement_DataTypeGoods_Purchase_Order_Line_Split_DataItem) : sprintf('%s(%s)', gettype($item_Order_Line_Replacement_DataTypeGoods_Purchase_Order_Line_Split_DataItem), var_export($item_Order_Line_Replacement_DataTypeGoods_Purchase_Order_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Goods_Purchase_Order_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Goods_Purchase_Order_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $goods_Purchase_Order_Line_Split_Data
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setGoods_Purchase_Order_Line_Split_Data(array $goods_Purchase_Order_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($goods_Purchase_Order_Line_Split_DataArrayErrorMessage = self::validateGoods_Purchase_Order_Line_Split_DataForArrayConstraintsFromSetGoods_Purchase_Order_Line_Split_Data($goods_Purchase_Order_Line_Split_Data))) {
            throw new \InvalidArgumentException($goods_Purchase_Order_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Goods_Purchase_Order_Line_Split_Data = $goods_Purchase_Order_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Goods_Purchase_Order_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function addToGoods_Purchase_Order_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Goods_Purchase_Order_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Goods_Purchase_Order_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifiers_Data value
     * @return \StructType\Alternate_Item_Identifiers_DataType[]|null
     */
    public function getAlternate_Item_Identifiers_Data()
    {
        return $this->Alternate_Item_Identifiers_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifiers_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifiers_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_Identifiers_DataForArrayConstraintsFromSetAlternate_Item_Identifiers_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Order_Line_Replacement_DataTypeAlternate_Item_Identifiers_DataItem) {
            // validation for constraint: itemType
            if (!$item_Order_Line_Replacement_DataTypeAlternate_Item_Identifiers_DataItem instanceof \StructType\Alternate_Item_Identifiers_DataType) {
                $invalidValues[] = is_object($item_Order_Line_Replacement_DataTypeAlternate_Item_Identifiers_DataItem) ? get_class($item_Order_Line_Replacement_DataTypeAlternate_Item_Identifiers_DataItem) : sprintf('%s(%s)', gettype($item_Order_Line_Replacement_DataTypeAlternate_Item_Identifiers_DataItem), var_export($item_Order_Line_Replacement_DataTypeAlternate_Item_Identifiers_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifiers_Data property can only contain items of type \StructType\Alternate_Item_Identifiers_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifiers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifiers_DataType[] $alternate_Item_Identifiers_Data
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setAlternate_Item_Identifiers_Data(array $alternate_Item_Identifiers_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_Identifiers_DataArrayErrorMessage = self::validateAlternate_Item_Identifiers_DataForArrayConstraintsFromSetAlternate_Item_Identifiers_Data($alternate_Item_Identifiers_Data))) {
            throw new \InvalidArgumentException($alternate_Item_Identifiers_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifiers_Data = $alternate_Item_Identifiers_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifiers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifiers_DataType $item
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function addToAlternate_Item_Identifiers_Data(\StructType\Alternate_Item_Identifiers_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Item_Identifiers_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifiers_Data property can only contain items of type \StructType\Alternate_Item_Identifiers_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifiers_Data[] = $item;
        return $this;
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType[]|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Order_Line_Replacement_DataTypeItem_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Order_Line_Replacement_DataTypeItem_Tag_ReferenceItem instanceof \StructType\Item_TagObjectType) {
                $invalidValues[] = is_object($item_Order_Line_Replacement_DataTypeItem_Tag_ReferenceItem) ? get_class($item_Order_Line_Replacement_DataTypeItem_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($item_Order_Line_Replacement_DataTypeItem_Tag_ReferenceItem), var_export($item_Order_Line_Replacement_DataTypeItem_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setItem_Tag_Reference(array $item_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_ReferenceArrayErrorMessage = self::validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference($item_Tag_Reference))) {
            throw new \InvalidArgumentException($item_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType $item
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function addToItem_Tag_Reference(\StructType\Item_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Close_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getClose_Status_Reference()
    {
        return $this->Close_Status_Reference;
    }
    /**
     * Set Close_Status_Reference value
     * @param \StructType\Document_StatusObjectType $close_Status_Reference
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setClose_Status_Reference(\StructType\Document_StatusObjectType $close_Status_Reference = null)
    {
        $this->Close_Status_Reference = $close_Status_Reference;
        return $this;
    }
    /**
     * Get Close_Status_Information value
     * @return \StructType\Close_Status_InformationType[]|null
     */
    public function getClose_Status_Information()
    {
        return $this->Close_Status_Information;
    }
    /**
     * This method is responsible for validating the values passed to the setClose_Status_Information method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClose_Status_Information method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClose_Status_InformationForArrayConstraintsFromSetClose_Status_Information(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Order_Line_Replacement_DataTypeClose_Status_InformationItem) {
            // validation for constraint: itemType
            if (!$item_Order_Line_Replacement_DataTypeClose_Status_InformationItem instanceof \StructType\Close_Status_InformationType) {
                $invalidValues[] = is_object($item_Order_Line_Replacement_DataTypeClose_Status_InformationItem) ? get_class($item_Order_Line_Replacement_DataTypeClose_Status_InformationItem) : sprintf('%s(%s)', gettype($item_Order_Line_Replacement_DataTypeClose_Status_InformationItem), var_export($item_Order_Line_Replacement_DataTypeClose_Status_InformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Close_Status_Information property can only contain items of type \StructType\Close_Status_InformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Close_Status_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Close_Status_InformationType[] $close_Status_Information
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function setClose_Status_Information(array $close_Status_Information = array())
    {
        // validation for constraint: array
        if ('' !== ($close_Status_InformationArrayErrorMessage = self::validateClose_Status_InformationForArrayConstraintsFromSetClose_Status_Information($close_Status_Information))) {
            throw new \InvalidArgumentException($close_Status_InformationArrayErrorMessage, __LINE__);
        }
        $this->Close_Status_Information = $close_Status_Information;
        return $this;
    }
    /**
     * Add item to Close_Status_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Close_Status_InformationType $item
     * @return \StructType\Item_Order_Line_Replacement_DataType
     */
    public function addToClose_Status_Information(\StructType\Close_Status_InformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Close_Status_InformationType) {
            throw new \InvalidArgumentException(sprintf('The Close_Status_Information property can only contain items of type \StructType\Close_Status_InformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Close_Status_Information[] = $item;
        return $this;
    }
}
