<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Timesheet_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element encapsulates data for a Project Timesheet Line, which contains multiple days' worth of timesheet information.
 * @subpackage Structs
 */
class Project_Timesheet_Line_DataType extends AbstractStructBase
{
    /**
     * The Time_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Time Code for this line.
     * - minOccurs: 0
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Code_Reference;
    /**
     * The Activity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Activity for this line. Activity can be a Project or a Project Task.
     * - minOccurs: 0
     * @var \StructType\ActivityObjectType
     */
    public $Activity_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worktags provided are not valid for this transaction | Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for
     * each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Percent_Complete
     * Meta information extracted from the WSDL
     * - documentation: The percent complete for the project plan template. | The percent complete for the project template. | Decimal value for Proposed Percent Complete of the Project Task selected. This value can be set via the Timesheet under certain
     * condition and is then copied to the Project Task on Approval of the Timesheet. | The value for Percent Complete Proposed can only be set where the Task is not 100% already on the Project and that Task is directly assigned to the worker. | Proposed
     * Percent Complete Complete cannot be greater than 100%. Percent complete is in decimal format value can not be greater than 1.00. | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Complete;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: An optional memo for the Timesheet line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worksheet_Allocation_Percent
     * Meta information extracted from the WSDL
     * - documentation: Time allocation percent for a Project Worksheet Line. Indicates the percentage of time an employee spent on an activity for the specific time period. Applies to Project Worksheets only.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Worksheet_Allocation_Percent;
    /**
     * The Project_Timesheet_Day
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Timesheet_Day_DataType[]
     */
    public $Project_Timesheet_Day;
    /**
     * Constructor method for Project_Timesheet_Line_DataType
     * @uses Project_Timesheet_Line_DataType::setTime_Code_Reference()
     * @uses Project_Timesheet_Line_DataType::setActivity_Reference()
     * @uses Project_Timesheet_Line_DataType::setWorktag_Reference()
     * @uses Project_Timesheet_Line_DataType::setPercent_Complete()
     * @uses Project_Timesheet_Line_DataType::setMemo()
     * @uses Project_Timesheet_Line_DataType::setWorksheet_Allocation_Percent()
     * @uses Project_Timesheet_Line_DataType::setProject_Timesheet_Day()
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @param \StructType\ActivityObjectType $activity_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @param float $percent_Complete
     * @param string $memo
     * @param float $worksheet_Allocation_Percent
     * @param \StructType\Project_Timesheet_Day_DataType[] $project_Timesheet_Day
     */
    public function __construct(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null, \StructType\ActivityObjectType $activity_Reference = null, array $worktag_Reference = array(), $percent_Complete = null, $memo = null, $worksheet_Allocation_Percent = null, array $project_Timesheet_Day = array())
    {
        $this
            ->setTime_Code_Reference($time_Code_Reference)
            ->setActivity_Reference($activity_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setPercent_Complete($percent_Complete)
            ->setMemo($memo)
            ->setWorksheet_Allocation_Percent($worksheet_Allocation_Percent)
            ->setProject_Timesheet_Day($project_Timesheet_Day);
    }
    /**
     * Get Time_Code_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Code_Reference()
    {
        return $this->Time_Code_Reference;
    }
    /**
     * Set Time_Code_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setTime_Code_Reference(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null)
    {
        $this->Time_Code_Reference = $time_Code_Reference;
        return $this;
    }
    /**
     * Get Activity_Reference value
     * @return \StructType\ActivityObjectType|null
     */
    public function getActivity_Reference()
    {
        return $this->Activity_Reference;
    }
    /**
     * Set Activity_Reference value
     * @param \StructType\ActivityObjectType $activity_Reference
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setActivity_Reference(\StructType\ActivityObjectType $activity_Reference = null)
    {
        $this->Activity_Reference = $activity_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Timesheet_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Timesheet_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($project_Timesheet_Line_DataTypeWorktag_ReferenceItem) ? get_class($project_Timesheet_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($project_Timesheet_Line_DataTypeWorktag_ReferenceItem), var_export($project_Timesheet_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Percent_Complete value
     * @return float|null
     */
    public function getPercent_Complete()
    {
        return $this->Percent_Complete;
    }
    /**
     * Set Percent_Complete value
     * @param float $percent_Complete
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setPercent_Complete($percent_Complete = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Complete) && !(is_float($percent_Complete) || is_numeric($percent_Complete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Complete, true), gettype($percent_Complete)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Complete) && mb_strlen(mb_substr($percent_Complete, false !== mb_strpos($percent_Complete, '.') ? mb_strpos($percent_Complete, '.') + 1 : mb_strlen($percent_Complete))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Complete, true), mb_strlen(mb_substr($percent_Complete, mb_strpos($percent_Complete, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Complete) && $percent_Complete < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Complete, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Complete) && mb_strlen(preg_replace('/(\D)/', '', $percent_Complete)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Complete, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Complete))), __LINE__);
        }
        $this->Percent_Complete = $percent_Complete;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worksheet_Allocation_Percent value
     * @return float|null
     */
    public function getWorksheet_Allocation_Percent()
    {
        return $this->Worksheet_Allocation_Percent;
    }
    /**
     * Set Worksheet_Allocation_Percent value
     * @param float $worksheet_Allocation_Percent
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setWorksheet_Allocation_Percent($worksheet_Allocation_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($worksheet_Allocation_Percent) && !(is_float($worksheet_Allocation_Percent) || is_numeric($worksheet_Allocation_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($worksheet_Allocation_Percent, true), gettype($worksheet_Allocation_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($worksheet_Allocation_Percent) && mb_strlen(mb_substr($worksheet_Allocation_Percent, false !== mb_strpos($worksheet_Allocation_Percent, '.') ? mb_strpos($worksheet_Allocation_Percent, '.') + 1 : mb_strlen($worksheet_Allocation_Percent))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($worksheet_Allocation_Percent, true), mb_strlen(mb_substr($worksheet_Allocation_Percent, mb_strpos($worksheet_Allocation_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($worksheet_Allocation_Percent) && mb_strlen(preg_replace('/(\D)/', '', $worksheet_Allocation_Percent)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($worksheet_Allocation_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $worksheet_Allocation_Percent))), __LINE__);
        }
        $this->Worksheet_Allocation_Percent = $worksheet_Allocation_Percent;
        return $this;
    }
    /**
     * Get Project_Timesheet_Day value
     * @return \StructType\Project_Timesheet_Day_DataType[]|null
     */
    public function getProject_Timesheet_Day()
    {
        return $this->Project_Timesheet_Day;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Timesheet_Day method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Timesheet_Day method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Timesheet_DayForArrayConstraintsFromSetProject_Timesheet_Day(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Timesheet_Line_DataTypeProject_Timesheet_DayItem) {
            // validation for constraint: itemType
            if (!$project_Timesheet_Line_DataTypeProject_Timesheet_DayItem instanceof \StructType\Project_Timesheet_Day_DataType) {
                $invalidValues[] = is_object($project_Timesheet_Line_DataTypeProject_Timesheet_DayItem) ? get_class($project_Timesheet_Line_DataTypeProject_Timesheet_DayItem) : sprintf('%s(%s)', gettype($project_Timesheet_Line_DataTypeProject_Timesheet_DayItem), var_export($project_Timesheet_Line_DataTypeProject_Timesheet_DayItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Timesheet_Day property can only contain items of type \StructType\Project_Timesheet_Day_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Timesheet_Day value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Timesheet_Day_DataType[] $project_Timesheet_Day
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function setProject_Timesheet_Day(array $project_Timesheet_Day = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Timesheet_DayArrayErrorMessage = self::validateProject_Timesheet_DayForArrayConstraintsFromSetProject_Timesheet_Day($project_Timesheet_Day))) {
            throw new \InvalidArgumentException($project_Timesheet_DayArrayErrorMessage, __LINE__);
        }
        $this->Project_Timesheet_Day = $project_Timesheet_Day;
        return $this;
    }
    /**
     * Add item to Project_Timesheet_Day value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Timesheet_Day_DataType $item
     * @return \StructType\Project_Timesheet_Line_DataType
     */
    public function addToProject_Timesheet_Day(\StructType\Project_Timesheet_Day_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Timesheet_Day_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Timesheet_Day property can only contain items of type \StructType\Project_Timesheet_Day_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Timesheet_Day[] = $item;
        return $this;
    }
}
