<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Return_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Return Reference
 * @subpackage Structs
 */
class Submit_Return_ResponseType extends AbstractStructBase
{
    /**
     * The Return_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Submitted Return
     * - minOccurs: 0
     * @var \StructType\Return_to_SupplierObjectType
     */
    public $Return_Reference;
    /**
     * The Exceptions_Response_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Application_Instance_Related_Exceptions_DataType[]
     */
    public $Exceptions_Response_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Return_ResponseType
     * @uses Submit_Return_ResponseType::setReturn_Reference()
     * @uses Submit_Return_ResponseType::setExceptions_Response_Data()
     * @uses Submit_Return_ResponseType::setVersion()
     * @param \StructType\Return_to_SupplierObjectType $return_Reference
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $exceptions_Response_Data
     * @param string $version
     */
    public function __construct(\StructType\Return_to_SupplierObjectType $return_Reference = null, array $exceptions_Response_Data = array(), $version = null)
    {
        $this
            ->setReturn_Reference($return_Reference)
            ->setExceptions_Response_Data($exceptions_Response_Data)
            ->setVersion($version);
    }
    /**
     * Get Return_Reference value
     * @return \StructType\Return_to_SupplierObjectType|null
     */
    public function getReturn_Reference()
    {
        return $this->Return_Reference;
    }
    /**
     * Set Return_Reference value
     * @param \StructType\Return_to_SupplierObjectType $return_Reference
     * @return \StructType\Submit_Return_ResponseType
     */
    public function setReturn_Reference(\StructType\Return_to_SupplierObjectType $return_Reference = null)
    {
        $this->Return_Reference = $return_Reference;
        return $this;
    }
    /**
     * Get Exceptions_Response_Data value
     * @return \StructType\Application_Instance_Related_Exceptions_DataType[]|null
     */
    public function getExceptions_Response_Data()
    {
        return $this->Exceptions_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExceptions_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExceptions_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExceptions_Response_DataForArrayConstraintsFromSetExceptions_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Return_ResponseTypeExceptions_Response_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Return_ResponseTypeExceptions_Response_DataItem instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
                $invalidValues[] = is_object($submit_Return_ResponseTypeExceptions_Response_DataItem) ? get_class($submit_Return_ResponseTypeExceptions_Response_DataItem) : sprintf('%s(%s)', gettype($submit_Return_ResponseTypeExceptions_Response_DataItem), var_export($submit_Return_ResponseTypeExceptions_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Exceptions_Response_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Exceptions_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType[] $exceptions_Response_Data
     * @return \StructType\Submit_Return_ResponseType
     */
    public function setExceptions_Response_Data(array $exceptions_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($exceptions_Response_DataArrayErrorMessage = self::validateExceptions_Response_DataForArrayConstraintsFromSetExceptions_Response_Data($exceptions_Response_Data))) {
            throw new \InvalidArgumentException($exceptions_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->Exceptions_Response_Data = $exceptions_Response_Data;
        return $this;
    }
    /**
     * Add item to Exceptions_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Application_Instance_Related_Exceptions_DataType $item
     * @return \StructType\Submit_Return_ResponseType
     */
    public function addToExceptions_Response_Data(\StructType\Application_Instance_Related_Exceptions_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Application_Instance_Related_Exceptions_DataType) {
            throw new \InvalidArgumentException(sprintf('The Exceptions_Response_Data property can only contain items of type \StructType\Application_Instance_Related_Exceptions_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Exceptions_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Return_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
