<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Component_Asset_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any given asset id can be used only once in a composed asset. If more than one is required, adjust the quantity on the single component reference. | Represents a component (asset and quantity) to be used in composing the asset being
 * registered. Components selected must have a quantity available, must not be Expense and for Discrete Composite Lifecycles must be non-Depreciable. Components must have accounting assigned and must not be a part of another composite asset that has a
 * pending registration event.
 * @subpackage Structs
 */
class Component_Asset_WWS_DataType extends AbstractStructBase
{
    /**
     * The Component_Asset_ID
     * Meta information extracted from the WSDL
     * - documentation: You cannot select an Asset that has residual value for a non-discrete composite asset. | Composite Asset cannot be composed with other composite assets. | Component assets used to create a composite asset cannot have Accounting
     * Treatment of Expense unless they are for a composite asset with discrete component lifecycles. | Component assets used to create a composite asset must have accounting assigned. | Component assets used to create a composite asset cannot have an in
     * progress event. | Component assets used to create a composite asset must have a status of "Registered" or if discrete lifecycles option is selected, statuses of In Service, Issued and Out of Service are allowed. | Component assets used to create a
     * composite asset must be trackable. | Component assets used to create a composite asset must be tangible. | The company of each component asset must match the company of the asset being registered/composed. | Asset ID of asset used to compose the
     * asset being registered.
     * - maxOccurs: 1
     * @var string
     */
    public $Component_Asset_ID;
    /**
     * The Quantity_Selected
     * Meta information extracted from the WSDL
     * - documentation: Quantity of the referenced component asset to be used in the composition of the registered asset. | The quantity that is selected must be less than or equal to the available quantity of the asset. | A selected component asset should
     * have a selected quantity greater than 0. | The quantity selected must be equal to the total approved quantity and the total available quantity must be equal to the total approved quantity when Discrete Component Lifecycles is selected.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - totalDigits: 12
     * @var float
     */
    public $Quantity_Selected;
    /**
     * Constructor method for Component_Asset_WWS_DataType
     * @uses Component_Asset_WWS_DataType::setComponent_Asset_ID()
     * @uses Component_Asset_WWS_DataType::setQuantity_Selected()
     * @param string $component_Asset_ID
     * @param float $quantity_Selected
     */
    public function __construct($component_Asset_ID = null, $quantity_Selected = null)
    {
        $this
            ->setComponent_Asset_ID($component_Asset_ID)
            ->setQuantity_Selected($quantity_Selected);
    }
    /**
     * Get Component_Asset_ID value
     * @return string|null
     */
    public function getComponent_Asset_ID()
    {
        return $this->Component_Asset_ID;
    }
    /**
     * Set Component_Asset_ID value
     * @param string $component_Asset_ID
     * @return \StructType\Component_Asset_WWS_DataType
     */
    public function setComponent_Asset_ID($component_Asset_ID = null)
    {
        // validation for constraint: string
        if (!is_null($component_Asset_ID) && !is_string($component_Asset_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($component_Asset_ID, true), gettype($component_Asset_ID)), __LINE__);
        }
        $this->Component_Asset_ID = $component_Asset_ID;
        return $this;
    }
    /**
     * Get Quantity_Selected value
     * @return float|null
     */
    public function getQuantity_Selected()
    {
        return $this->Quantity_Selected;
    }
    /**
     * Set Quantity_Selected value
     * @param float $quantity_Selected
     * @return \StructType\Component_Asset_WWS_DataType
     */
    public function setQuantity_Selected($quantity_Selected = null)
    {
        // validation for constraint: float
        if (!is_null($quantity_Selected) && !(is_float($quantity_Selected) || is_numeric($quantity_Selected))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity_Selected, true), gettype($quantity_Selected)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($quantity_Selected) && mb_strlen(mb_substr($quantity_Selected, false !== mb_strpos($quantity_Selected, '.') ? mb_strpos($quantity_Selected, '.') + 1 : mb_strlen($quantity_Selected))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($quantity_Selected, true), mb_strlen(mb_substr($quantity_Selected, mb_strpos($quantity_Selected, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($quantity_Selected) && mb_strlen(preg_replace('/(\D)/', '', $quantity_Selected)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($quantity_Selected, true), mb_strlen(preg_replace('/(\D)/', '', $quantity_Selected))), __LINE__);
        }
        $this->Quantity_Selected = $quantity_Selected;
        return $this;
    }
}
