<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Removal_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for removal activity for this asset.
 * @subpackage Structs
 */
class Asset_Removal_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the asset removal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Removal_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the reason the asset was removed
     * - minOccurs: 0
     * @var \StructType\Asset_Removal_ReasonObjectType
     */
    public $Removal_Reason_Reference;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: Comments entered by the user when removing the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * Constructor method for Asset_Removal_WWS_DataType
     * @uses Asset_Removal_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Removal_WWS_DataType::setRemoval_Reason_Reference()
     * @uses Asset_Removal_WWS_DataType::setComments()
     * @param string $transaction_Effective_Date
     * @param \StructType\Asset_Removal_ReasonObjectType $removal_Reason_Reference
     * @param string $comments
     */
    public function __construct($transaction_Effective_Date = null, \StructType\Asset_Removal_ReasonObjectType $removal_Reason_Reference = null, $comments = null)
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setRemoval_Reason_Reference($removal_Reason_Reference)
            ->setComments($comments);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Removal_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Removal_Reason_Reference value
     * @return \StructType\Asset_Removal_ReasonObjectType|null
     */
    public function getRemoval_Reason_Reference()
    {
        return $this->Removal_Reason_Reference;
    }
    /**
     * Set Removal_Reason_Reference value
     * @param \StructType\Asset_Removal_ReasonObjectType $removal_Reason_Reference
     * @return \StructType\Asset_Removal_WWS_DataType
     */
    public function setRemoval_Reason_Reference(\StructType\Asset_Removal_ReasonObjectType $removal_Reason_Reference = null)
    {
        $this->Removal_Reason_Reference = $removal_Reason_Reference;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\Asset_Removal_WWS_DataType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
}
