<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Reinstatement_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about reinstatement activity for this asset.
 * @subpackage Structs
 */
class Asset_Reinstatement_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was reinstated (the transaction effective date of the reinstatement).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Disposal_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Type for the Disposal transaction that this Reinstatement is linked to.
     * - minOccurs: 0
     * @var \StructType\Asset_Disposal_TypeObjectType
     */
    public $Disposal_Type_Reference;
    /**
     * The Disposal_Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Fair Market Value for the Disposal transaction that this Reinstatement is linked to. | The fair market value of the asset at the time it was disposed. | The fair market value of the asset at the time of disposal. | The
     * disposal fair market value entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Disposal_Fair_Market_Value;
    /**
     * The Sale_Price
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Sale Price for the Disposal transaction that this Reinstatement is linked to. | The sale price, if the asset was sold as part of the disposal activity. | The sale price (if the Disposal Type was Sale) when the asset was
     * sold. | The sale price entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Sale_Price;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comments entered by the user when reinstating the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Worktags for the Disposal transaction that this Reinstatement is linked to.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * Constructor method for Asset_Reinstatement_WWS_DataType
     * @uses Asset_Reinstatement_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Reinstatement_WWS_DataType::setDisposal_Type_Reference()
     * @uses Asset_Reinstatement_WWS_DataType::setDisposal_Fair_Market_Value()
     * @uses Asset_Reinstatement_WWS_DataType::setSale_Price()
     * @uses Asset_Reinstatement_WWS_DataType::setComment()
     * @uses Asset_Reinstatement_WWS_DataType::setWorktag_Reference()
     * @param string $transaction_Effective_Date
     * @param \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference
     * @param float $disposal_Fair_Market_Value
     * @param float $sale_Price
     * @param string $comment
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     */
    public function __construct($transaction_Effective_Date = null, \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference = null, $disposal_Fair_Market_Value = null, $sale_Price = null, $comment = null, array $worktag_Reference = array())
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setDisposal_Type_Reference($disposal_Type_Reference)
            ->setDisposal_Fair_Market_Value($disposal_Fair_Market_Value)
            ->setSale_Price($sale_Price)
            ->setComment($comment)
            ->setWorktag_Reference($worktag_Reference);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Disposal_Type_Reference value
     * @return \StructType\Asset_Disposal_TypeObjectType|null
     */
    public function getDisposal_Type_Reference()
    {
        return $this->Disposal_Type_Reference;
    }
    /**
     * Set Disposal_Type_Reference value
     * @param \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function setDisposal_Type_Reference(\StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference = null)
    {
        $this->Disposal_Type_Reference = $disposal_Type_Reference;
        return $this;
    }
    /**
     * Get Disposal_Fair_Market_Value value
     * @return float|null
     */
    public function getDisposal_Fair_Market_Value()
    {
        return $this->Disposal_Fair_Market_Value;
    }
    /**
     * Set Disposal_Fair_Market_Value value
     * @param float $disposal_Fair_Market_Value
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function setDisposal_Fair_Market_Value($disposal_Fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Fair_Market_Value) && !(is_float($disposal_Fair_Market_Value) || is_numeric($disposal_Fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Fair_Market_Value, true), gettype($disposal_Fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($disposal_Fair_Market_Value) && mb_strlen(mb_substr($disposal_Fair_Market_Value, false !== mb_strpos($disposal_Fair_Market_Value, '.') ? mb_strpos($disposal_Fair_Market_Value, '.') + 1 : mb_strlen($disposal_Fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($disposal_Fair_Market_Value, true), mb_strlen(mb_substr($disposal_Fair_Market_Value, mb_strpos($disposal_Fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($disposal_Fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($disposal_Fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Fair_Market_Value))), __LINE__);
        }
        $this->Disposal_Fair_Market_Value = $disposal_Fair_Market_Value;
        return $this;
    }
    /**
     * Get Sale_Price value
     * @return float|null
     */
    public function getSale_Price()
    {
        return $this->Sale_Price;
    }
    /**
     * Set Sale_Price value
     * @param float $sale_Price
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function setSale_Price($sale_Price = null)
    {
        // validation for constraint: float
        if (!is_null($sale_Price) && !(is_float($sale_Price) || is_numeric($sale_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sale_Price, true), gettype($sale_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($sale_Price) && mb_strlen(mb_substr($sale_Price, false !== mb_strpos($sale_Price, '.') ? mb_strpos($sale_Price, '.') + 1 : mb_strlen($sale_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($sale_Price, true), mb_strlen(mb_substr($sale_Price, mb_strpos($sale_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($sale_Price) && mb_strlen(preg_replace('/(\D)/', '', $sale_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($sale_Price, true), mb_strlen(preg_replace('/(\D)/', '', $sale_Price))), __LINE__);
        }
        $this->Sale_Price = $sale_Price;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Reinstatement_WWS_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Reinstatement_WWS_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Reinstatement_WWS_DataTypeWorktag_ReferenceItem) ? get_class($asset_Reinstatement_WWS_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Reinstatement_WWS_DataTypeWorktag_ReferenceItem), var_export($asset_Reinstatement_WWS_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Reinstatement_WWS_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
}
