<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Requisition data. A Requisition may have multiple goods and deliverable Requisition lines. A Requisition also supports service lines v24.0 onwards.
 * @subpackage Structs
 */
class Requisition_DataType extends AbstractStructBase
{
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Requisition_Number
     * Meta information extracted from the WSDL
     * - documentation: Requisition Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requisition_Number;
    /**
     * The External_System_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference identifier of the external system that stores the requisition.
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $External_System_ID_Reference;
    /**
     * The External_Requisition_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: The requisition reference identifier stored in the external system.
     * - minOccurs: 0
     * @var string
     */
    public $External_Requisition_Reference_ID;
    /**
     * The Requisition_Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A Reference to the Document Status for this Requisition. This field is read-only, and will be ignored on a Put or Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Requisition_Document_Status_Reference;
    /**
     * The Requisition_Date
     * Meta information extracted from the WSDL
     * - documentation: Requisition Date
     * - maxOccurs: 1
     * @var string
     */
    public $Requisition_Date;
    /**
     * The Requisition_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Currency of the Requisition.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Requisition_Currency_Reference;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requisition Type of the Requisition
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType
     */
    public $Requisition_Type_Reference;
    /**
     * The Par_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Par Location of the Requisition
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Par_Location_Reference;
    /**
     * The Requisition_Sourcing_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requisition Sourcing Buyer for the Requisition
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requisition_Sourcing_Buyer_Reference;
    /**
     * The Requesting_Inventory_Site_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requesting Inventory Site Location for the Requisition.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Requesting_Inventory_Site_Reference;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - documentation: Origin for the Requisition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company. Sets the Company for the Requisition.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Deliver-To Location. Sets the Deliver-To Location for the Requisition. If Requisition Type is Par Replenishment, Par Location will be Deliver-To Location and this field will be ignored. If not specified on
     * the Requisition, Workday will default the workspace or the business site of the Requisition Worker as the Deliver-To Location.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Ship_To_Address_Data
     * Meta information extracted from the WSDL
     * - documentation: Ship To Address Data
     * - minOccurs: 0
     * @var \StructType\Ship_to_Address_for_RequisitionType
     */
    public $Ship_To_Address_Data;
    /**
     * The Reason_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Reason Code for a Closed or Canceled requisition. This field is read-only and ignored on Submit.
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Reason_Code_Reference;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: Comments for a Closed or Canceled Requisition. This field is read-only and ignored on Submit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requesting Worker for the Requisition
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Requesting_Entity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requesting Entity Reference for Requisition
     * - minOccurs: 0
     * @var \StructType\Requesting_Entity_AbstractObjectType
     */
    public $Requesting_Entity_Reference;
    /**
     * The Memo_to_Suppliers
     * Meta information extracted from the WSDL
     * - documentation: An optional Memo for the Requisition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo_to_Suppliers;
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Document Link for Requisition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * The Internal_Memo
     * Meta information extracted from the WSDL
     * - documentation: An optional internal memo for the Requisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Memo;
    /**
     * The Freight_Amount
     * Meta information extracted from the WSDL
     * - documentation: An optional addition of Freight Amount for the Requisition. | Freight charges incurred. | Freight Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Freight_Amount;
    /**
     * The Other_Charges
     * Meta information extracted from the WSDL
     * - documentation: If there are Other Charges, then there must be at least one line with a Spend Category that has Allocate Other Charges. | An optional addition of Other Charges for the Requisition. | Other Charges
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Other_Charges;
    /**
     * The Procurement_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Procurement Credit Card Reference provided is not valid for the Requisition. Please use an active procurement card valid for the Requestor or Processing Worker valid for the Company on the Requisition. | Reference to the
     * Procurement Card to be used in consideration for paying for the goods and services on the Requisition.
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Procurement_Credit_Card_Reference;
    /**
     * The High_Priority
     * Meta information extracted from the WSDL
     * - documentation: Is Requisition High Priority?
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $High_Priority;
    /**
     * The Consolidate_Requisition_on_PO
     * Meta information extracted from the WSDL
     * - documentation: Contains consolidation option of purchase orders for requisition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Consolidate_Requisition_on_PO;
    /**
     * The Exclude_Ship_To_Address_When_Consolidating_Requisition_Lines
     * Meta information extracted from the WSDL
     * - documentation: Dictates whether Requisition Lines will be not consolidated by Ship-To Address when creating a Purchase Order during the sourcing process. If set to true, the result will be a Purchase Order with different line Ship-To Addresses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Ship_To_Address_When_Consolidating_Requisition_Lines;
    /**
     * The Procedure_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Procedure Information associated with the Bill Only Requisition.
     * - minOccurs: 0
     * @var \StructType\Procedure_Information_DataType
     */
    public $Procedure_Information_Data;
    /**
     * The Item_Request_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Goods Requisition Line data. A Requisition may have multiple goods requisition lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Request_Line_DataType[]
     */
    public $Item_Request_Line_Data;
    /**
     * The Service_Request_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Service Requisition Line data. A Requisition may have multiple service requisition lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Service_Request_Line_DataType[]
     */
    public $Service_Request_Line_Data;
    /**
     * The Deliverables_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Project-Based Requisition Line data. A Requisition may have multiple Project-Based requisition lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Based_Requisition_Line_DataType[]
     */
    public $Deliverables_Line_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Refers to a requisition attachment. Multiple attachments are allowed.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Ad_Hoc_Address_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Ad Hoc Address information. Including address information will delete any existing address from the requisition and create a new address instance. If updating a requisition that currently contains an ad hoc
     * address, omitting the ad hoc address element will leave the existing ad hoc address unaffected, which is likely the desired behavior. Only include the ad hoc address information when updating the requisition if the desired affect is to replace the
     * current address with a new address instance.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Address_Information_DataType[]
     */
    public $Ad_Hoc_Address_Replacement_Data;
    /**
     * Constructor method for Requisition_DataType
     * @uses Requisition_DataType::setSubmit()
     * @uses Requisition_DataType::setRequisition_Number()
     * @uses Requisition_DataType::setExternal_System_ID_Reference()
     * @uses Requisition_DataType::setExternal_Requisition_Reference_ID()
     * @uses Requisition_DataType::setRequisition_Document_Status_Reference()
     * @uses Requisition_DataType::setRequisition_Date()
     * @uses Requisition_DataType::setRequisition_Currency_Reference()
     * @uses Requisition_DataType::setRequisition_Type_Reference()
     * @uses Requisition_DataType::setPar_Location_Reference()
     * @uses Requisition_DataType::setRequisition_Sourcing_Buyer_Reference()
     * @uses Requisition_DataType::setRequesting_Inventory_Site_Reference()
     * @uses Requisition_DataType::setOrigin()
     * @uses Requisition_DataType::setCompany_Reference()
     * @uses Requisition_DataType::setDeliver_To_Location_Reference()
     * @uses Requisition_DataType::setShip_To_Address_Data()
     * @uses Requisition_DataType::setReason_Code_Reference()
     * @uses Requisition_DataType::setComments()
     * @uses Requisition_DataType::setRequester_Reference()
     * @uses Requisition_DataType::setRequesting_Entity_Reference()
     * @uses Requisition_DataType::setMemo_to_Suppliers()
     * @uses Requisition_DataType::setDocument_Link()
     * @uses Requisition_DataType::setInternal_Memo()
     * @uses Requisition_DataType::setFreight_Amount()
     * @uses Requisition_DataType::setOther_Charges()
     * @uses Requisition_DataType::setProcurement_Credit_Card_Reference()
     * @uses Requisition_DataType::setHigh_Priority()
     * @uses Requisition_DataType::setConsolidate_Requisition_on_PO()
     * @uses Requisition_DataType::setExclude_Ship_To_Address_When_Consolidating_Requisition_Lines()
     * @uses Requisition_DataType::setProcedure_Information_Data()
     * @uses Requisition_DataType::setItem_Request_Line_Data()
     * @uses Requisition_DataType::setService_Request_Line_Data()
     * @uses Requisition_DataType::setDeliverables_Line_Data()
     * @uses Requisition_DataType::setAttachment_Data()
     * @uses Requisition_DataType::setAd_Hoc_Address_Replacement_Data()
     * @param bool $submit
     * @param string $requisition_Number
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference
     * @param string $external_Requisition_Reference_ID
     * @param \StructType\Document_StatusObjectType $requisition_Document_Status_Reference
     * @param string $requisition_Date
     * @param \StructType\CurrencyObjectType $requisition_Currency_Reference
     * @param \StructType\Requisition_TypeObjectType $requisition_Type_Reference
     * @param \StructType\LocationObjectType $par_Location_Reference
     * @param \StructType\WorkerObjectType $requisition_Sourcing_Buyer_Reference
     * @param \StructType\LocationObjectType $requesting_Inventory_Site_Reference
     * @param string $origin
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param \StructType\Ship_to_Address_for_RequisitionType $ship_To_Address_Data
     * @param \StructType\Reason_CodeObjectType $reason_Code_Reference
     * @param string $comments
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\Requesting_Entity_AbstractObjectType $requesting_Entity_Reference
     * @param string $memo_to_Suppliers
     * @param string $document_Link
     * @param string $internal_Memo
     * @param float $freight_Amount
     * @param float $other_Charges
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference
     * @param bool $high_Priority
     * @param bool $consolidate_Requisition_on_PO
     * @param bool $exclude_Ship_To_Address_When_Consolidating_Requisition_Lines
     * @param \StructType\Procedure_Information_DataType $procedure_Information_Data
     * @param \StructType\Item_Request_Line_DataType[] $item_Request_Line_Data
     * @param \StructType\Service_Request_Line_DataType[] $service_Request_Line_Data
     * @param \StructType\Project_Based_Requisition_Line_DataType[] $deliverables_Line_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[] $attachment_Data
     * @param \StructType\Address_Information_DataType[] $ad_Hoc_Address_Replacement_Data
     */
    public function __construct($submit = null, $requisition_Number = null, \StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference = null, $external_Requisition_Reference_ID = null, \StructType\Document_StatusObjectType $requisition_Document_Status_Reference = null, $requisition_Date = null, \StructType\CurrencyObjectType $requisition_Currency_Reference = null, \StructType\Requisition_TypeObjectType $requisition_Type_Reference = null, \StructType\LocationObjectType $par_Location_Reference = null, \StructType\WorkerObjectType $requisition_Sourcing_Buyer_Reference = null, \StructType\LocationObjectType $requesting_Inventory_Site_Reference = null, $origin = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, \StructType\Ship_to_Address_for_RequisitionType $ship_To_Address_Data = null, \StructType\Reason_CodeObjectType $reason_Code_Reference = null, $comments = null, \StructType\WorkerObjectType $requester_Reference = null, \StructType\Requesting_Entity_AbstractObjectType $requesting_Entity_Reference = null, $memo_to_Suppliers = null, $document_Link = null, $internal_Memo = null, $freight_Amount = null, $other_Charges = null, \StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference = null, $high_Priority = null, $consolidate_Requisition_on_PO = null, $exclude_Ship_To_Address_When_Consolidating_Requisition_Lines = null, \StructType\Procedure_Information_DataType $procedure_Information_Data = null, array $item_Request_Line_Data = array(), array $service_Request_Line_Data = array(), array $deliverables_Line_Data = array(), array $attachment_Data = array(), array $ad_Hoc_Address_Replacement_Data = array())
    {
        $this
            ->setSubmit($submit)
            ->setRequisition_Number($requisition_Number)
            ->setExternal_System_ID_Reference($external_System_ID_Reference)
            ->setExternal_Requisition_Reference_ID($external_Requisition_Reference_ID)
            ->setRequisition_Document_Status_Reference($requisition_Document_Status_Reference)
            ->setRequisition_Date($requisition_Date)
            ->setRequisition_Currency_Reference($requisition_Currency_Reference)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setPar_Location_Reference($par_Location_Reference)
            ->setRequisition_Sourcing_Buyer_Reference($requisition_Sourcing_Buyer_Reference)
            ->setRequesting_Inventory_Site_Reference($requesting_Inventory_Site_Reference)
            ->setOrigin($origin)
            ->setCompany_Reference($company_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setShip_To_Address_Data($ship_To_Address_Data)
            ->setReason_Code_Reference($reason_Code_Reference)
            ->setComments($comments)
            ->setRequester_Reference($requester_Reference)
            ->setRequesting_Entity_Reference($requesting_Entity_Reference)
            ->setMemo_to_Suppliers($memo_to_Suppliers)
            ->setDocument_Link($document_Link)
            ->setInternal_Memo($internal_Memo)
            ->setFreight_Amount($freight_Amount)
            ->setOther_Charges($other_Charges)
            ->setProcurement_Credit_Card_Reference($procurement_Credit_Card_Reference)
            ->setHigh_Priority($high_Priority)
            ->setConsolidate_Requisition_on_PO($consolidate_Requisition_on_PO)
            ->setExclude_Ship_To_Address_When_Consolidating_Requisition_Lines($exclude_Ship_To_Address_When_Consolidating_Requisition_Lines)
            ->setProcedure_Information_Data($procedure_Information_Data)
            ->setItem_Request_Line_Data($item_Request_Line_Data)
            ->setService_Request_Line_Data($service_Request_Line_Data)
            ->setDeliverables_Line_Data($deliverables_Line_Data)
            ->setAttachment_Data($attachment_Data)
            ->setAd_Hoc_Address_Replacement_Data($ad_Hoc_Address_Replacement_Data);
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Requisition_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Requisition_Number value
     * @return string|null
     */
    public function getRequisition_Number()
    {
        return $this->Requisition_Number;
    }
    /**
     * Set Requisition_Number value
     * @param string $requisition_Number
     * @return \StructType\Requisition_DataType
     */
    public function setRequisition_Number($requisition_Number = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_Number) && !is_string($requisition_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_Number, true), gettype($requisition_Number)), __LINE__);
        }
        $this->Requisition_Number = $requisition_Number;
        return $this;
    }
    /**
     * Get External_System_ID_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getExternal_System_ID_Reference()
    {
        return $this->External_System_ID_Reference;
    }
    /**
     * Set External_System_ID_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setExternal_System_ID_Reference(\StructType\External_Transaction_Source__All_ObjectType $external_System_ID_Reference = null)
    {
        $this->External_System_ID_Reference = $external_System_ID_Reference;
        return $this;
    }
    /**
     * Get External_Requisition_Reference_ID value
     * @return string|null
     */
    public function getExternal_Requisition_Reference_ID()
    {
        return $this->External_Requisition_Reference_ID;
    }
    /**
     * Set External_Requisition_Reference_ID value
     * @param string $external_Requisition_Reference_ID
     * @return \StructType\Requisition_DataType
     */
    public function setExternal_Requisition_Reference_ID($external_Requisition_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($external_Requisition_Reference_ID) && !is_string($external_Requisition_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Requisition_Reference_ID, true), gettype($external_Requisition_Reference_ID)), __LINE__);
        }
        $this->External_Requisition_Reference_ID = $external_Requisition_Reference_ID;
        return $this;
    }
    /**
     * Get Requisition_Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getRequisition_Document_Status_Reference()
    {
        return $this->Requisition_Document_Status_Reference;
    }
    /**
     * Set Requisition_Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $requisition_Document_Status_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequisition_Document_Status_Reference(\StructType\Document_StatusObjectType $requisition_Document_Status_Reference = null)
    {
        $this->Requisition_Document_Status_Reference = $requisition_Document_Status_Reference;
        return $this;
    }
    /**
     * Get Requisition_Date value
     * @return string|null
     */
    public function getRequisition_Date()
    {
        return $this->Requisition_Date;
    }
    /**
     * Set Requisition_Date value
     * @param string $requisition_Date
     * @return \StructType\Requisition_DataType
     */
    public function setRequisition_Date($requisition_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_Date) && !is_string($requisition_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_Date, true), gettype($requisition_Date)), __LINE__);
        }
        $this->Requisition_Date = $requisition_Date;
        return $this;
    }
    /**
     * Get Requisition_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getRequisition_Currency_Reference()
    {
        return $this->Requisition_Currency_Reference;
    }
    /**
     * Set Requisition_Currency_Reference value
     * @param \StructType\CurrencyObjectType $requisition_Currency_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequisition_Currency_Reference(\StructType\CurrencyObjectType $requisition_Currency_Reference = null)
    {
        $this->Requisition_Currency_Reference = $requisition_Currency_Reference;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * Set Requisition_Type_Reference value
     * @param \StructType\Requisition_TypeObjectType $requisition_Type_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $requisition_Type_Reference = null)
    {
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Get Par_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPar_Location_Reference()
    {
        return $this->Par_Location_Reference;
    }
    /**
     * Set Par_Location_Reference value
     * @param \StructType\LocationObjectType $par_Location_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setPar_Location_Reference(\StructType\LocationObjectType $par_Location_Reference = null)
    {
        $this->Par_Location_Reference = $par_Location_Reference;
        return $this;
    }
    /**
     * Get Requisition_Sourcing_Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequisition_Sourcing_Buyer_Reference()
    {
        return $this->Requisition_Sourcing_Buyer_Reference;
    }
    /**
     * Set Requisition_Sourcing_Buyer_Reference value
     * @param \StructType\WorkerObjectType $requisition_Sourcing_Buyer_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequisition_Sourcing_Buyer_Reference(\StructType\WorkerObjectType $requisition_Sourcing_Buyer_Reference = null)
    {
        $this->Requisition_Sourcing_Buyer_Reference = $requisition_Sourcing_Buyer_Reference;
        return $this;
    }
    /**
     * Get Requesting_Inventory_Site_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getRequesting_Inventory_Site_Reference()
    {
        return $this->Requesting_Inventory_Site_Reference;
    }
    /**
     * Set Requesting_Inventory_Site_Reference value
     * @param \StructType\LocationObjectType $requesting_Inventory_Site_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequesting_Inventory_Site_Reference(\StructType\LocationObjectType $requesting_Inventory_Site_Reference = null)
    {
        $this->Requesting_Inventory_Site_Reference = $requesting_Inventory_Site_Reference;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\Requisition_DataType
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->{'Deliver-To_Location_Reference'};
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $this->{'Deliver-To_Location_Reference'} = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Data value
     * @return \StructType\Ship_to_Address_for_RequisitionType|null
     */
    public function getShip_To_Address_Data()
    {
        return $this->Ship_To_Address_Data;
    }
    /**
     * Set Ship_To_Address_Data value
     * @param \StructType\Ship_to_Address_for_RequisitionType $ship_To_Address_Data
     * @return \StructType\Requisition_DataType
     */
    public function setShip_To_Address_Data(\StructType\Ship_to_Address_for_RequisitionType $ship_To_Address_Data = null)
    {
        $this->Ship_To_Address_Data = $ship_To_Address_Data;
        return $this;
    }
    /**
     * Get Reason_Code_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getReason_Code_Reference()
    {
        return $this->Reason_Code_Reference;
    }
    /**
     * Set Reason_Code_Reference value
     * @param \StructType\Reason_CodeObjectType $reason_Code_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setReason_Code_Reference(\StructType\Reason_CodeObjectType $reason_Code_Reference = null)
    {
        $this->Reason_Code_Reference = $reason_Code_Reference;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\Requisition_DataType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Requesting_Entity_Reference value
     * @return \StructType\Requesting_Entity_AbstractObjectType|null
     */
    public function getRequesting_Entity_Reference()
    {
        return $this->Requesting_Entity_Reference;
    }
    /**
     * Set Requesting_Entity_Reference value
     * @param \StructType\Requesting_Entity_AbstractObjectType $requesting_Entity_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setRequesting_Entity_Reference(\StructType\Requesting_Entity_AbstractObjectType $requesting_Entity_Reference = null)
    {
        $this->Requesting_Entity_Reference = $requesting_Entity_Reference;
        return $this;
    }
    /**
     * Get Memo_to_Suppliers value
     * @return string|null
     */
    public function getMemo_to_Suppliers()
    {
        return $this->Memo_to_Suppliers;
    }
    /**
     * Set Memo_to_Suppliers value
     * @param string $memo_to_Suppliers
     * @return \StructType\Requisition_DataType
     */
    public function setMemo_to_Suppliers($memo_to_Suppliers = null)
    {
        // validation for constraint: string
        if (!is_null($memo_to_Suppliers) && !is_string($memo_to_Suppliers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo_to_Suppliers, true), gettype($memo_to_Suppliers)), __LINE__);
        }
        $this->Memo_to_Suppliers = $memo_to_Suppliers;
        return $this;
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Requisition_DataType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
    /**
     * Get Internal_Memo value
     * @return string|null
     */
    public function getInternal_Memo()
    {
        return $this->Internal_Memo;
    }
    /**
     * Set Internal_Memo value
     * @param string $internal_Memo
     * @return \StructType\Requisition_DataType
     */
    public function setInternal_Memo($internal_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Memo) && !is_string($internal_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Memo, true), gettype($internal_Memo)), __LINE__);
        }
        $this->Internal_Memo = $internal_Memo;
        return $this;
    }
    /**
     * Get Freight_Amount value
     * @return float|null
     */
    public function getFreight_Amount()
    {
        return $this->Freight_Amount;
    }
    /**
     * Set Freight_Amount value
     * @param float $freight_Amount
     * @return \StructType\Requisition_DataType
     */
    public function setFreight_Amount($freight_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($freight_Amount) && !(is_float($freight_Amount) || is_numeric($freight_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freight_Amount, true), gettype($freight_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($freight_Amount) && mb_strlen(mb_substr($freight_Amount, false !== mb_strpos($freight_Amount, '.') ? mb_strpos($freight_Amount, '.') + 1 : mb_strlen($freight_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($freight_Amount, true), mb_strlen(mb_substr($freight_Amount, mb_strpos($freight_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($freight_Amount) && mb_strlen(preg_replace('/(\D)/', '', $freight_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($freight_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $freight_Amount))), __LINE__);
        }
        $this->Freight_Amount = $freight_Amount;
        return $this;
    }
    /**
     * Get Other_Charges value
     * @return float|null
     */
    public function getOther_Charges()
    {
        return $this->Other_Charges;
    }
    /**
     * Set Other_Charges value
     * @param float $other_Charges
     * @return \StructType\Requisition_DataType
     */
    public function setOther_Charges($other_Charges = null)
    {
        // validation for constraint: float
        if (!is_null($other_Charges) && !(is_float($other_Charges) || is_numeric($other_Charges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($other_Charges, true), gettype($other_Charges)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($other_Charges) && mb_strlen(mb_substr($other_Charges, false !== mb_strpos($other_Charges, '.') ? mb_strpos($other_Charges, '.') + 1 : mb_strlen($other_Charges))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($other_Charges, true), mb_strlen(mb_substr($other_Charges, mb_strpos($other_Charges, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($other_Charges) && mb_strlen(preg_replace('/(\D)/', '', $other_Charges)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($other_Charges, true), mb_strlen(preg_replace('/(\D)/', '', $other_Charges))), __LINE__);
        }
        $this->Other_Charges = $other_Charges;
        return $this;
    }
    /**
     * Get Procurement_Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getProcurement_Credit_Card_Reference()
    {
        return $this->Procurement_Credit_Card_Reference;
    }
    /**
     * Set Procurement_Credit_Card_Reference value
     * @param \StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference
     * @return \StructType\Requisition_DataType
     */
    public function setProcurement_Credit_Card_Reference(\StructType\Worker_Credit_CardObjectType $procurement_Credit_Card_Reference = null)
    {
        $this->Procurement_Credit_Card_Reference = $procurement_Credit_Card_Reference;
        return $this;
    }
    /**
     * Get High_Priority value
     * @return bool|null
     */
    public function getHigh_Priority()
    {
        return $this->High_Priority;
    }
    /**
     * Set High_Priority value
     * @param bool $high_Priority
     * @return \StructType\Requisition_DataType
     */
    public function setHigh_Priority($high_Priority = null)
    {
        // validation for constraint: boolean
        if (!is_null($high_Priority) && !is_bool($high_Priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($high_Priority, true), gettype($high_Priority)), __LINE__);
        }
        $this->High_Priority = $high_Priority;
        return $this;
    }
    /**
     * Get Consolidate_Requisition_on_PO value
     * @return bool|null
     */
    public function getConsolidate_Requisition_on_PO()
    {
        return $this->Consolidate_Requisition_on_PO;
    }
    /**
     * Set Consolidate_Requisition_on_PO value
     * @param bool $consolidate_Requisition_on_PO
     * @return \StructType\Requisition_DataType
     */
    public function setConsolidate_Requisition_on_PO($consolidate_Requisition_on_PO = null)
    {
        // validation for constraint: boolean
        if (!is_null($consolidate_Requisition_on_PO) && !is_bool($consolidate_Requisition_on_PO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consolidate_Requisition_on_PO, true), gettype($consolidate_Requisition_on_PO)), __LINE__);
        }
        $this->Consolidate_Requisition_on_PO = $consolidate_Requisition_on_PO;
        return $this;
    }
    /**
     * Get Exclude_Ship_To_Address_When_Consolidating_Requisition_Lines value
     * @return bool|null
     */
    public function getExclude_Ship_To_Address_When_Consolidating_Requisition_Lines()
    {
        return $this->Exclude_Ship_To_Address_When_Consolidating_Requisition_Lines;
    }
    /**
     * Set Exclude_Ship_To_Address_When_Consolidating_Requisition_Lines value
     * @param bool $exclude_Ship_To_Address_When_Consolidating_Requisition_Lines
     * @return \StructType\Requisition_DataType
     */
    public function setExclude_Ship_To_Address_When_Consolidating_Requisition_Lines($exclude_Ship_To_Address_When_Consolidating_Requisition_Lines = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Ship_To_Address_When_Consolidating_Requisition_Lines) && !is_bool($exclude_Ship_To_Address_When_Consolidating_Requisition_Lines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Ship_To_Address_When_Consolidating_Requisition_Lines, true), gettype($exclude_Ship_To_Address_When_Consolidating_Requisition_Lines)), __LINE__);
        }
        $this->Exclude_Ship_To_Address_When_Consolidating_Requisition_Lines = $exclude_Ship_To_Address_When_Consolidating_Requisition_Lines;
        return $this;
    }
    /**
     * Get Procedure_Information_Data value
     * @return \StructType\Procedure_Information_DataType|null
     */
    public function getProcedure_Information_Data()
    {
        return $this->Procedure_Information_Data;
    }
    /**
     * Set Procedure_Information_Data value
     * @param \StructType\Procedure_Information_DataType $procedure_Information_Data
     * @return \StructType\Requisition_DataType
     */
    public function setProcedure_Information_Data(\StructType\Procedure_Information_DataType $procedure_Information_Data = null)
    {
        $this->Procedure_Information_Data = $procedure_Information_Data;
        return $this;
    }
    /**
     * Get Item_Request_Line_Data value
     * @return \StructType\Item_Request_Line_DataType[]|null
     */
    public function getItem_Request_Line_Data()
    {
        return $this->Item_Request_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Request_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Request_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Request_Line_DataForArrayConstraintsFromSetItem_Request_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_DataTypeItem_Request_Line_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_DataTypeItem_Request_Line_DataItem instanceof \StructType\Item_Request_Line_DataType) {
                $invalidValues[] = is_object($requisition_DataTypeItem_Request_Line_DataItem) ? get_class($requisition_DataTypeItem_Request_Line_DataItem) : sprintf('%s(%s)', gettype($requisition_DataTypeItem_Request_Line_DataItem), var_export($requisition_DataTypeItem_Request_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Request_Line_Data property can only contain items of type \StructType\Item_Request_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Request_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Request_Line_DataType[] $item_Request_Line_Data
     * @return \StructType\Requisition_DataType
     */
    public function setItem_Request_Line_Data(array $item_Request_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Request_Line_DataArrayErrorMessage = self::validateItem_Request_Line_DataForArrayConstraintsFromSetItem_Request_Line_Data($item_Request_Line_Data))) {
            throw new \InvalidArgumentException($item_Request_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Request_Line_Data = $item_Request_Line_Data;
        return $this;
    }
    /**
     * Add item to Item_Request_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Request_Line_DataType $item
     * @return \StructType\Requisition_DataType
     */
    public function addToItem_Request_Line_Data(\StructType\Item_Request_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Request_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Request_Line_Data property can only contain items of type \StructType\Item_Request_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Request_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Service_Request_Line_Data value
     * @return \StructType\Service_Request_Line_DataType[]|null
     */
    public function getService_Request_Line_Data()
    {
        return $this->Service_Request_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Request_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Request_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Request_Line_DataForArrayConstraintsFromSetService_Request_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_DataTypeService_Request_Line_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_DataTypeService_Request_Line_DataItem instanceof \StructType\Service_Request_Line_DataType) {
                $invalidValues[] = is_object($requisition_DataTypeService_Request_Line_DataItem) ? get_class($requisition_DataTypeService_Request_Line_DataItem) : sprintf('%s(%s)', gettype($requisition_DataTypeService_Request_Line_DataItem), var_export($requisition_DataTypeService_Request_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Request_Line_Data property can only contain items of type \StructType\Service_Request_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Request_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Service_Request_Line_DataType[] $service_Request_Line_Data
     * @return \StructType\Requisition_DataType
     */
    public function setService_Request_Line_Data(array $service_Request_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Request_Line_DataArrayErrorMessage = self::validateService_Request_Line_DataForArrayConstraintsFromSetService_Request_Line_Data($service_Request_Line_Data))) {
            throw new \InvalidArgumentException($service_Request_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Request_Line_Data = $service_Request_Line_Data;
        return $this;
    }
    /**
     * Add item to Service_Request_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Service_Request_Line_DataType $item
     * @return \StructType\Requisition_DataType
     */
    public function addToService_Request_Line_Data(\StructType\Service_Request_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Service_Request_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Service_Request_Line_Data property can only contain items of type \StructType\Service_Request_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Request_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Deliverables_Line_Data value
     * @return \StructType\Project_Based_Requisition_Line_DataType[]|null
     */
    public function getDeliverables_Line_Data()
    {
        return $this->Deliverables_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDeliverables_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliverables_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliverables_Line_DataForArrayConstraintsFromSetDeliverables_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_DataTypeDeliverables_Line_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_DataTypeDeliverables_Line_DataItem instanceof \StructType\Project_Based_Requisition_Line_DataType) {
                $invalidValues[] = is_object($requisition_DataTypeDeliverables_Line_DataItem) ? get_class($requisition_DataTypeDeliverables_Line_DataItem) : sprintf('%s(%s)', gettype($requisition_DataTypeDeliverables_Line_DataItem), var_export($requisition_DataTypeDeliverables_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deliverables_Line_Data property can only contain items of type \StructType\Project_Based_Requisition_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deliverables_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Based_Requisition_Line_DataType[] $deliverables_Line_Data
     * @return \StructType\Requisition_DataType
     */
    public function setDeliverables_Line_Data(array $deliverables_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($deliverables_Line_DataArrayErrorMessage = self::validateDeliverables_Line_DataForArrayConstraintsFromSetDeliverables_Line_Data($deliverables_Line_Data))) {
            throw new \InvalidArgumentException($deliverables_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Deliverables_Line_Data = $deliverables_Line_Data;
        return $this;
    }
    /**
     * Add item to Deliverables_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Based_Requisition_Line_DataType $item
     * @return \StructType\Requisition_DataType
     */
    public function addToDeliverables_Line_Data(\StructType\Project_Based_Requisition_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Based_Requisition_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Deliverables_Line_Data property can only contain items of type \StructType\Project_Based_Requisition_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deliverables_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_DataTypeAttachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType) {
                $invalidValues[] = is_object($requisition_DataTypeAttachment_DataItem) ? get_class($requisition_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($requisition_DataTypeAttachment_DataItem), var_export($requisition_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Requisition_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $item
     * @return \StructType\Requisition_DataType
     */
    public function addToAttachment_Data(\StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_And_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Ad_Hoc_Address_Replacement_Data value
     * @return \StructType\Address_Information_DataType[]|null
     */
    public function getAd_Hoc_Address_Replacement_Data()
    {
        return $this->Ad_Hoc_Address_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAd_Hoc_Address_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAd_Hoc_Address_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAd_Hoc_Address_Replacement_DataForArrayConstraintsFromSetAd_Hoc_Address_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_DataTypeAd_Hoc_Address_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_DataTypeAd_Hoc_Address_Replacement_DataItem instanceof \StructType\Address_Information_DataType) {
                $invalidValues[] = is_object($requisition_DataTypeAd_Hoc_Address_Replacement_DataItem) ? get_class($requisition_DataTypeAd_Hoc_Address_Replacement_DataItem) : sprintf('%s(%s)', gettype($requisition_DataTypeAd_Hoc_Address_Replacement_DataItem), var_export($requisition_DataTypeAd_Hoc_Address_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ad_Hoc_Address_Replacement_Data property can only contain items of type \StructType\Address_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ad_Hoc_Address_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_Information_DataType[] $ad_Hoc_Address_Replacement_Data
     * @return \StructType\Requisition_DataType
     */
    public function setAd_Hoc_Address_Replacement_Data(array $ad_Hoc_Address_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($ad_Hoc_Address_Replacement_DataArrayErrorMessage = self::validateAd_Hoc_Address_Replacement_DataForArrayConstraintsFromSetAd_Hoc_Address_Replacement_Data($ad_Hoc_Address_Replacement_Data))) {
            throw new \InvalidArgumentException($ad_Hoc_Address_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Ad_Hoc_Address_Replacement_Data = $ad_Hoc_Address_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Ad_Hoc_Address_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Address_Information_DataType $item
     * @return \StructType\Requisition_DataType
     */
    public function addToAd_Hoc_Address_Replacement_Data(\StructType\Address_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Ad_Hoc_Address_Replacement_Data property can only contain items of type \StructType\Address_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ad_Hoc_Address_Replacement_Data[] = $item;
        return $this;
    }
}
