<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reassign_Expense_Credit_Card_Transaction_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Response Element containing Expense Credit Card Transaction reference
 * @subpackage Structs
 */
class Reassign_Expense_Credit_Card_Transaction_ResponseType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference to credit card transaction.
     * - minOccurs: 0
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Expense_Credit_Card_Transaction_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Reassign_Expense_Credit_Card_Transaction_ResponseType
     * @uses Reassign_Expense_Credit_Card_Transaction_ResponseType::setExpense_Credit_Card_Transaction_Reference()
     * @uses Reassign_Expense_Credit_Card_Transaction_ResponseType::setVersion()
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @param string $version
     */
    public function __construct(\StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null, $version = null)
    {
        $this
            ->setExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference)
            ->setVersion($version);
    }
    /**
     * Get Expense_Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getExpense_Credit_Card_Transaction_Reference()
    {
        return $this->Expense_Credit_Card_Transaction_Reference;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Reference value
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @return \StructType\Reassign_Expense_Credit_Card_Transaction_ResponseType
     */
    public function setExpense_Credit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null)
    {
        $this->Expense_Credit_Card_Transaction_Reference = $expense_Credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Reassign_Expense_Credit_Card_Transaction_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
