<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Procurement_Document_Attachment_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Put Procurement Document Attachment Response Data
 * @subpackage Structs
 */
class Put_Procurement_Document_Attachment_ResponseType extends AbstractStructBase
{
    /**
     * The Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Procurement Document for attachment adding only purposes.
     * - minOccurs: 0
     * @var \StructType\Business_DocumentObjectType
     */
    public $Document_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Procurement_Document_Attachment_ResponseType
     * @uses Put_Procurement_Document_Attachment_ResponseType::setDocument_Reference()
     * @uses Put_Procurement_Document_Attachment_ResponseType::setVersion()
     * @param \StructType\Business_DocumentObjectType $document_Reference
     * @param string $version
     */
    public function __construct(\StructType\Business_DocumentObjectType $document_Reference = null, $version = null)
    {
        $this
            ->setDocument_Reference($document_Reference)
            ->setVersion($version);
    }
    /**
     * Get Document_Reference value
     * @return \StructType\Business_DocumentObjectType|null
     */
    public function getDocument_Reference()
    {
        return $this->Document_Reference;
    }
    /**
     * Set Document_Reference value
     * @param \StructType\Business_DocumentObjectType $document_Reference
     * @return \StructType\Put_Procurement_Document_Attachment_ResponseType
     */
    public function setDocument_Reference(\StructType\Business_DocumentObjectType $document_Reference = null)
    {
        $this->Document_Reference = $document_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Procurement_Document_Attachment_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
