<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Mass_Close_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Procurement Mass Close object
 * @subpackage Structs
 */
class Procurement_Mass_Close_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Procurement_Mass_Close_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Mass Close Reference
     * - maxOccurs: unbounded
     * @var \StructType\Procurement_Document_Mass_ActionObjectType[]
     */
    public $Procurement_Mass_Close_Reference;
    /**
     * Constructor method for Procurement_Mass_Close_Request_ReferencesType
     * @uses Procurement_Mass_Close_Request_ReferencesType::setProcurement_Mass_Close_Reference()
     * @param \StructType\Procurement_Document_Mass_ActionObjectType[] $procurement_Mass_Close_Reference
     */
    public function __construct(array $procurement_Mass_Close_Reference = array())
    {
        $this
            ->setProcurement_Mass_Close_Reference($procurement_Mass_Close_Reference);
    }
    /**
     * Get Procurement_Mass_Close_Reference value
     * @return \StructType\Procurement_Document_Mass_ActionObjectType[]|null
     */
    public function getProcurement_Mass_Close_Reference()
    {
        return $this->Procurement_Mass_Close_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Mass_Close_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Mass_Close_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Mass_Close_ReferenceForArrayConstraintsFromSetProcurement_Mass_Close_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Mass_Close_Request_ReferencesTypeProcurement_Mass_Close_ReferenceItem) {
            // validation for constraint: itemType
            if (!$procurement_Mass_Close_Request_ReferencesTypeProcurement_Mass_Close_ReferenceItem instanceof \StructType\Procurement_Document_Mass_ActionObjectType) {
                $invalidValues[] = is_object($procurement_Mass_Close_Request_ReferencesTypeProcurement_Mass_Close_ReferenceItem) ? get_class($procurement_Mass_Close_Request_ReferencesTypeProcurement_Mass_Close_ReferenceItem) : sprintf('%s(%s)', gettype($procurement_Mass_Close_Request_ReferencesTypeProcurement_Mass_Close_ReferenceItem), var_export($procurement_Mass_Close_Request_ReferencesTypeProcurement_Mass_Close_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Mass_Close_Reference property can only contain items of type \StructType\Procurement_Document_Mass_ActionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Mass_Close_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Document_Mass_ActionObjectType[] $procurement_Mass_Close_Reference
     * @return \StructType\Procurement_Mass_Close_Request_ReferencesType
     */
    public function setProcurement_Mass_Close_Reference(array $procurement_Mass_Close_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Mass_Close_ReferenceArrayErrorMessage = self::validateProcurement_Mass_Close_ReferenceForArrayConstraintsFromSetProcurement_Mass_Close_Reference($procurement_Mass_Close_Reference))) {
            throw new \InvalidArgumentException($procurement_Mass_Close_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Mass_Close_Reference = $procurement_Mass_Close_Reference;
        return $this;
    }
    /**
     * Add item to Procurement_Mass_Close_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Document_Mass_ActionObjectType $item
     * @return \StructType\Procurement_Mass_Close_Request_ReferencesType
     */
    public function addToProcurement_Mass_Close_Reference(\StructType\Procurement_Document_Mass_ActionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Document_Mass_ActionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Mass_Close_Reference property can only contain items of type \StructType\Procurement_Document_Mass_ActionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Mass_Close_Reference[] = $item;
        return $this;
    }
}
