<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Identifier_Type_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The element containing item identifier type request references.
 * @subpackage Structs
 */
class Item_Identifier_Type_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The reference to item identifier type.
     * - maxOccurs: unbounded
     * @var \StructType\Item_Identifier_TypeObjectType[]
     */
    public $Item_Identifier_Type_Reference;
    /**
     * Constructor method for Item_Identifier_Type_Request_ReferencesType
     * @uses Item_Identifier_Type_Request_ReferencesType::setItem_Identifier_Type_Reference()
     * @param \StructType\Item_Identifier_TypeObjectType[] $item_Identifier_Type_Reference
     */
    public function __construct(array $item_Identifier_Type_Reference = array())
    {
        $this
            ->setItem_Identifier_Type_Reference($item_Identifier_Type_Reference);
    }
    /**
     * Get Item_Identifier_Type_Reference value
     * @return \StructType\Item_Identifier_TypeObjectType[]|null
     */
    public function getItem_Identifier_Type_Reference()
    {
        return $this->Item_Identifier_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Identifier_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Identifier_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Identifier_Type_ReferenceForArrayConstraintsFromSetItem_Identifier_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Identifier_Type_Request_ReferencesTypeItem_Identifier_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Identifier_Type_Request_ReferencesTypeItem_Identifier_Type_ReferenceItem instanceof \StructType\Item_Identifier_TypeObjectType) {
                $invalidValues[] = is_object($item_Identifier_Type_Request_ReferencesTypeItem_Identifier_Type_ReferenceItem) ? get_class($item_Identifier_Type_Request_ReferencesTypeItem_Identifier_Type_ReferenceItem) : sprintf('%s(%s)', gettype($item_Identifier_Type_Request_ReferencesTypeItem_Identifier_Type_ReferenceItem), var_export($item_Identifier_Type_Request_ReferencesTypeItem_Identifier_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Identifier_Type_Reference property can only contain items of type \StructType\Item_Identifier_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Identifier_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_TypeObjectType[] $item_Identifier_Type_Reference
     * @return \StructType\Item_Identifier_Type_Request_ReferencesType
     */
    public function setItem_Identifier_Type_Reference(array $item_Identifier_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Identifier_Type_ReferenceArrayErrorMessage = self::validateItem_Identifier_Type_ReferenceForArrayConstraintsFromSetItem_Identifier_Type_Reference($item_Identifier_Type_Reference))) {
            throw new \InvalidArgumentException($item_Identifier_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Identifier_Type_Reference = $item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Add item to Item_Identifier_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_TypeObjectType $item
     * @return \StructType\Item_Identifier_Type_Request_ReferencesType
     */
    public function addToItem_Identifier_Type_Reference(\StructType\Item_Identifier_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Identifier_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Identifier_Type_Reference property can only contain items of type \StructType\Item_Identifier_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Identifier_Type_Reference[] = $item;
        return $this;
    }
}
