<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_WWS_Outbound_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Report Data contains all the information about an Expense Report -.
 * @subpackage Structs
 */
class Expense_Report_WWS_Outbound_DataType extends AbstractStructBase
{
    /**
     * The Expense_Report_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Report ID. This is the Expense Report unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_ID;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the person who the expense report is for.
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Expense_Payee_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the currency that the expense report will be reported in. This must match the currency for the company.
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the company the expense report is for.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing and canceling the invoice inside the Workday application. Invoice can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Expense_Report_Number
     * Meta information extracted from the WSDL
     * - documentation: The document number that will be assigned to the expense report. Leave it blank to have the number auto-assigned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_Number;
    /**
     * The Expense_Report_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the expense report was created.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_Date;
    /**
     * The Expense_Report_Approval_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the expense report was approved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_Approval_Date;
    /**
     * The Expense_Report_Status
     * Meta information extracted from the WSDL
     * - documentation: The status of the expense report.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_Status;
    /**
     * The Budget_Check_Status
     * Meta information extracted from the WSDL
     * - documentation: Budget Check Status
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Check_Status;
    /**
     * The Committee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Returns the Committee if Expense Payee is an External Committee Member
     * - minOccurs: 0
     * @var \StructType\CommitteeObjectType
     */
    public $Committee_Reference;
    /**
     * The Job_Application_Reference
     * Meta information extracted from the WSDL
     * - documentation: Job Application Reference
     * - minOccurs: 0
     * @var \StructType\Job_ApplicationObjectType
     */
    public $Job_Application_Reference;
    /**
     * The Business_Purpose_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the business purpose for the expense report.
     * - minOccurs: 0
     * @var \StructType\Business_PurposeObjectType
     */
    public $Business_Purpose_Reference;
    /**
     * The Expense_Report_Total_Amount
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY. The total amount of the expense report.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Expense_Report_Total_Amount;
    /**
     * The Expense_Report_Total_Reimbursement_Amount
     * Meta information extracted from the WSDL
     * - documentation: The total reimbursement amount of the expense report.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Expense_Report_Total_Reimbursement_Amount;
    /**
     * The Cash_Advance_Applied_Amount
     * Meta information extracted from the WSDL
     * - documentation: The total cash advance applied amount for the expense report.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Cash_Advance_Applied_Amount;
    /**
     * The Prior_Balance_Applied
     * Meta information extracted from the WSDL
     * - documentation: The Prior Balance Applied from this Expense Report to a negative reimbursable Expense Report.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Prior_Balance_Applied;
    /**
     * The Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the payment type for the expense report. This is how the expense payee will be paid.
     * @var \StructType\Payment_TypeObjectType
     */
    public $Payment_Type_Reference;
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the spend authorization that gives pre-approval for the expense report.
     * - minOccurs: 0
     * @var \StructType\Spend_AuthorizationObjectType
     */
    public $Spend_Authorization_Reference;
    /**
     * The Final_Expense_Report_for_Spend_Authorization
     * Meta information extracted from the WSDL
     * - documentation: Set to True if this is the Final Expense Report to be used with the related Spend Authorization
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Final_Expense_Report_for_Spend_Authorization;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the supplier of the person who the expense report is for if that person is a contingent worker.
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Text describing the use and purpose of the expense report.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Parent_Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Parent Expense Report for this Expense Report.
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType
     */
    public $Parent_Expense_Report_Reference;
    /**
     * The Child_Expense_Reports_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Child Expense Reports for this Expense Report.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType[]
     */
    public $Child_Expense_Reports_Reference;
    /**
     * The Expense_Report_Lines_Reference_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Report_Line_WWS_Outbound_DataType[]
     */
    public $Expense_Report_Lines_Reference_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Expense_Report_WWS_Outbound_DataType
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_ID()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Payee_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setCurrency_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setCompany_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setLocked_in_Workday()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Number()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Date()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Approval_Date()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Status()
     * @uses Expense_Report_WWS_Outbound_DataType::setBudget_Check_Status()
     * @uses Expense_Report_WWS_Outbound_DataType::setCommittee_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setJob_Application_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setBusiness_Purpose_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Total_Amount()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Total_Reimbursement_Amount()
     * @uses Expense_Report_WWS_Outbound_DataType::setCash_Advance_Applied_Amount()
     * @uses Expense_Report_WWS_Outbound_DataType::setPrior_Balance_Applied()
     * @uses Expense_Report_WWS_Outbound_DataType::setPayment_Type_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setSpend_Authorization_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setFinal_Expense_Report_for_Spend_Authorization()
     * @uses Expense_Report_WWS_Outbound_DataType::setSupplier_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setMemo()
     * @uses Expense_Report_WWS_Outbound_DataType::setParent_Expense_Report_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setChild_Expense_Reports_Reference()
     * @uses Expense_Report_WWS_Outbound_DataType::setExpense_Report_Lines_Reference_Data()
     * @uses Expense_Report_WWS_Outbound_DataType::setAttachment_Data()
     * @param string $expense_Report_ID
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param bool $locked_in_Workday
     * @param string $expense_Report_Number
     * @param string $expense_Report_Date
     * @param string $expense_Report_Approval_Date
     * @param string $expense_Report_Status
     * @param string $budget_Check_Status
     * @param \StructType\CommitteeObjectType $committee_Reference
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @param \StructType\Business_PurposeObjectType $business_Purpose_Reference
     * @param float $expense_Report_Total_Amount
     * @param float $expense_Report_Total_Reimbursement_Amount
     * @param float $cash_Advance_Applied_Amount
     * @param float $prior_Balance_Applied
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @param bool $final_Expense_Report_for_Spend_Authorization
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param string $memo
     * @param \StructType\Expense_ReportObjectType $parent_Expense_Report_Reference
     * @param \StructType\Expense_ReportObjectType[] $child_Expense_Reports_Reference
     * @param \StructType\Expense_Report_Line_WWS_Outbound_DataType[] $expense_Report_Lines_Reference_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct($expense_Report_ID = null, \StructType\Expense_PayeeObjectType $expense_Payee_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\CompanyObjectType $company_Reference = null, $locked_in_Workday = null, $expense_Report_Number = null, $expense_Report_Date = null, $expense_Report_Approval_Date = null, $expense_Report_Status = null, $budget_Check_Status = null, \StructType\CommitteeObjectType $committee_Reference = null, \StructType\Job_ApplicationObjectType $job_Application_Reference = null, \StructType\Business_PurposeObjectType $business_Purpose_Reference = null, $expense_Report_Total_Amount = null, $expense_Report_Total_Reimbursement_Amount = null, $cash_Advance_Applied_Amount = null, $prior_Balance_Applied = null, \StructType\Payment_TypeObjectType $payment_Type_Reference = null, \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null, $final_Expense_Report_for_Spend_Authorization = null, \StructType\SupplierObjectType $supplier_Reference = null, $memo = null, \StructType\Expense_ReportObjectType $parent_Expense_Report_Reference = null, array $child_Expense_Reports_Reference = array(), array $expense_Report_Lines_Reference_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setExpense_Report_ID($expense_Report_ID)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setCompany_Reference($company_Reference)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setExpense_Report_Number($expense_Report_Number)
            ->setExpense_Report_Date($expense_Report_Date)
            ->setExpense_Report_Approval_Date($expense_Report_Approval_Date)
            ->setExpense_Report_Status($expense_Report_Status)
            ->setBudget_Check_Status($budget_Check_Status)
            ->setCommittee_Reference($committee_Reference)
            ->setJob_Application_Reference($job_Application_Reference)
            ->setBusiness_Purpose_Reference($business_Purpose_Reference)
            ->setExpense_Report_Total_Amount($expense_Report_Total_Amount)
            ->setExpense_Report_Total_Reimbursement_Amount($expense_Report_Total_Reimbursement_Amount)
            ->setCash_Advance_Applied_Amount($cash_Advance_Applied_Amount)
            ->setPrior_Balance_Applied($prior_Balance_Applied)
            ->setPayment_Type_Reference($payment_Type_Reference)
            ->setSpend_Authorization_Reference($spend_Authorization_Reference)
            ->setFinal_Expense_Report_for_Spend_Authorization($final_Expense_Report_for_Spend_Authorization)
            ->setSupplier_Reference($supplier_Reference)
            ->setMemo($memo)
            ->setParent_Expense_Report_Reference($parent_Expense_Report_Reference)
            ->setChild_Expense_Reports_Reference($child_Expense_Reports_Reference)
            ->setExpense_Report_Lines_Reference_Data($expense_Report_Lines_Reference_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Expense_Report_ID value
     * @return string|null
     */
    public function getExpense_Report_ID()
    {
        return $this->Expense_Report_ID;
    }
    /**
     * Set Expense_Report_ID value
     * @param string $expense_Report_ID
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_ID($expense_Report_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_ID) && !is_string($expense_Report_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_ID, true), gettype($expense_Report_ID)), __LINE__);
        }
        $this->Expense_Report_ID = $expense_Report_ID;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * Set Expense_Payee_Reference value
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $expense_Payee_Reference = null)
    {
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Expense_Report_Number value
     * @return string|null
     */
    public function getExpense_Report_Number()
    {
        return $this->Expense_Report_Number;
    }
    /**
     * Set Expense_Report_Number value
     * @param string $expense_Report_Number
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Number($expense_Report_Number = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Number) && !is_string($expense_Report_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Number, true), gettype($expense_Report_Number)), __LINE__);
        }
        $this->Expense_Report_Number = $expense_Report_Number;
        return $this;
    }
    /**
     * Get Expense_Report_Date value
     * @return string|null
     */
    public function getExpense_Report_Date()
    {
        return $this->Expense_Report_Date;
    }
    /**
     * Set Expense_Report_Date value
     * @param string $expense_Report_Date
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Date($expense_Report_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Date) && !is_string($expense_Report_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Date, true), gettype($expense_Report_Date)), __LINE__);
        }
        $this->Expense_Report_Date = $expense_Report_Date;
        return $this;
    }
    /**
     * Get Expense_Report_Approval_Date value
     * @return string|null
     */
    public function getExpense_Report_Approval_Date()
    {
        return $this->Expense_Report_Approval_Date;
    }
    /**
     * Set Expense_Report_Approval_Date value
     * @param string $expense_Report_Approval_Date
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Approval_Date($expense_Report_Approval_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Approval_Date) && !is_string($expense_Report_Approval_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Approval_Date, true), gettype($expense_Report_Approval_Date)), __LINE__);
        }
        $this->Expense_Report_Approval_Date = $expense_Report_Approval_Date;
        return $this;
    }
    /**
     * Get Expense_Report_Status value
     * @return string|null
     */
    public function getExpense_Report_Status()
    {
        return $this->Expense_Report_Status;
    }
    /**
     * Set Expense_Report_Status value
     * @param string $expense_Report_Status
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Status($expense_Report_Status = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Status) && !is_string($expense_Report_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Status, true), gettype($expense_Report_Status)), __LINE__);
        }
        $this->Expense_Report_Status = $expense_Report_Status;
        return $this;
    }
    /**
     * Get Budget_Check_Status value
     * @return string|null
     */
    public function getBudget_Check_Status()
    {
        return $this->Budget_Check_Status;
    }
    /**
     * Set Budget_Check_Status value
     * @param string $budget_Check_Status
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setBudget_Check_Status($budget_Check_Status = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Check_Status) && !is_string($budget_Check_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Check_Status, true), gettype($budget_Check_Status)), __LINE__);
        }
        $this->Budget_Check_Status = $budget_Check_Status;
        return $this;
    }
    /**
     * Get Committee_Reference value
     * @return \StructType\CommitteeObjectType|null
     */
    public function getCommittee_Reference()
    {
        return $this->Committee_Reference;
    }
    /**
     * Set Committee_Reference value
     * @param \StructType\CommitteeObjectType $committee_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setCommittee_Reference(\StructType\CommitteeObjectType $committee_Reference = null)
    {
        $this->Committee_Reference = $committee_Reference;
        return $this;
    }
    /**
     * Get Job_Application_Reference value
     * @return \StructType\Job_ApplicationObjectType|null
     */
    public function getJob_Application_Reference()
    {
        return $this->Job_Application_Reference;
    }
    /**
     * Set Job_Application_Reference value
     * @param \StructType\Job_ApplicationObjectType $job_Application_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setJob_Application_Reference(\StructType\Job_ApplicationObjectType $job_Application_Reference = null)
    {
        $this->Job_Application_Reference = $job_Application_Reference;
        return $this;
    }
    /**
     * Get Business_Purpose_Reference value
     * @return \StructType\Business_PurposeObjectType|null
     */
    public function getBusiness_Purpose_Reference()
    {
        return $this->Business_Purpose_Reference;
    }
    /**
     * Set Business_Purpose_Reference value
     * @param \StructType\Business_PurposeObjectType $business_Purpose_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setBusiness_Purpose_Reference(\StructType\Business_PurposeObjectType $business_Purpose_Reference = null)
    {
        $this->Business_Purpose_Reference = $business_Purpose_Reference;
        return $this;
    }
    /**
     * Get Expense_Report_Total_Amount value
     * @return float|null
     */
    public function getExpense_Report_Total_Amount()
    {
        return $this->Expense_Report_Total_Amount;
    }
    /**
     * Set Expense_Report_Total_Amount value
     * @param float $expense_Report_Total_Amount
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Total_Amount($expense_Report_Total_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($expense_Report_Total_Amount) && !(is_float($expense_Report_Total_Amount) || is_numeric($expense_Report_Total_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expense_Report_Total_Amount, true), gettype($expense_Report_Total_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($expense_Report_Total_Amount) && mb_strlen(mb_substr($expense_Report_Total_Amount, false !== mb_strpos($expense_Report_Total_Amount, '.') ? mb_strpos($expense_Report_Total_Amount, '.') + 1 : mb_strlen($expense_Report_Total_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($expense_Report_Total_Amount, true), mb_strlen(mb_substr($expense_Report_Total_Amount, mb_strpos($expense_Report_Total_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($expense_Report_Total_Amount) && mb_strlen(preg_replace('/(\D)/', '', $expense_Report_Total_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($expense_Report_Total_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $expense_Report_Total_Amount))), __LINE__);
        }
        $this->Expense_Report_Total_Amount = $expense_Report_Total_Amount;
        return $this;
    }
    /**
     * Get Expense_Report_Total_Reimbursement_Amount value
     * @return float|null
     */
    public function getExpense_Report_Total_Reimbursement_Amount()
    {
        return $this->Expense_Report_Total_Reimbursement_Amount;
    }
    /**
     * Set Expense_Report_Total_Reimbursement_Amount value
     * @param float $expense_Report_Total_Reimbursement_Amount
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Total_Reimbursement_Amount($expense_Report_Total_Reimbursement_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($expense_Report_Total_Reimbursement_Amount) && !(is_float($expense_Report_Total_Reimbursement_Amount) || is_numeric($expense_Report_Total_Reimbursement_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expense_Report_Total_Reimbursement_Amount, true), gettype($expense_Report_Total_Reimbursement_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($expense_Report_Total_Reimbursement_Amount) && mb_strlen(mb_substr($expense_Report_Total_Reimbursement_Amount, false !== mb_strpos($expense_Report_Total_Reimbursement_Amount, '.') ? mb_strpos($expense_Report_Total_Reimbursement_Amount, '.') + 1 : mb_strlen($expense_Report_Total_Reimbursement_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($expense_Report_Total_Reimbursement_Amount, true), mb_strlen(mb_substr($expense_Report_Total_Reimbursement_Amount, mb_strpos($expense_Report_Total_Reimbursement_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($expense_Report_Total_Reimbursement_Amount) && mb_strlen(preg_replace('/(\D)/', '', $expense_Report_Total_Reimbursement_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($expense_Report_Total_Reimbursement_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $expense_Report_Total_Reimbursement_Amount))), __LINE__);
        }
        $this->Expense_Report_Total_Reimbursement_Amount = $expense_Report_Total_Reimbursement_Amount;
        return $this;
    }
    /**
     * Get Cash_Advance_Applied_Amount value
     * @return float|null
     */
    public function getCash_Advance_Applied_Amount()
    {
        return $this->Cash_Advance_Applied_Amount;
    }
    /**
     * Set Cash_Advance_Applied_Amount value
     * @param float $cash_Advance_Applied_Amount
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setCash_Advance_Applied_Amount($cash_Advance_Applied_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($cash_Advance_Applied_Amount) && !(is_float($cash_Advance_Applied_Amount) || is_numeric($cash_Advance_Applied_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cash_Advance_Applied_Amount, true), gettype($cash_Advance_Applied_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cash_Advance_Applied_Amount) && mb_strlen(mb_substr($cash_Advance_Applied_Amount, false !== mb_strpos($cash_Advance_Applied_Amount, '.') ? mb_strpos($cash_Advance_Applied_Amount, '.') + 1 : mb_strlen($cash_Advance_Applied_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cash_Advance_Applied_Amount, true), mb_strlen(mb_substr($cash_Advance_Applied_Amount, mb_strpos($cash_Advance_Applied_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($cash_Advance_Applied_Amount) && $cash_Advance_Applied_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($cash_Advance_Applied_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($cash_Advance_Applied_Amount) && mb_strlen(preg_replace('/(\D)/', '', $cash_Advance_Applied_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($cash_Advance_Applied_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $cash_Advance_Applied_Amount))), __LINE__);
        }
        $this->Cash_Advance_Applied_Amount = $cash_Advance_Applied_Amount;
        return $this;
    }
    /**
     * Get Prior_Balance_Applied value
     * @return float|null
     */
    public function getPrior_Balance_Applied()
    {
        return $this->Prior_Balance_Applied;
    }
    /**
     * Set Prior_Balance_Applied value
     * @param float $prior_Balance_Applied
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setPrior_Balance_Applied($prior_Balance_Applied = null)
    {
        // validation for constraint: float
        if (!is_null($prior_Balance_Applied) && !(is_float($prior_Balance_Applied) || is_numeric($prior_Balance_Applied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prior_Balance_Applied, true), gettype($prior_Balance_Applied)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($prior_Balance_Applied) && mb_strlen(mb_substr($prior_Balance_Applied, false !== mb_strpos($prior_Balance_Applied, '.') ? mb_strpos($prior_Balance_Applied, '.') + 1 : mb_strlen($prior_Balance_Applied))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($prior_Balance_Applied, true), mb_strlen(mb_substr($prior_Balance_Applied, mb_strpos($prior_Balance_Applied, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($prior_Balance_Applied) && mb_strlen(preg_replace('/(\D)/', '', $prior_Balance_Applied)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($prior_Balance_Applied, true), mb_strlen(preg_replace('/(\D)/', '', $prior_Balance_Applied))), __LINE__);
        }
        $this->Prior_Balance_Applied = $prior_Balance_Applied;
        return $this;
    }
    /**
     * Get Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getPayment_Type_Reference()
    {
        return $this->Payment_Type_Reference;
    }
    /**
     * Set Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $payment_Type_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setPayment_Type_Reference(\StructType\Payment_TypeObjectType $payment_Type_Reference = null)
    {
        $this->Payment_Type_Reference = $payment_Type_Reference;
        return $this;
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null)
    {
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Get Final_Expense_Report_for_Spend_Authorization value
     * @return bool|null
     */
    public function getFinal_Expense_Report_for_Spend_Authorization()
    {
        return $this->Final_Expense_Report_for_Spend_Authorization;
    }
    /**
     * Set Final_Expense_Report_for_Spend_Authorization value
     * @param bool $final_Expense_Report_for_Spend_Authorization
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setFinal_Expense_Report_for_Spend_Authorization($final_Expense_Report_for_Spend_Authorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($final_Expense_Report_for_Spend_Authorization) && !is_bool($final_Expense_Report_for_Spend_Authorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($final_Expense_Report_for_Spend_Authorization, true), gettype($final_Expense_Report_for_Spend_Authorization)), __LINE__);
        }
        $this->Final_Expense_Report_for_Spend_Authorization = $final_Expense_Report_for_Spend_Authorization;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Parent_Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getParent_Expense_Report_Reference()
    {
        return $this->Parent_Expense_Report_Reference;
    }
    /**
     * Set Parent_Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $parent_Expense_Report_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setParent_Expense_Report_Reference(\StructType\Expense_ReportObjectType $parent_Expense_Report_Reference = null)
    {
        $this->Parent_Expense_Report_Reference = $parent_Expense_Report_Reference;
        return $this;
    }
    /**
     * Get Child_Expense_Reports_Reference value
     * @return \StructType\Expense_ReportObjectType[]|null
     */
    public function getChild_Expense_Reports_Reference()
    {
        return $this->Child_Expense_Reports_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setChild_Expense_Reports_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChild_Expense_Reports_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChild_Expense_Reports_ReferenceForArrayConstraintsFromSetChild_Expense_Reports_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_WWS_Outbound_DataTypeChild_Expense_Reports_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_WWS_Outbound_DataTypeChild_Expense_Reports_ReferenceItem instanceof \StructType\Expense_ReportObjectType) {
                $invalidValues[] = is_object($expense_Report_WWS_Outbound_DataTypeChild_Expense_Reports_ReferenceItem) ? get_class($expense_Report_WWS_Outbound_DataTypeChild_Expense_Reports_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_WWS_Outbound_DataTypeChild_Expense_Reports_ReferenceItem), var_export($expense_Report_WWS_Outbound_DataTypeChild_Expense_Reports_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Child_Expense_Reports_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Child_Expense_Reports_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType[] $child_Expense_Reports_Reference
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setChild_Expense_Reports_Reference(array $child_Expense_Reports_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($child_Expense_Reports_ReferenceArrayErrorMessage = self::validateChild_Expense_Reports_ReferenceForArrayConstraintsFromSetChild_Expense_Reports_Reference($child_Expense_Reports_Reference))) {
            throw new \InvalidArgumentException($child_Expense_Reports_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Child_Expense_Reports_Reference = $child_Expense_Reports_Reference;
        return $this;
    }
    /**
     * Add item to Child_Expense_Reports_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType $item
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function addToChild_Expense_Reports_Reference(\StructType\Expense_ReportObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ReportObjectType) {
            throw new \InvalidArgumentException(sprintf('The Child_Expense_Reports_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Child_Expense_Reports_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Report_Lines_Reference_Data value
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType[]|null
     */
    public function getExpense_Report_Lines_Reference_Data()
    {
        return $this->Expense_Report_Lines_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Report_Lines_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Report_Lines_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Report_Lines_Reference_DataForArrayConstraintsFromSetExpense_Report_Lines_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_WWS_Outbound_DataTypeExpense_Report_Lines_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_WWS_Outbound_DataTypeExpense_Report_Lines_Reference_DataItem instanceof \StructType\Expense_Report_Line_WWS_Outbound_DataType) {
                $invalidValues[] = is_object($expense_Report_WWS_Outbound_DataTypeExpense_Report_Lines_Reference_DataItem) ? get_class($expense_Report_WWS_Outbound_DataTypeExpense_Report_Lines_Reference_DataItem) : sprintf('%s(%s)', gettype($expense_Report_WWS_Outbound_DataTypeExpense_Report_Lines_Reference_DataItem), var_export($expense_Report_WWS_Outbound_DataTypeExpense_Report_Lines_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Report_Lines_Reference_Data property can only contain items of type \StructType\Expense_Report_Line_WWS_Outbound_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Report_Lines_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Report_Line_WWS_Outbound_DataType[] $expense_Report_Lines_Reference_Data
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setExpense_Report_Lines_Reference_Data(array $expense_Report_Lines_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Report_Lines_Reference_DataArrayErrorMessage = self::validateExpense_Report_Lines_Reference_DataForArrayConstraintsFromSetExpense_Report_Lines_Reference_Data($expense_Report_Lines_Reference_Data))) {
            throw new \InvalidArgumentException($expense_Report_Lines_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Report_Lines_Reference_Data = $expense_Report_Lines_Reference_Data;
        return $this;
    }
    /**
     * Add item to Expense_Report_Lines_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Report_Line_WWS_Outbound_DataType $item
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function addToExpense_Report_Lines_Reference_Data(\StructType\Expense_Report_Line_WWS_Outbound_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Report_Line_WWS_Outbound_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Report_Lines_Reference_Data property can only contain items of type \StructType\Expense_Report_Line_WWS_Outbound_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Report_Lines_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_WWS_Outbound_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_WWS_Outbound_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($expense_Report_WWS_Outbound_DataTypeAttachment_DataItem) ? get_class($expense_Report_WWS_Outbound_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($expense_Report_WWS_Outbound_DataTypeAttachment_DataItem), var_export($expense_Report_WWS_Outbound_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Expense_Report_WWS_Outbound_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
