<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Entity_Contact_Personal_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Usage Type is Invalid for this Contactable. | Business Entity Contact Data
 * @subpackage Structs
 */
class Business_Entity_Contact_Personal_DataType extends AbstractStructBase
{
    /**
     * The Name_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element for all of the Name data for a person.
     * - maxOccurs: unbounded
     * @var \StructType\Legal_Name_DataType[]
     */
    public $Name_Data;
    /**
     * The Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: Contact Data
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType
     */
    public $Contact_Data;
    /**
     * Constructor method for Business_Entity_Contact_Personal_DataType
     * @uses Business_Entity_Contact_Personal_DataType::setName_Data()
     * @uses Business_Entity_Contact_Personal_DataType::setContact_Data()
     * @param \StructType\Legal_Name_DataType[] $name_Data
     * @param \StructType\Contact_Information_DataType $contact_Data
     */
    public function __construct(array $name_Data = array(), \StructType\Contact_Information_DataType $contact_Data = null)
    {
        $this
            ->setName_Data($name_Data)
            ->setContact_Data($contact_Data);
    }
    /**
     * Get Name_Data value
     * @return \StructType\Legal_Name_DataType[]|null
     */
    public function getName_Data()
    {
        return $this->Name_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setName_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateName_DataForArrayConstraintsFromSetName_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Entity_Contact_Personal_DataTypeName_DataItem) {
            // validation for constraint: itemType
            if (!$business_Entity_Contact_Personal_DataTypeName_DataItem instanceof \StructType\Legal_Name_DataType) {
                $invalidValues[] = is_object($business_Entity_Contact_Personal_DataTypeName_DataItem) ? get_class($business_Entity_Contact_Personal_DataTypeName_DataItem) : sprintf('%s(%s)', gettype($business_Entity_Contact_Personal_DataTypeName_DataItem), var_export($business_Entity_Contact_Personal_DataTypeName_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Name_Data property can only contain items of type \StructType\Legal_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Legal_Name_DataType[] $name_Data
     * @return \StructType\Business_Entity_Contact_Personal_DataType
     */
    public function setName_Data(array $name_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($name_DataArrayErrorMessage = self::validateName_DataForArrayConstraintsFromSetName_Data($name_Data))) {
            throw new \InvalidArgumentException($name_DataArrayErrorMessage, __LINE__);
        }
        $this->Name_Data = $name_Data;
        return $this;
    }
    /**
     * Add item to Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Legal_Name_DataType $item
     * @return \StructType\Business_Entity_Contact_Personal_DataType
     */
    public function addToName_Data(\StructType\Legal_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Legal_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Name_Data property can only contain items of type \StructType\Legal_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Name_Data[] = $item;
        return $this;
    }
    /**
     * Get Contact_Data value
     * @return \StructType\Contact_Information_DataType|null
     */
    public function getContact_Data()
    {
        return $this->Contact_Data;
    }
    /**
     * Set Contact_Data value
     * @param \StructType\Contact_Information_DataType $contact_Data
     * @return \StructType\Business_Entity_Contact_Personal_DataType
     */
    public function setContact_Data(\StructType\Contact_Information_DataType $contact_Data = null)
    {
        $this->Contact_Data = $contact_Data;
        return $this;
    }
}
