<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_Configuration_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains all the Asset Depreciation Schedules returned by the web service operation.
 * @subpackage Structs
 */
class Asset_Book_Configuration_Response_DataType extends AbstractStructBase
{
    /**
     * The Asset_Book_Configuration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Depreciation_ScheduleType[]
     */
    public $Asset_Book_Configuration;
    /**
     * Constructor method for Asset_Book_Configuration_Response_DataType
     * @uses Asset_Book_Configuration_Response_DataType::setAsset_Book_Configuration()
     * @param \StructType\Asset_Depreciation_ScheduleType[] $asset_Book_Configuration
     */
    public function __construct(array $asset_Book_Configuration = array())
    {
        $this
            ->setAsset_Book_Configuration($asset_Book_Configuration);
    }
    /**
     * Get Asset_Book_Configuration value
     * @return \StructType\Asset_Depreciation_ScheduleType[]|null
     */
    public function getAsset_Book_Configuration()
    {
        return $this->Asset_Book_Configuration;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Configuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Configuration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_ConfigurationForArrayConstraintsFromSetAsset_Book_Configuration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_Configuration_Response_DataTypeAsset_Book_ConfigurationItem) {
            // validation for constraint: itemType
            if (!$asset_Book_Configuration_Response_DataTypeAsset_Book_ConfigurationItem instanceof \StructType\Asset_Depreciation_ScheduleType) {
                $invalidValues[] = is_object($asset_Book_Configuration_Response_DataTypeAsset_Book_ConfigurationItem) ? get_class($asset_Book_Configuration_Response_DataTypeAsset_Book_ConfigurationItem) : sprintf('%s(%s)', gettype($asset_Book_Configuration_Response_DataTypeAsset_Book_ConfigurationItem), var_export($asset_Book_Configuration_Response_DataTypeAsset_Book_ConfigurationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Configuration property can only contain items of type \StructType\Asset_Depreciation_ScheduleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Configuration value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_ScheduleType[] $asset_Book_Configuration
     * @return \StructType\Asset_Book_Configuration_Response_DataType
     */
    public function setAsset_Book_Configuration(array $asset_Book_Configuration = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_ConfigurationArrayErrorMessage = self::validateAsset_Book_ConfigurationForArrayConstraintsFromSetAsset_Book_Configuration($asset_Book_Configuration))) {
            throw new \InvalidArgumentException($asset_Book_ConfigurationArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Configuration = $asset_Book_Configuration;
        return $this;
    }
    /**
     * Add item to Asset_Book_Configuration value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_ScheduleType $item
     * @return \StructType\Asset_Book_Configuration_Response_DataType
     */
    public function addToAsset_Book_Configuration(\StructType\Asset_Depreciation_ScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Depreciation_ScheduleType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Configuration property can only contain items of type \StructType\Asset_Depreciation_ScheduleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Configuration[] = $item;
        return $this;
    }
}
