<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Forecast__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element for Import Resource Forecast High Volume Web Service. This element represents header (Resource Forecast) data.
 * @subpackage Structs
 */
class Resource_Forecast__HV__DataType extends AbstractStructBase
{
    /**
     * The Resource_Forecast_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Forecast_ID;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Reference
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Resource_Forecast_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Configuration Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Forecast_Configuration_DataType[]
     */
    public $Resource_Forecast_Configuration_Data;
    /**
     * The Resource_Forecast_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Forecast Line Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Forecast_Line__HV__DataType[]
     */
    public $Resource_Forecast_Line_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: If Replace All is set to True, a full sync will be performed once the web service is submitted.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Resource_Forecast__HV__DataType
     * @uses Resource_Forecast__HV__DataType::setResource_Forecast_ID()
     * @uses Resource_Forecast__HV__DataType::setProject_Reference()
     * @uses Resource_Forecast__HV__DataType::setResource_Forecast_Configuration_Data()
     * @uses Resource_Forecast__HV__DataType::setResource_Forecast_Line_Data()
     * @uses Resource_Forecast__HV__DataType::setReplace_All()
     * @param string $resource_Forecast_ID
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Resource_Forecast_Configuration_DataType[] $resource_Forecast_Configuration_Data
     * @param \StructType\Resource_Forecast_Line__HV__DataType[] $resource_Forecast_Line_Data
     * @param bool $replace_All
     */
    public function __construct($resource_Forecast_ID = null, \StructType\ProjectObjectType $project_Reference = null, array $resource_Forecast_Configuration_Data = array(), array $resource_Forecast_Line_Data = array(), $replace_All = null)
    {
        $this
            ->setResource_Forecast_ID($resource_Forecast_ID)
            ->setProject_Reference($project_Reference)
            ->setResource_Forecast_Configuration_Data($resource_Forecast_Configuration_Data)
            ->setResource_Forecast_Line_Data($resource_Forecast_Line_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Resource_Forecast_ID value
     * @return string|null
     */
    public function getResource_Forecast_ID()
    {
        return $this->Resource_Forecast_ID;
    }
    /**
     * Set Resource_Forecast_ID value
     * @param string $resource_Forecast_ID
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function setResource_Forecast_ID($resource_Forecast_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Forecast_ID) && !is_string($resource_Forecast_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Forecast_ID, true), gettype($resource_Forecast_ID)), __LINE__);
        }
        $this->Resource_Forecast_ID = $resource_Forecast_ID;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Resource_Forecast_Configuration_Data value
     * @return \StructType\Resource_Forecast_Configuration_DataType[]|null
     */
    public function getResource_Forecast_Configuration_Data()
    {
        return $this->Resource_Forecast_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_Configuration_DataForArrayConstraintsFromSetResource_Forecast_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Forecast_HV_DataTypeResource_Forecast_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Forecast_HV_DataTypeResource_Forecast_Configuration_DataItem instanceof \StructType\Resource_Forecast_Configuration_DataType) {
                $invalidValues[] = is_object($resource_Forecast_HV_DataTypeResource_Forecast_Configuration_DataItem) ? get_class($resource_Forecast_HV_DataTypeResource_Forecast_Configuration_DataItem) : sprintf('%s(%s)', gettype($resource_Forecast_HV_DataTypeResource_Forecast_Configuration_DataItem), var_export($resource_Forecast_HV_DataTypeResource_Forecast_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Configuration_Data property can only contain items of type \StructType\Resource_Forecast_Configuration_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Configuration_DataType[] $resource_Forecast_Configuration_Data
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function setResource_Forecast_Configuration_Data(array $resource_Forecast_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_Configuration_DataArrayErrorMessage = self::validateResource_Forecast_Configuration_DataForArrayConstraintsFromSetResource_Forecast_Configuration_Data($resource_Forecast_Configuration_Data))) {
            throw new \InvalidArgumentException($resource_Forecast_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Configuration_Data = $resource_Forecast_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Configuration_DataType $item
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function addToResource_Forecast_Configuration_Data(\StructType\Resource_Forecast_Configuration_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Forecast_Configuration_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Configuration_Data property can only contain items of type \StructType\Resource_Forecast_Configuration_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Configuration_Data[] = $item;
        return $this;
    }
    /**
     * Get Resource_Forecast_Line_Data value
     * @return \StructType\Resource_Forecast_Line__HV__DataType[]|null
     */
    public function getResource_Forecast_Line_Data()
    {
        return $this->Resource_Forecast_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Forecast_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Forecast_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Forecast_Line_DataForArrayConstraintsFromSetResource_Forecast_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Forecast_HV_DataTypeResource_Forecast_Line_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Forecast_HV_DataTypeResource_Forecast_Line_DataItem instanceof \StructType\Resource_Forecast_Line__HV__DataType) {
                $invalidValues[] = is_object($resource_Forecast_HV_DataTypeResource_Forecast_Line_DataItem) ? get_class($resource_Forecast_HV_DataTypeResource_Forecast_Line_DataItem) : sprintf('%s(%s)', gettype($resource_Forecast_HV_DataTypeResource_Forecast_Line_DataItem), var_export($resource_Forecast_HV_DataTypeResource_Forecast_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Forecast_Line_Data property can only contain items of type \StructType\Resource_Forecast_Line__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Forecast_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Line__HV__DataType[] $resource_Forecast_Line_Data
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function setResource_Forecast_Line_Data(array $resource_Forecast_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Forecast_Line_DataArrayErrorMessage = self::validateResource_Forecast_Line_DataForArrayConstraintsFromSetResource_Forecast_Line_Data($resource_Forecast_Line_Data))) {
            throw new \InvalidArgumentException($resource_Forecast_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Forecast_Line_Data = $resource_Forecast_Line_Data;
        return $this;
    }
    /**
     * Add item to Resource_Forecast_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Forecast_Line__HV__DataType $item
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function addToResource_Forecast_Line_Data(\StructType\Resource_Forecast_Line__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Forecast_Line__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Forecast_Line_Data property can only contain items of type \StructType\Resource_Forecast_Line__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Forecast_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Resource_Forecast__HV__DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
