<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequisitionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Requisition Response Data
 * @subpackage Structs
 */
class RequisitionType extends AbstractStructBase
{
    /**
     * The Requisition_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Requisition
     * - minOccurs: 0
     * @var \StructType\RequisitionObjectType
     */
    public $Requisition_Reference;
    /**
     * The Requisition_data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Requisition data. A Requisition may have multiple goods and deliverable Requisition lines. A Requisition also supports service lines v24.0 onwards.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_DataType[]
     */
    public $Requisition_data;
    /**
     * Constructor method for RequisitionType
     * @uses RequisitionType::setRequisition_Reference()
     * @uses RequisitionType::setRequisition_data()
     * @param \StructType\RequisitionObjectType $requisition_Reference
     * @param \StructType\Requisition_DataType[] $requisition_data
     */
    public function __construct(\StructType\RequisitionObjectType $requisition_Reference = null, array $requisition_data = array())
    {
        $this
            ->setRequisition_Reference($requisition_Reference)
            ->setRequisition_data($requisition_data);
    }
    /**
     * Get Requisition_Reference value
     * @return \StructType\RequisitionObjectType|null
     */
    public function getRequisition_Reference()
    {
        return $this->Requisition_Reference;
    }
    /**
     * Set Requisition_Reference value
     * @param \StructType\RequisitionObjectType $requisition_Reference
     * @return \StructType\RequisitionType
     */
    public function setRequisition_Reference(\StructType\RequisitionObjectType $requisition_Reference = null)
    {
        $this->Requisition_Reference = $requisition_Reference;
        return $this;
    }
    /**
     * Get Requisition_data value
     * @return \StructType\Requisition_DataType[]|null
     */
    public function getRequisition_data()
    {
        return $this->Requisition_data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_dataForArrayConstraintsFromSetRequisition_data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisitionTypeRequisition_dataItem) {
            // validation for constraint: itemType
            if (!$requisitionTypeRequisition_dataItem instanceof \StructType\Requisition_DataType) {
                $invalidValues[] = is_object($requisitionTypeRequisition_dataItem) ? get_class($requisitionTypeRequisition_dataItem) : sprintf('%s(%s)', gettype($requisitionTypeRequisition_dataItem), var_export($requisitionTypeRequisition_dataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_data property can only contain items of type \StructType\Requisition_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_DataType[] $requisition_data
     * @return \StructType\RequisitionType
     */
    public function setRequisition_data(array $requisition_data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_dataArrayErrorMessage = self::validateRequisition_dataForArrayConstraintsFromSetRequisition_data($requisition_data))) {
            throw new \InvalidArgumentException($requisition_dataArrayErrorMessage, __LINE__);
        }
        $this->Requisition_data = $requisition_data;
        return $this;
    }
    /**
     * Add item to Requisition_data value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_DataType $item
     * @return \StructType\RequisitionType
     */
    public function addToRequisition_data(\StructType\Requisition_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_data property can only contain items of type \StructType\Requisition_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_data[] = $item;
        return $this;
    }
}
