<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the data requested in the GET Project Plan web service request
 * @subpackage Structs
 */
class Project_Plan_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan
     * Meta information extracted from the WSDL
     * - documentation: Element wrapping all project plan information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_PlanType[]
     */
    public $Project_Plan;
    /**
     * Constructor method for Project_Plan_Response_DataType
     * @uses Project_Plan_Response_DataType::setProject_Plan()
     * @param \StructType\Project_PlanType[] $project_Plan
     */
    public function __construct(array $project_Plan = array())
    {
        $this
            ->setProject_Plan($project_Plan);
    }
    /**
     * Get Project_Plan value
     * @return \StructType\Project_PlanType[]|null
     */
    public function getProject_Plan()
    {
        return $this->Project_Plan;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_PlanForArrayConstraintsFromSetProject_Plan(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Response_DataTypeProject_PlanItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Response_DataTypeProject_PlanItem instanceof \StructType\Project_PlanType) {
                $invalidValues[] = is_object($project_Plan_Response_DataTypeProject_PlanItem) ? get_class($project_Plan_Response_DataTypeProject_PlanItem) : sprintf('%s(%s)', gettype($project_Plan_Response_DataTypeProject_PlanItem), var_export($project_Plan_Response_DataTypeProject_PlanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan property can only contain items of type \StructType\Project_PlanType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_PlanType[] $project_Plan
     * @return \StructType\Project_Plan_Response_DataType
     */
    public function setProject_Plan(array $project_Plan = array())
    {
        // validation for constraint: array
        if ('' !== ($project_PlanArrayErrorMessage = self::validateProject_PlanForArrayConstraintsFromSetProject_Plan($project_Plan))) {
            throw new \InvalidArgumentException($project_PlanArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan = $project_Plan;
        return $this;
    }
    /**
     * Add item to Project_Plan value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_PlanType $item
     * @return \StructType\Project_Plan_Response_DataType
     */
    public function addToProject_Plan(\StructType\Project_PlanType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_PlanType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan property can only contain items of type \StructType\Project_PlanType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan[] = $item;
        return $this;
    }
}
