<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Intermediary_Bank_Account_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for all Intermediary Bank Accounts. Here the customer can define if Bank Accounts are meant to be replaced by the ones on the request or added/deleted in a more granular way.
 * @subpackage Structs
 */
class Intermediary_Bank_Account_Widget_DataType extends AbstractStructBase
{
    /**
     * The Intermediary_Bank_Data
     * Meta information extracted from the WSDL
     * - documentation: Intermediary Bank Account information including Order, Bank Account Type, Currency, Routing Transit Number, etc.
     * - maxOccurs: unbounded
     * @var \StructType\Intermediary_Bank_Account_DataType[]
     */
    public $Intermediary_Bank_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Set this flag to True if you wish to allow the Intermediary Bank Accounts to be Added or individually deleted, otherwise all of this object's Bank Accounts will be deleted and replaced by the bank accounts sent in the request.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Intermediary_Bank_Account_Widget_DataType
     * @uses Intermediary_Bank_Account_Widget_DataType::setIntermediary_Bank_Data()
     * @uses Intermediary_Bank_Account_Widget_DataType::setReplace_All()
     * @param \StructType\Intermediary_Bank_Account_DataType[] $intermediary_Bank_Data
     * @param bool $replace_All
     */
    public function __construct(array $intermediary_Bank_Data = array(), $replace_All = null)
    {
        $this
            ->setIntermediary_Bank_Data($intermediary_Bank_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Intermediary_Bank_Data value
     * @return \StructType\Intermediary_Bank_Account_DataType[]|null
     */
    public function getIntermediary_Bank_Data()
    {
        return $this->Intermediary_Bank_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setIntermediary_Bank_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIntermediary_Bank_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIntermediary_Bank_DataForArrayConstraintsFromSetIntermediary_Bank_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $intermediary_Bank_Account_Widget_DataTypeIntermediary_Bank_DataItem) {
            // validation for constraint: itemType
            if (!$intermediary_Bank_Account_Widget_DataTypeIntermediary_Bank_DataItem instanceof \StructType\Intermediary_Bank_Account_DataType) {
                $invalidValues[] = is_object($intermediary_Bank_Account_Widget_DataTypeIntermediary_Bank_DataItem) ? get_class($intermediary_Bank_Account_Widget_DataTypeIntermediary_Bank_DataItem) : sprintf('%s(%s)', gettype($intermediary_Bank_Account_Widget_DataTypeIntermediary_Bank_DataItem), var_export($intermediary_Bank_Account_Widget_DataTypeIntermediary_Bank_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Intermediary_Bank_Data property can only contain items of type \StructType\Intermediary_Bank_Account_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Intermediary_Bank_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Intermediary_Bank_Account_DataType[] $intermediary_Bank_Data
     * @return \StructType\Intermediary_Bank_Account_Widget_DataType
     */
    public function setIntermediary_Bank_Data(array $intermediary_Bank_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($intermediary_Bank_DataArrayErrorMessage = self::validateIntermediary_Bank_DataForArrayConstraintsFromSetIntermediary_Bank_Data($intermediary_Bank_Data))) {
            throw new \InvalidArgumentException($intermediary_Bank_DataArrayErrorMessage, __LINE__);
        }
        $this->Intermediary_Bank_Data = $intermediary_Bank_Data;
        return $this;
    }
    /**
     * Add item to Intermediary_Bank_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Intermediary_Bank_Account_DataType $item
     * @return \StructType\Intermediary_Bank_Account_Widget_DataType
     */
    public function addToIntermediary_Bank_Data(\StructType\Intermediary_Bank_Account_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Intermediary_Bank_Account_DataType) {
            throw new \InvalidArgumentException(sprintf('The Intermediary_Bank_Data property can only contain items of type \StructType\Intermediary_Bank_Account_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Intermediary_Bank_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Intermediary_Bank_Account_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
