<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest_Listing_File_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes guest instance and data
 * @subpackage Structs
 */
class Guest_Listing_File_WWSType extends AbstractStructBase
{
    /**
     * The Guest_Listing_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes guest instance and data
     * - minOccurs: 0
     * @var \StructType\Guest_Listing_FileObjectType
     */
    public $Guest_Listing_File_Reference;
    /**
     * The Guest_Listing_File_Number
     * Meta information extracted from the WSDL
     * - documentation: Guest Listing File Number. This is the Guest Listing File unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guest_Listing_File_Number;
    /**
     * The Guest_Listing_File_Name
     * Meta information extracted from the WSDL
     * - documentation: Guest Listing File Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guest_Listing_File_Name;
    /**
     * The Guest_Listing_File_Date
     * Meta information extracted from the WSDL
     * - documentation: Guest Listing File Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Guest_Listing_File_Date;
    /**
     * The Guest_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Guest data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_WWSType[]
     */
    public $Guest_Data;
    /**
     * The Guest_Listing_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Guest Listing File Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_Listing_File_DataType[]
     */
    public $Guest_Listing_File_Data;
    /**
     * Constructor method for Guest_Listing_File_WWSType
     * @uses Guest_Listing_File_WWSType::setGuest_Listing_File_Reference()
     * @uses Guest_Listing_File_WWSType::setGuest_Listing_File_Number()
     * @uses Guest_Listing_File_WWSType::setGuest_Listing_File_Name()
     * @uses Guest_Listing_File_WWSType::setGuest_Listing_File_Date()
     * @uses Guest_Listing_File_WWSType::setGuest_Data()
     * @uses Guest_Listing_File_WWSType::setGuest_Listing_File_Data()
     * @param \StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference
     * @param string $guest_Listing_File_Number
     * @param string $guest_Listing_File_Name
     * @param string $guest_Listing_File_Date
     * @param \StructType\Guest_WWSType[] $guest_Data
     * @param \StructType\Guest_Listing_File_DataType[] $guest_Listing_File_Data
     */
    public function __construct(\StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference = null, $guest_Listing_File_Number = null, $guest_Listing_File_Name = null, $guest_Listing_File_Date = null, array $guest_Data = array(), array $guest_Listing_File_Data = array())
    {
        $this
            ->setGuest_Listing_File_Reference($guest_Listing_File_Reference)
            ->setGuest_Listing_File_Number($guest_Listing_File_Number)
            ->setGuest_Listing_File_Name($guest_Listing_File_Name)
            ->setGuest_Listing_File_Date($guest_Listing_File_Date)
            ->setGuest_Data($guest_Data)
            ->setGuest_Listing_File_Data($guest_Listing_File_Data);
    }
    /**
     * Get Guest_Listing_File_Reference value
     * @return \StructType\Guest_Listing_FileObjectType|null
     */
    public function getGuest_Listing_File_Reference()
    {
        return $this->Guest_Listing_File_Reference;
    }
    /**
     * Set Guest_Listing_File_Reference value
     * @param \StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function setGuest_Listing_File_Reference(\StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference = null)
    {
        $this->Guest_Listing_File_Reference = $guest_Listing_File_Reference;
        return $this;
    }
    /**
     * Get Guest_Listing_File_Number value
     * @return string|null
     */
    public function getGuest_Listing_File_Number()
    {
        return $this->Guest_Listing_File_Number;
    }
    /**
     * Set Guest_Listing_File_Number value
     * @param string $guest_Listing_File_Number
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function setGuest_Listing_File_Number($guest_Listing_File_Number = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Listing_File_Number) && !is_string($guest_Listing_File_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Listing_File_Number, true), gettype($guest_Listing_File_Number)), __LINE__);
        }
        $this->Guest_Listing_File_Number = $guest_Listing_File_Number;
        return $this;
    }
    /**
     * Get Guest_Listing_File_Name value
     * @return string|null
     */
    public function getGuest_Listing_File_Name()
    {
        return $this->Guest_Listing_File_Name;
    }
    /**
     * Set Guest_Listing_File_Name value
     * @param string $guest_Listing_File_Name
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function setGuest_Listing_File_Name($guest_Listing_File_Name = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Listing_File_Name) && !is_string($guest_Listing_File_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Listing_File_Name, true), gettype($guest_Listing_File_Name)), __LINE__);
        }
        $this->Guest_Listing_File_Name = $guest_Listing_File_Name;
        return $this;
    }
    /**
     * Get Guest_Listing_File_Date value
     * @return string|null
     */
    public function getGuest_Listing_File_Date()
    {
        return $this->Guest_Listing_File_Date;
    }
    /**
     * Set Guest_Listing_File_Date value
     * @param string $guest_Listing_File_Date
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function setGuest_Listing_File_Date($guest_Listing_File_Date = null)
    {
        // validation for constraint: string
        if (!is_null($guest_Listing_File_Date) && !is_string($guest_Listing_File_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guest_Listing_File_Date, true), gettype($guest_Listing_File_Date)), __LINE__);
        }
        $this->Guest_Listing_File_Date = $guest_Listing_File_Date;
        return $this;
    }
    /**
     * Get Guest_Data value
     * @return \StructType\Guest_WWSType[]|null
     */
    public function getGuest_Data()
    {
        return $this->Guest_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuest_DataForArrayConstraintsFromSetGuest_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guest_Listing_File_WWSTypeGuest_DataItem) {
            // validation for constraint: itemType
            if (!$guest_Listing_File_WWSTypeGuest_DataItem instanceof \StructType\Guest_WWSType) {
                $invalidValues[] = is_object($guest_Listing_File_WWSTypeGuest_DataItem) ? get_class($guest_Listing_File_WWSTypeGuest_DataItem) : sprintf('%s(%s)', gettype($guest_Listing_File_WWSTypeGuest_DataItem), var_export($guest_Listing_File_WWSTypeGuest_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest_Data property can only contain items of type \StructType\Guest_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_WWSType[] $guest_Data
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function setGuest_Data(array $guest_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($guest_DataArrayErrorMessage = self::validateGuest_DataForArrayConstraintsFromSetGuest_Data($guest_Data))) {
            throw new \InvalidArgumentException($guest_DataArrayErrorMessage, __LINE__);
        }
        $this->Guest_Data = $guest_Data;
        return $this;
    }
    /**
     * Add item to Guest_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_WWSType $item
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function addToGuest_Data(\StructType\Guest_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Guest_Data property can only contain items of type \StructType\Guest_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest_Data[] = $item;
        return $this;
    }
    /**
     * Get Guest_Listing_File_Data value
     * @return \StructType\Guest_Listing_File_DataType[]|null
     */
    public function getGuest_Listing_File_Data()
    {
        return $this->Guest_Listing_File_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest_Listing_File_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest_Listing_File_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuest_Listing_File_DataForArrayConstraintsFromSetGuest_Listing_File_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guest_Listing_File_WWSTypeGuest_Listing_File_DataItem) {
            // validation for constraint: itemType
            if (!$guest_Listing_File_WWSTypeGuest_Listing_File_DataItem instanceof \StructType\Guest_Listing_File_DataType) {
                $invalidValues[] = is_object($guest_Listing_File_WWSTypeGuest_Listing_File_DataItem) ? get_class($guest_Listing_File_WWSTypeGuest_Listing_File_DataItem) : sprintf('%s(%s)', gettype($guest_Listing_File_WWSTypeGuest_Listing_File_DataItem), var_export($guest_Listing_File_WWSTypeGuest_Listing_File_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest_Listing_File_Data property can only contain items of type \StructType\Guest_Listing_File_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest_Listing_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_Listing_File_DataType[] $guest_Listing_File_Data
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function setGuest_Listing_File_Data(array $guest_Listing_File_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($guest_Listing_File_DataArrayErrorMessage = self::validateGuest_Listing_File_DataForArrayConstraintsFromSetGuest_Listing_File_Data($guest_Listing_File_Data))) {
            throw new \InvalidArgumentException($guest_Listing_File_DataArrayErrorMessage, __LINE__);
        }
        $this->Guest_Listing_File_Data = $guest_Listing_File_Data;
        return $this;
    }
    /**
     * Add item to Guest_Listing_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_Listing_File_DataType $item
     * @return \StructType\Guest_Listing_File_WWSType
     */
    public function addToGuest_Listing_File_Data(\StructType\Guest_Listing_File_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_Listing_File_DataType) {
            throw new \InvalidArgumentException(sprintf('The Guest_Listing_File_Data property can only contain items of type \StructType\Guest_Listing_File_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest_Listing_File_Data[] = $item;
        return $this;
    }
}
